/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's calendar URL.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarUrl extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The type of the calendar URL translated and formatted in the viewer's account
   * locale or the `Accept-Language` HTTP header locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedType;

  /**
   * Metadata about the calendar URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The type of the calendar URL. The type can be custom or one of these predefined values: *
   * `home` * `freeBusy` * `work`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The calendar URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * Output only. The type of the calendar URL translated and formatted in the viewer's account
   * locale or the `Accept-Language` HTTP header locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedType() {
    return formattedType;
  }

  /**
   * Output only. The type of the calendar URL translated and formatted in the viewer's account
   * locale or the `Accept-Language` HTTP header locale.
   * @param formattedType formattedType or {@code null} for none
   */
  public CalendarUrl setFormattedType(java.lang.String formattedType) {
    this.formattedType = formattedType;
    return this;
  }

  /**
   * Metadata about the calendar URL.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the calendar URL.
   * @param metadata metadata or {@code null} for none
   */
  public CalendarUrl setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The type of the calendar URL. The type can be custom or one of these predefined values: *
   * `home` * `freeBusy` * `work`
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the calendar URL. The type can be custom or one of these predefined values: *
   * `home` * `freeBusy` * `work`
   * @param type type or {@code null} for none
   */
  public CalendarUrl setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The calendar URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The calendar URL.
   * @param url url or {@code null} for none
   */
  public CalendarUrl setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public CalendarUrl set(String fieldName, Object value) {
    return (CalendarUrl) super.set(fieldName, value);
  }

  @Override
  public CalendarUrl clone() {
    return (CalendarUrl) super.clone();
  }

}
