/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A contact group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContactGroup extends com.google.api.client.json.GenericJson {

  /**
   * The group's client data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GroupClientData> clientData;

  /**
   * The [HTTP entity tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the resource. Used for web
   * cache validation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Output only. The name translated and formatted in the viewer's account locale or the `Accept-
   * Language` HTTP header locale for system groups names. Group names set by the owner are the same
   * as name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedName;

  /**
   * Output only. The contact group type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String groupType;

  /**
   * Output only. The total number of contacts in the group irrespective of max members in specified
   * in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer memberCount;

  /**
   * Output only. The list of contact person resource names that are members of the contact group.
   * The field is only populated for GET requests and will only return as many members as
   * `maxMembers` in the get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> memberResourceNames;

  /**
   * Output only. Metadata about the contact group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContactGroupMetadata metadata;

  /**
   * The contact group name set by the group owner or a system provided name for system groups. For
   * [`contactGroups.create`](/people/api/rest/v1/contactGroups/create) or
   * [`contactGroups.update`](/people/api/rest/v1/contactGroups/update) the name must be unique to
   * the users contact groups. Attempting to create a group with a duplicate name will return a HTTP
   * 409 error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The resource name for the contact group, assigned by the server. An ASCII string, in the form
   * of `contactGroups/{contact_group_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceName;

  /**
   * The group's client data.
   * @return value or {@code null} for none
   */
  public java.util.List<GroupClientData> getClientData() {
    return clientData;
  }

  /**
   * The group's client data.
   * @param clientData clientData or {@code null} for none
   */
  public ContactGroup setClientData(java.util.List<GroupClientData> clientData) {
    this.clientData = clientData;
    return this;
  }

  /**
   * The [HTTP entity tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the resource. Used for web
   * cache validation.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The [HTTP entity tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the resource. Used for web
   * cache validation.
   * @param etag etag or {@code null} for none
   */
  public ContactGroup setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Output only. The name translated and formatted in the viewer's account locale or the `Accept-
   * Language` HTTP header locale for system groups names. Group names set by the owner are the same
   * as name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedName() {
    return formattedName;
  }

  /**
   * Output only. The name translated and formatted in the viewer's account locale or the `Accept-
   * Language` HTTP header locale for system groups names. Group names set by the owner are the same
   * as name.
   * @param formattedName formattedName or {@code null} for none
   */
  public ContactGroup setFormattedName(java.lang.String formattedName) {
    this.formattedName = formattedName;
    return this;
  }

  /**
   * Output only. The contact group type.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroupType() {
    return groupType;
  }

  /**
   * Output only. The contact group type.
   * @param groupType groupType or {@code null} for none
   */
  public ContactGroup setGroupType(java.lang.String groupType) {
    this.groupType = groupType;
    return this;
  }

  /**
   * Output only. The total number of contacts in the group irrespective of max members in specified
   * in the request.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMemberCount() {
    return memberCount;
  }

  /**
   * Output only. The total number of contacts in the group irrespective of max members in specified
   * in the request.
   * @param memberCount memberCount or {@code null} for none
   */
  public ContactGroup setMemberCount(java.lang.Integer memberCount) {
    this.memberCount = memberCount;
    return this;
  }

  /**
   * Output only. The list of contact person resource names that are members of the contact group.
   * The field is only populated for GET requests and will only return as many members as
   * `maxMembers` in the get request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMemberResourceNames() {
    return memberResourceNames;
  }

  /**
   * Output only. The list of contact person resource names that are members of the contact group.
   * The field is only populated for GET requests and will only return as many members as
   * `maxMembers` in the get request.
   * @param memberResourceNames memberResourceNames or {@code null} for none
   */
  public ContactGroup setMemberResourceNames(java.util.List<java.lang.String> memberResourceNames) {
    this.memberResourceNames = memberResourceNames;
    return this;
  }

  /**
   * Output only. Metadata about the contact group.
   * @return value or {@code null} for none
   */
  public ContactGroupMetadata getMetadata() {
    return metadata;
  }

  /**
   * Output only. Metadata about the contact group.
   * @param metadata metadata or {@code null} for none
   */
  public ContactGroup setMetadata(ContactGroupMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The contact group name set by the group owner or a system provided name for system groups. For
   * [`contactGroups.create`](/people/api/rest/v1/contactGroups/create) or
   * [`contactGroups.update`](/people/api/rest/v1/contactGroups/update) the name must be unique to
   * the users contact groups. Attempting to create a group with a duplicate name will return a HTTP
   * 409 error.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The contact group name set by the group owner or a system provided name for system groups. For
   * [`contactGroups.create`](/people/api/rest/v1/contactGroups/create) or
   * [`contactGroups.update`](/people/api/rest/v1/contactGroups/update) the name must be unique to
   * the users contact groups. Attempting to create a group with a duplicate name will return a HTTP
   * 409 error.
   * @param name name or {@code null} for none
   */
  public ContactGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The resource name for the contact group, assigned by the server. An ASCII string, in the form
   * of `contactGroups/{contact_group_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceName() {
    return resourceName;
  }

  /**
   * The resource name for the contact group, assigned by the server. An ASCII string, in the form
   * of `contactGroups/{contact_group_id}`.
   * @param resourceName resourceName or {@code null} for none
   */
  public ContactGroup setResourceName(java.lang.String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  @Override
  public ContactGroup set(String fieldName, Object value) {
    return (ContactGroup) super.set(fieldName, value);
  }

  @Override
  public ContactGroup clone() {
    return (ContactGroup) super.clone();
  }

}
