/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's cover photo. A large image shown on the person's profile page that represents who they
 * are or what they care about.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CoverPhoto extends com.google.api.client.json.GenericJson {

  /**
   * True if the cover photo is the default cover photo; false if the cover photo is a user-provided
   * cover photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("default")
  private java.lang.Boolean default__;

  /**
   * Metadata about the cover photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The URL of the cover photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * True if the cover photo is the default cover photo; false if the cover photo is a user-provided
   * cover photo.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDefault() {
    return default__;
  }

  /**
   * True if the cover photo is the default cover photo; false if the cover photo is a user-provided
   * cover photo.
   * @param default__ default__ or {@code null} for none
   */
  public CoverPhoto setDefault(java.lang.Boolean default__) {
    this.default__ = default__;
    return this;
  }

  /**
   * Metadata about the cover photo.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the cover photo.
   * @param metadata metadata or {@code null} for none
   */
  public CoverPhoto setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The URL of the cover photo.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The URL of the cover photo.
   * @param url url or {@code null} for none
   */
  public CoverPhoto setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public CoverPhoto set(String fieldName, Object value) {
    return (CoverPhoto) super.set(fieldName, value);
  }

  @Override
  public CoverPhoto clone() {
    return (CoverPhoto) super.clone();
  }

}
