/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The response to a list contact groups request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListContactGroupsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The list of contact groups. Members of the contact groups are not populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ContactGroup> contactGroups;

  static {
    // hack to force ProGuard to consider ContactGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ContactGroup.class);
  }

  /**
   * The token that can be used to retrieve the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The token that can be used to retrieve changes since the last request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextSyncToken;

  /**
   * The total number of items in the list without pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalItems;

  /**
   * The list of contact groups. Members of the contact groups are not populated.
   * @return value or {@code null} for none
   */
  public java.util.List<ContactGroup> getContactGroups() {
    return contactGroups;
  }

  /**
   * The list of contact groups. Members of the contact groups are not populated.
   * @param contactGroups contactGroups or {@code null} for none
   */
  public ListContactGroupsResponse setContactGroups(java.util.List<ContactGroup> contactGroups) {
    this.contactGroups = contactGroups;
    return this;
  }

  /**
   * The token that can be used to retrieve the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token that can be used to retrieve the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListContactGroupsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The token that can be used to retrieve changes since the last request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextSyncToken() {
    return nextSyncToken;
  }

  /**
   * The token that can be used to retrieve changes since the last request.
   * @param nextSyncToken nextSyncToken or {@code null} for none
   */
  public ListContactGroupsResponse setNextSyncToken(java.lang.String nextSyncToken) {
    this.nextSyncToken = nextSyncToken;
    return this;
  }

  /**
   * The total number of items in the list without pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalItems() {
    return totalItems;
  }

  /**
   * The total number of items in the list without pagination.
   * @param totalItems totalItems or {@code null} for none
   */
  public ListContactGroupsResponse setTotalItems(java.lang.Integer totalItems) {
    this.totalItems = totalItems;
    return this;
  }

  @Override
  public ListContactGroupsResponse set(String fieldName, Object value) {
    return (ListContactGroupsResponse) super.set(fieldName, value);
  }

  @Override
  public ListContactGroupsResponse clone() {
    return (ListContactGroupsResponse) super.clone();
  }

}
