/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The response to a request for the authenticated user's "Other contacts".
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListOtherContactsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextSyncToken;

  /**
   * The list of "Other contacts" returned as Person resources. "Other contacts" support a limited
   * subset of fields. See ListOtherContactsRequest.request_mask for more detailed information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Person> otherContacts;

  /**
   * The total number of other contacts in the list without pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListOtherContactsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextSyncToken() {
    return nextSyncToken;
  }

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token.
   * @param nextSyncToken nextSyncToken or {@code null} for none
   */
  public ListOtherContactsResponse setNextSyncToken(java.lang.String nextSyncToken) {
    this.nextSyncToken = nextSyncToken;
    return this;
  }

  /**
   * The list of "Other contacts" returned as Person resources. "Other contacts" support a limited
   * subset of fields. See ListOtherContactsRequest.request_mask for more detailed information.
   * @return value or {@code null} for none
   */
  public java.util.List<Person> getOtherContacts() {
    return otherContacts;
  }

  /**
   * The list of "Other contacts" returned as Person resources. "Other contacts" support a limited
   * subset of fields. See ListOtherContactsRequest.request_mask for more detailed information.
   * @param otherContacts otherContacts or {@code null} for none
   */
  public ListOtherContactsResponse setOtherContacts(java.util.List<Person> otherContacts) {
    this.otherContacts = otherContacts;
    return this;
  }

  /**
   * The total number of other contacts in the list without pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The total number of other contacts in the list without pagination.
   * @param totalSize totalSize or {@code null} for none
   */
  public ListOtherContactsResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  @Override
  public ListOtherContactsResponse set(String fieldName, Object value) {
    return (ListOtherContactsResponse) super.set(fieldName, value);
  }

  @Override
  public ListOtherContactsResponse clone() {
    return (ListOtherContactsResponse) super.clone();
  }

}
