/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The metadata about a person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PersonMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Output only. True if the person resource has been deleted. Populated only for
   * `people.connections.list` and `otherContacts.list` sync requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Output only. Resource names of people linked to this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> linkedPeopleResourceNames;

  /**
   * Output only. **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType`
   * instead) The type of the person object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectType;

  /**
   * Output only. Any former resource names this person has had. Populated only for
   * `people.connections.list` requests that include a sync token. The resource name may change when
   * adding or removing fields that link a contact and profile such as a verified email, verified
   * phone number, or profile URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> previousResourceNames;

  /**
   * The sources of data for the person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Source> sources;

  /**
   * Output only. True if the person resource has been deleted. Populated only for
   * `people.connections.list` and `otherContacts.list` sync requests.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. True if the person resource has been deleted. Populated only for
   * `people.connections.list` and `otherContacts.list` sync requests.
   * @param deleted deleted or {@code null} for none
   */
  public PersonMetadata setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Output only. Resource names of people linked to this resource.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLinkedPeopleResourceNames() {
    return linkedPeopleResourceNames;
  }

  /**
   * Output only. Resource names of people linked to this resource.
   * @param linkedPeopleResourceNames linkedPeopleResourceNames or {@code null} for none
   */
  public PersonMetadata setLinkedPeopleResourceNames(java.util.List<java.lang.String> linkedPeopleResourceNames) {
    this.linkedPeopleResourceNames = linkedPeopleResourceNames;
    return this;
  }

  /**
   * Output only. **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType`
   * instead) The type of the person object.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectType() {
    return objectType;
  }

  /**
   * Output only. **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType`
   * instead) The type of the person object.
   * @param objectType objectType or {@code null} for none
   */
  public PersonMetadata setObjectType(java.lang.String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * Output only. Any former resource names this person has had. Populated only for
   * `people.connections.list` requests that include a sync token. The resource name may change when
   * adding or removing fields that link a contact and profile such as a verified email, verified
   * phone number, or profile URL.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPreviousResourceNames() {
    return previousResourceNames;
  }

  /**
   * Output only. Any former resource names this person has had. Populated only for
   * `people.connections.list` requests that include a sync token. The resource name may change when
   * adding or removing fields that link a contact and profile such as a verified email, verified
   * phone number, or profile URL.
   * @param previousResourceNames previousResourceNames or {@code null} for none
   */
  public PersonMetadata setPreviousResourceNames(java.util.List<java.lang.String> previousResourceNames) {
    this.previousResourceNames = previousResourceNames;
    return this;
  }

  /**
   * The sources of data for the person.
   * @return value or {@code null} for none
   */
  public java.util.List<Source> getSources() {
    return sources;
  }

  /**
   * The sources of data for the person.
   * @param sources sources or {@code null} for none
   */
  public PersonMetadata setSources(java.util.List<Source> sources) {
    this.sources = sources;
    return this;
  }

  @Override
  public PersonMetadata set(String fieldName, Object value) {
    return (PersonMetadata) super.set(fieldName, value);
  }

  @Override
  public PersonMetadata clone() {
    return (PersonMetadata) super.clone();
  }

}
