/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The source of a field.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Source extends com.google.api.client.json.GenericJson {

  /**
   * **Only populated in `person.metadata.sources`.** The [HTTP entity
   * tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the source. Used for web cache validation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The unique identifier within the source type generated by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Metadata about a source of type
   * PROFILE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileMetadata profileMetadata;

  /**
   * The source type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Last update timestamp of this
   * source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * **Only populated in `person.metadata.sources`.** The [HTTP entity
   * tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the source. Used for web cache validation.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * **Only populated in `person.metadata.sources`.** The [HTTP entity
   * tag](https://en.wikipedia.org/wiki/HTTP_ETag) of the source. Used for web cache validation.
   * @param etag etag or {@code null} for none
   */
  public Source setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The unique identifier within the source type generated by the server.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The unique identifier within the source type generated by the server.
   * @param id id or {@code null} for none
   */
  public Source setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Metadata about a source of type
   * PROFILE.
   * @return value or {@code null} for none
   */
  public ProfileMetadata getProfileMetadata() {
    return profileMetadata;
  }

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Metadata about a source of type
   * PROFILE.
   * @param profileMetadata profileMetadata or {@code null} for none
   */
  public Source setProfileMetadata(ProfileMetadata profileMetadata) {
    this.profileMetadata = profileMetadata;
    return this;
  }

  /**
   * The source type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The source type.
   * @param type type or {@code null} for none
   */
  public Source setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Last update timestamp of this
   * source.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. **Only populated in `person.metadata.sources`.** Last update timestamp of this
   * source.
   * @param updateTime updateTime or {@code null} for none
   */
  public Source setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public Source set(String fieldName, Object value) {
    return (Source) super.set(fieldName, value);
  }

  @Override
  public Source clone() {
    return (Source) super.clone();
  }

}
