/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A request to create a batch of contacts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchCreateContactsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The contact to create. Allows up to 200 contacts in a single request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ContactToCreate> contacts;

  /**
   * Required. A field mask to restrict which fields on each person are returned in the response.
   * Multiple fields can be specified by separating them with commas. If read mask is left empty,
   * the post-mutate-get is skipped and no data will be returned in the response. Valid values are:
   * * addresses * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
   * emailAddresses * events * externalIds * genders * imClients * interests * locales * locations *
   * memberships * metadata * miscKeywords * names * nicknames * occupations * organizations *
   * phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String readMask;

  /**
   * Optional. A mask of what source types to return in the post mutate read. Defaults to
   * READ_SOURCE_TYPE_CONTACT and READ_SOURCE_TYPE_PROFILE if not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sources;

  /**
   * Required. The contact to create. Allows up to 200 contacts in a single request.
   * @return value or {@code null} for none
   */
  public java.util.List<ContactToCreate> getContacts() {
    return contacts;
  }

  /**
   * Required. The contact to create. Allows up to 200 contacts in a single request.
   * @param contacts contacts or {@code null} for none
   */
  public BatchCreateContactsRequest setContacts(java.util.List<ContactToCreate> contacts) {
    this.contacts = contacts;
    return this;
  }

  /**
   * Required. A field mask to restrict which fields on each person are returned in the response.
   * Multiple fields can be specified by separating them with commas. If read mask is left empty,
   * the post-mutate-get is skipped and no data will be returned in the response. Valid values are:
   * * addresses * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
   * emailAddresses * events * externalIds * genders * imClients * interests * locales * locations *
   * memberships * metadata * miscKeywords * names * nicknames * occupations * organizations *
   * phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
   * @return value or {@code null} for none
   */
  public String getReadMask() {
    return readMask;
  }

  /**
   * Required. A field mask to restrict which fields on each person are returned in the response.
   * Multiple fields can be specified by separating them with commas. If read mask is left empty,
   * the post-mutate-get is skipped and no data will be returned in the response. Valid values are:
   * * addresses * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
   * emailAddresses * events * externalIds * genders * imClients * interests * locales * locations *
   * memberships * metadata * miscKeywords * names * nicknames * occupations * organizations *
   * phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
   * @param readMask readMask or {@code null} for none
   */
  public BatchCreateContactsRequest setReadMask(String readMask) {
    this.readMask = readMask;
    return this;
  }

  /**
   * Optional. A mask of what source types to return in the post mutate read. Defaults to
   * READ_SOURCE_TYPE_CONTACT and READ_SOURCE_TYPE_PROFILE if not set.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSources() {
    return sources;
  }

  /**
   * Optional. A mask of what source types to return in the post mutate read. Defaults to
   * READ_SOURCE_TYPE_CONTACT and READ_SOURCE_TYPE_PROFILE if not set.
   * @param sources sources or {@code null} for none
   */
  public BatchCreateContactsRequest setSources(java.util.List<java.lang.String> sources) {
    this.sources = sources;
    return this;
  }

  @Override
  public BatchCreateContactsRequest set(String fieldName, Object value) {
    return (BatchCreateContactsRequest) super.set(fieldName, value);
  }

  @Override
  public BatchCreateContactsRequest clone() {
    return (BatchCreateContactsRequest) super.clone();
  }

}
