/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The metadata about a contact group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContactGroupMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Output only. True if the contact group resource has been deleted. Populated only for
   * [`ListContactGroups`](/people/api/rest/v1/contactgroups/list) requests that include a sync
   * token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Output only. The time the group was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. True if the contact group resource has been deleted. Populated only for
   * [`ListContactGroups`](/people/api/rest/v1/contactgroups/list) requests that include a sync
   * token.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. True if the contact group resource has been deleted. Populated only for
   * [`ListContactGroups`](/people/api/rest/v1/contactgroups/list) requests that include a sync
   * token.
   * @param deleted deleted or {@code null} for none
   */
  public ContactGroupMetadata setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Output only. The time the group was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. The time the group was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public ContactGroupMetadata setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public ContactGroupMetadata set(String fieldName, Object value) {
    return (ContactGroupMetadata) super.set(fieldName, value);
  }

  @Override
  public ContactGroupMetadata clone() {
    return (ContactGroupMetadata) super.clone();
  }

}
