/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The response to a request for the authenticated user's connections.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListConnectionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The list of people that the requestor is connected to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Person> connections;

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token. When the response is paginated, only
   * the last page will contain `nextSyncToken`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextSyncToken;

  /**
   * The total number of items in the list without pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalItems;

  /**
   * **DEPRECATED** (Please use totalItems) The total number of people in the list without
   * pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalPeople;

  /**
   * The list of people that the requestor is connected to.
   * @return value or {@code null} for none
   */
  public java.util.List<Person> getConnections() {
    return connections;
  }

  /**
   * The list of people that the requestor is connected to.
   * @param connections connections or {@code null} for none
   */
  public ListConnectionsResponse setConnections(java.util.List<Person> connections) {
    this.connections = connections;
    return this;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted,
   * there are no subsequent pages.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListConnectionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token. When the response is paginated, only
   * the last page will contain `nextSyncToken`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextSyncToken() {
    return nextSyncToken;
  }

  /**
   * A token, which can be sent as `sync_token` to retrieve changes since the last request. Request
   * must set `request_sync_token` to return the sync token. When the response is paginated, only
   * the last page will contain `nextSyncToken`.
   * @param nextSyncToken nextSyncToken or {@code null} for none
   */
  public ListConnectionsResponse setNextSyncToken(java.lang.String nextSyncToken) {
    this.nextSyncToken = nextSyncToken;
    return this;
  }

  /**
   * The total number of items in the list without pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalItems() {
    return totalItems;
  }

  /**
   * The total number of items in the list without pagination.
   * @param totalItems totalItems or {@code null} for none
   */
  public ListConnectionsResponse setTotalItems(java.lang.Integer totalItems) {
    this.totalItems = totalItems;
    return this;
  }

  /**
   * **DEPRECATED** (Please use totalItems) The total number of people in the list without
   * pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalPeople() {
    return totalPeople;
  }

  /**
   * **DEPRECATED** (Please use totalItems) The total number of people in the list without
   * pagination.
   * @param totalPeople totalPeople or {@code null} for none
   */
  public ListConnectionsResponse setTotalPeople(java.lang.Integer totalPeople) {
    this.totalPeople = totalPeople;
    return this;
  }

  @Override
  public ListConnectionsResponse set(String fieldName, Object value) {
    return (ListConnectionsResponse) super.set(fieldName, value);
  }

  @Override
  public ListConnectionsResponse clone() {
    return (ListConnectionsResponse) super.clone();
  }

}
