/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's relation to another person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Relation extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The type of the relation translated and formatted in the viewer's account locale
   * or the locale specified in the Accept-Language HTTP header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedType;

  /**
   * Metadata about the relation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The name of the other person this relation refers to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String person;

  /**
   * The person's relation to the other person. The type can be custom or one of these predefined
   * values: * `spouse` * `child` * `mother` * `father` * `parent` * `brother` * `sister` * `friend`
   * * `relative` * `domesticPartner` * `manager` * `assistant` * `referredBy` * `partner`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. The type of the relation translated and formatted in the viewer's account locale
   * or the locale specified in the Accept-Language HTTP header.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedType() {
    return formattedType;
  }

  /**
   * Output only. The type of the relation translated and formatted in the viewer's account locale
   * or the locale specified in the Accept-Language HTTP header.
   * @param formattedType formattedType or {@code null} for none
   */
  public Relation setFormattedType(java.lang.String formattedType) {
    this.formattedType = formattedType;
    return this;
  }

  /**
   * Metadata about the relation.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the relation.
   * @param metadata metadata or {@code null} for none
   */
  public Relation setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The name of the other person this relation refers to.
   * @return value or {@code null} for none
   */
  public java.lang.String getPerson() {
    return person;
  }

  /**
   * The name of the other person this relation refers to.
   * @param person person or {@code null} for none
   */
  public Relation setPerson(java.lang.String person) {
    this.person = person;
    return this;
  }

  /**
   * The person's relation to the other person. The type can be custom or one of these predefined
   * values: * `spouse` * `child` * `mother` * `father` * `parent` * `brother` * `sister` * `friend`
   * * `relative` * `domesticPartner` * `manager` * `assistant` * `referredBy` * `partner`
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The person's relation to the other person. The type can be custom or one of these predefined
   * values: * `spouse` * `child` * `mother` * `father` * `parent` * `brother` * `sister` * `friend`
   * * `relative` * `domesticPartner` * `manager` * `assistant` * `referredBy` * `partner`
   * @param type type or {@code null} for none
   */
  public Relation setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Relation set(String fieldName, Object value) {
    return (Relation) super.set(fieldName, value);
  }

  @Override
  public Relation clone() {
    return (Relation) super.clone();
  }

}
