/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1;

/**
 * Service definition for Playdeveloperreporting (v1beta1).
 *
 * <p>
 * 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/play/developer/reporting" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PlaydeveloperreportingRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Playdeveloperreporting extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Play Developer Reporting API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://playdeveloperreporting.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://playdeveloperreporting.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Playdeveloperreporting(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Playdeveloperreporting(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Anomalies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
   *   {@code Playdeveloperreporting.Anomalies.List request = playdeveloperreporting.anomalies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Anomalies anomalies() {
    return new Anomalies();
  }

  /**
   * The "anomalies" collection of methods.
   */
  public class Anomalies {

    /**
     * Lists anomalies in any of the datasets.
     *
     * Create a request for the method "anomalies.list".
     *
     * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
     * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param parent Required. Parent app for which anomalies were detected. Format: apps/{app}
     * @return the request
     */
    public List list(java.lang.String parent) throws java.io.IOException {
      List result = new List(parent);
      initialize(result);
      return result;
    }

    public class List extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse> {

      private static final String REST_PATH = "v1beta1/{+parent}/anomalies";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^apps/[^/]+$");

      /**
       * Lists anomalies in any of the datasets.
       *
       * Create a request for the method "anomalies.list".
       *
       * This request holds the parameters needed by the the playdeveloperreporting server.  After
       * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
       * operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Required. Parent app for which anomalies were detected. Format: apps/{app}
       * @since 1.13
       */
      protected List(java.lang.String parent) {
        super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^apps/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Parent app for which anomalies were detected. Format: apps/{app} */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Required. Parent app for which anomalies were detected. Format: apps/{app}
       */
      public java.lang.String getParent() {
        return parent;
      }

      /** Required. Parent app for which anomalies were detected. Format: apps/{app} */
      public List setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^apps/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Filtering criteria for anomalies. For basic filter guidance, please check:
       * https://google.aip.dev/160. **Supported functions:** * `activeBetween(startTime, endTime)`:
       * If specified, only list anomalies that were active in between `startTime` (inclusive) and
       * `endTime` (exclusive). Both parameters are expected to conform to an RFC-3339 formatted
       * string (e.g. `2012-04-21T11:30:00-04:00`). UTC offsets are supported. Both `startTime` and
       * `endTime` accept the special value `UNBOUNDED`, to signify intervals with no lower or upper
       * bound, respectively. Examples: * `activeBetween("2021-04-21T11:30:00Z",
       * "2021-07-21T00:00:00Z")` * `activeBetween(UNBOUNDED, "2021-11-21T00:00:00-04:00")` *
       * `activeBetween("2021-07-21T00:00:00-04:00", UNBOUNDED)`
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filtering criteria for anomalies. For basic filter guidance, please check:
     https://google.aip.dev/160. **Supported functions:** * `activeBetween(startTime, endTime)`: If
     specified, only list anomalies that were active in between `startTime` (inclusive) and `endTime`
     (exclusive). Both parameters are expected to conform to an RFC-3339 formatted string (e.g.
     `2012-04-21T11:30:00-04:00`). UTC offsets are supported. Both `startTime` and `endTime` accept the
     special value `UNBOUNDED`, to signify intervals with no lower or upper bound, respectively.
     Examples: * `activeBetween("2021-04-21T11:30:00Z", "2021-07-21T00:00:00Z")` *
     `activeBetween(UNBOUNDED, "2021-11-21T00:00:00-04:00")` *
     `activeBetween("2021-07-21T00:00:00-04:00", UNBOUNDED)`
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Filtering criteria for anomalies. For basic filter guidance, please check:
       * https://google.aip.dev/160. **Supported functions:** * `activeBetween(startTime, endTime)`:
       * If specified, only list anomalies that were active in between `startTime` (inclusive) and
       * `endTime` (exclusive). Both parameters are expected to conform to an RFC-3339 formatted
       * string (e.g. `2012-04-21T11:30:00-04:00`). UTC offsets are supported. Both `startTime` and
       * `endTime` accept the special value `UNBOUNDED`, to signify intervals with no lower or upper
       * bound, respectively. Examples: * `activeBetween("2021-04-21T11:30:00Z",
       * "2021-07-21T00:00:00Z")` * `activeBetween(UNBOUNDED, "2021-11-21T00:00:00-04:00")` *
       * `activeBetween("2021-07-21T00:00:00-04:00", UNBOUNDED)`
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Maximum size of the returned data. If unspecified, at most 10 anomalies will be returned.
       * The maximum value is 100; values above 100 will be coerced to 100.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Maximum size of the returned data. If unspecified, at most 10 anomalies will be returned. The
     maximum value is 100; values above 100 will be coerced to 100.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Maximum size of the returned data. If unspecified, at most 10 anomalies will be returned.
       * The maximum value is 100; values above 100 will be coerced to 100.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * A page token, received from a previous `ListErrorReports` call. Provide this to retrieve
       * the subsequent page. When paginating, all other parameters provided to `ListErrorReports`
       * must match the call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A page token, received from a previous `ListErrorReports` call. Provide this to retrieve the
     subsequent page. When paginating, all other parameters provided to `ListErrorReports` must match
     the call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A page token, received from a previous `ListErrorReports` call. Provide this to retrieve
       * the subsequent page. When paginating, all other parameters provided to `ListErrorReports`
       * must match the call that provided the page token.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Apps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
   *   {@code Playdeveloperreporting.Apps.List request = playdeveloperreporting.apps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Apps apps() {
    return new Apps();
  }

  /**
   * The "apps" collection of methods.
   */
  public class Apps {

    /**
     * Describes filtering options for releases.
     *
     * Create a request for the method "apps.fetchReleaseFilterOptions".
     *
     * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
     * optional parameters, call the {@link FetchReleaseFilterOptions#execute()} method to invoke the
     * remote operation.
     *
     * @param name Required. Name of the resource, i.e. app the filtering options are for. Format: apps/{app}
     * @return the request
     */
    public FetchReleaseFilterOptions fetchReleaseFilterOptions(java.lang.String name) throws java.io.IOException {
      FetchReleaseFilterOptions result = new FetchReleaseFilterOptions(name);
      initialize(result);
      return result;
    }

    public class FetchReleaseFilterOptions extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions> {

      private static final String REST_PATH = "v1beta1/{+name}:fetchReleaseFilterOptions";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^apps/[^/]+$");

      /**
       * Describes filtering options for releases.
       *
       * Create a request for the method "apps.fetchReleaseFilterOptions".
       *
       * This request holds the parameters needed by the the playdeveloperreporting server.  After
       * setting any optional parameters, call the {@link FetchReleaseFilterOptions#execute()} method to
       * invoke the remote operation. <p> {@link FetchReleaseFilterOptions#initialize(com.google.api.cli
       * ent.googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this
       * instance immediately after invoking the constructor. </p>
       *
       * @param name Required. Name of the resource, i.e. app the filtering options are for. Format: apps/{app}
       * @since 1.13
       */
      protected FetchReleaseFilterOptions(java.lang.String name) {
        super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^apps/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public FetchReleaseFilterOptions set$Xgafv(java.lang.String $Xgafv) {
        return (FetchReleaseFilterOptions) super.set$Xgafv($Xgafv);
      }

      @Override
      public FetchReleaseFilterOptions setAccessToken(java.lang.String accessToken) {
        return (FetchReleaseFilterOptions) super.setAccessToken(accessToken);
      }

      @Override
      public FetchReleaseFilterOptions setAlt(java.lang.String alt) {
        return (FetchReleaseFilterOptions) super.setAlt(alt);
      }

      @Override
      public FetchReleaseFilterOptions setCallback(java.lang.String callback) {
        return (FetchReleaseFilterOptions) super.setCallback(callback);
      }

      @Override
      public FetchReleaseFilterOptions setFields(java.lang.String fields) {
        return (FetchReleaseFilterOptions) super.setFields(fields);
      }

      @Override
      public FetchReleaseFilterOptions setKey(java.lang.String key) {
        return (FetchReleaseFilterOptions) super.setKey(key);
      }

      @Override
      public FetchReleaseFilterOptions setOauthToken(java.lang.String oauthToken) {
        return (FetchReleaseFilterOptions) super.setOauthToken(oauthToken);
      }

      @Override
      public FetchReleaseFilterOptions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (FetchReleaseFilterOptions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public FetchReleaseFilterOptions setQuotaUser(java.lang.String quotaUser) {
        return (FetchReleaseFilterOptions) super.setQuotaUser(quotaUser);
      }

      @Override
      public FetchReleaseFilterOptions setUploadType(java.lang.String uploadType) {
        return (FetchReleaseFilterOptions) super.setUploadType(uploadType);
      }

      @Override
      public FetchReleaseFilterOptions setUploadProtocol(java.lang.String uploadProtocol) {
        return (FetchReleaseFilterOptions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. Name of the resource, i.e. app the filtering options are for. Format: apps/{app}
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. Name of the resource, i.e. app the filtering options are for. Format: apps/{app}
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Required. Name of the resource, i.e. app the filtering options are for. Format: apps/{app}
       */
      public FetchReleaseFilterOptions setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^apps/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public FetchReleaseFilterOptions set(String parameterName, Object value) {
        return (FetchReleaseFilterOptions) super.set(parameterName, value);
      }
    }
    /**
     * Searches for Apps accessible by the user.
     *
     * Create a request for the method "apps.search".
     *
     * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
     * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Search search() throws java.io.IOException {
      Search result = new Search();
      initialize(result);
      return result;
    }

    public class Search extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchAccessibleAppsResponse> {

      private static final String REST_PATH = "v1beta1/apps:search";

      /**
       * Searches for Apps accessible by the user.
       *
       * Create a request for the method "apps.search".
       *
       * This request holds the parameters needed by the the playdeveloperreporting server.  After
       * setting any optional parameters, call the {@link Search#execute()} method to invoke the remote
       * operation. <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Search() {
        super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchAccessibleAppsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The maximum number of apps to return. The service may return fewer than this value. If
       * unspecified, at most 50 apps will be returned. The maximum value is 1000; values above 1000
       * will be coerced to 1000.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of apps to return. The service may return fewer than this value. If unspecified,
     at most 50 apps will be returned. The maximum value is 1000; values above 1000 will be coerced to
     1000.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of apps to return. The service may return fewer than this value. If
       * unspecified, at most 50 apps will be returned. The maximum value is 1000; values above 1000
       * will be coerced to 1000.
       */
      public Search setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * A page token, received from a previous `SearchAccessibleApps` call. Provide this to
       * retrieve the subsequent page. When paginating, all other parameters provided to
       * `SearchAccessibleApps` must match the call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A page token, received from a previous `SearchAccessibleApps` call. Provide this to retrieve the
     subsequent page. When paginating, all other parameters provided to `SearchAccessibleApps` must
     match the call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A page token, received from a previous `SearchAccessibleApps` call. Provide this to
       * retrieve the subsequent page. When paginating, all other parameters provided to
       * `SearchAccessibleApps` must match the call that provided the page token.
       */
      public Search setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Vitals collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
   *   {@code Playdeveloperreporting.Vitals.List request = playdeveloperreporting.vitals().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Vitals vitals() {
    return new Vitals();
  }

  /**
   * The "vitals" collection of methods.
   */
  public class Vitals {

    /**
     * An accessor for creating requests from the Anrrate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Anrrate.List request = playdeveloperreporting.anrrate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Anrrate anrrate() {
      return new Anrrate();
    }

    /**
     * The "anrrate" collection of methods.
     */
    public class Anrrate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "anrrate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/anrRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1AnrRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/anrRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "anrrate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/anrRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1AnrRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/anrRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/anrRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "anrrate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/anrRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/anrRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "anrrate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/anrRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryAnrRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/anrRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/anrRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/anrRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Crashrate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Crashrate.List request = playdeveloperreporting.crashrate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Crashrate crashrate() {
      return new Crashrate();
    }

    /**
     * The "crashrate" collection of methods.
     */
    public class Crashrate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "crashrate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/crashRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1CrashRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/crashRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "crashrate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/crashRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1CrashRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/crashRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/crashRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "crashrate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/crashRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/crashRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "crashrate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/crashRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryCrashRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/crashRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/crashRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/crashRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Errors collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Errors.List request = playdeveloperreporting.errors().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Errors errors() {
      return new Errors();
    }

    /**
     * The "errors" collection of methods.
     */
    public class Errors {

      /**
       * An accessor for creating requests from the Counts collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
       *   {@code Playdeveloperreporting.Counts.List request = playdeveloperreporting.counts().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Counts counts() {
        return new Counts();
      }

      /**
       * The "counts" collection of methods.
       */
      public class Counts {

        /**
         * Describes the properties of the metrics set.
         *
         * Create a request for the method "counts.get".
         *
         * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ErrorCountMetricSet> {

          private static final String REST_PATH = "v1beta1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^apps/[^/]+/errorCountMetricSet$");

          /**
           * Describes the properties of the metrics set.
           *
           * Create a request for the method "counts.get".
           *
           * This request holds the parameters needed by the the playdeveloperreporting server.  After
           * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
           * operation. <p> {@link
           * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
           * called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ErrorCountMetricSet.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^apps/[^/]+/errorCountMetricSet$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. Name of the errors metric set. Format: apps/{app}/errorCountMetricSet */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^apps/[^/]+/errorCountMetricSet$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Queries the metrics in the metrics set.
         *
         * Create a request for the method "counts.query".
         *
         * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
         * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
         *
         * @param name Required. The resource name. Format: apps/{app}/errorCountMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetRequest}
         * @return the request
         */
        public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetRequest content) throws java.io.IOException {
          Query result = new Query(name, content);
          initialize(result);
          return result;
        }

        public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetResponse> {

          private static final String REST_PATH = "v1beta1/{+name}:query";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^apps/[^/]+/errorCountMetricSet$");

          /**
           * Queries the metrics in the metrics set.
           *
           * Create a request for the method "counts.query".
           *
           * This request holds the parameters needed by the the playdeveloperreporting server.  After
           * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
           * operation. <p> {@link
           * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. The resource name. Format: apps/{app}/errorCountMetricSet
           * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetRequest}
           * @since 1.13
           */
          protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetRequest content) {
            super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryErrorCountMetricSetResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^apps/[^/]+/errorCountMetricSet$");
            }
          }

          @Override
          public Query set$Xgafv(java.lang.String $Xgafv) {
            return (Query) super.set$Xgafv($Xgafv);
          }

          @Override
          public Query setAccessToken(java.lang.String accessToken) {
            return (Query) super.setAccessToken(accessToken);
          }

          @Override
          public Query setAlt(java.lang.String alt) {
            return (Query) super.setAlt(alt);
          }

          @Override
          public Query setCallback(java.lang.String callback) {
            return (Query) super.setCallback(callback);
          }

          @Override
          public Query setFields(java.lang.String fields) {
            return (Query) super.setFields(fields);
          }

          @Override
          public Query setKey(java.lang.String key) {
            return (Query) super.setKey(key);
          }

          @Override
          public Query setOauthToken(java.lang.String oauthToken) {
            return (Query) super.setOauthToken(oauthToken);
          }

          @Override
          public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Query) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Query setQuotaUser(java.lang.String quotaUser) {
            return (Query) super.setQuotaUser(quotaUser);
          }

          @Override
          public Query setUploadType(java.lang.String uploadType) {
            return (Query) super.setUploadType(uploadType);
          }

          @Override
          public Query setUploadProtocol(java.lang.String uploadProtocol) {
            return (Query) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The resource name. Format: apps/{app}/errorCountMetricSet */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The resource name. Format: apps/{app}/errorCountMetricSet
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The resource name. Format: apps/{app}/errorCountMetricSet */
          public Query setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^apps/[^/]+/errorCountMetricSet$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Query set(String parameterName, Object value) {
            return (Query) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Issues collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
       *   {@code Playdeveloperreporting.Issues.List request = playdeveloperreporting.issues().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Issues issues() {
        return new Issues();
      }

      /**
       * The "issues" collection of methods.
       */
      public class Issues {

        /**
         * Searches all error issues in which reports have been grouped.
         *
         * Create a request for the method "issues.search".
         *
         * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
         * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Parent resource of the error issues, indicating the application for which they were
         *        received. Format: apps/{app}
         * @return the request
         */
        public Search search(java.lang.String parent) throws java.io.IOException {
          Search result = new Search(parent);
          initialize(result);
          return result;
        }

        public class Search extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchErrorIssuesResponse> {

          private static final String REST_PATH = "v1beta1/{+parent}/errorIssues:search";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^apps/[^/]+$");

          /**
           * Searches all error issues in which reports have been grouped.
           *
           * Create a request for the method "issues.search".
           *
           * This request holds the parameters needed by the the playdeveloperreporting server.  After
           * setting any optional parameters, call the {@link Search#execute()} method to invoke the remote
           * operation. <p> {@link
           * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Parent resource of the error issues, indicating the application for which they were
         *        received. Format: apps/{app}
           * @since 1.13
           */
          protected Search(java.lang.String parent) {
            super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchErrorIssuesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^apps/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Search set$Xgafv(java.lang.String $Xgafv) {
            return (Search) super.set$Xgafv($Xgafv);
          }

          @Override
          public Search setAccessToken(java.lang.String accessToken) {
            return (Search) super.setAccessToken(accessToken);
          }

          @Override
          public Search setAlt(java.lang.String alt) {
            return (Search) super.setAlt(alt);
          }

          @Override
          public Search setCallback(java.lang.String callback) {
            return (Search) super.setCallback(callback);
          }

          @Override
          public Search setFields(java.lang.String fields) {
            return (Search) super.setFields(fields);
          }

          @Override
          public Search setKey(java.lang.String key) {
            return (Search) super.setKey(key);
          }

          @Override
          public Search setOauthToken(java.lang.String oauthToken) {
            return (Search) super.setOauthToken(oauthToken);
          }

          @Override
          public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Search) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Search setQuotaUser(java.lang.String quotaUser) {
            return (Search) super.setQuotaUser(quotaUser);
          }

          @Override
          public Search setUploadType(java.lang.String uploadType) {
            return (Search) super.setUploadType(uploadType);
          }

          @Override
          public Search setUploadProtocol(java.lang.String uploadProtocol) {
            return (Search) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Parent resource of the error issues, indicating the application for which
           * they were received. Format: apps/{app}
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Parent resource of the error issues, indicating the application for which they were
         received. Format: apps/{app}
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. Parent resource of the error issues, indicating the application for which
           * they were received. Format: apps/{app}
           */
          public Search setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^apps/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A selection predicate to retrieve only a subset of the issues. Counts in the returned
           * error issues will only reflect occurrences that matched the filter. For filtering
           * basics, please check [AIP-160](https://google.aip.dev/160). ** Supported field names:**
           * * `apiLevel`: Matches error issues that occurred in the requested Android versions
           * (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. *
           * `versionCode`: Matches error issues that occurred in the requested app version codes
           * only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error
           * issues that occurred in the requested devices. Example: `deviceModel = "google/walleye"
           * OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that occurred
           * in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`:
           * Matches error issues that occurred in the requested device types. Example: `deviceType
           * = "PHONE"`. * `errorIssueType`: Matches error issues of the requested types only. Valid
           * candidates: `CRASH`, `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR
           * errorIssueType = ANR`. * `appProcessState`: Matches error issues on the process state
           * of an app, indicating whether an app runs in the foreground (user-visible) or
           * background. Valid candidates: `FOREGROUND`, `BACKGROUND`. Example: `appProcessState =
           * FOREGROUND`. * `isUserPerceived`: Matches error issues that are user-perceived. It is
           * not accompanied by any operators. Example: `isUserPerceived`. ** Supported operators:**
           * * Comparison operators: The only supported comparison operator is equality. The
           * filtered field must appear on the left hand side of the comparison. * Logical
           * Operators: Logical operators `AND` and `OR` can be used to build complex filters
           * following a conjunctive normal form (CNF), i.e., conjunctions of disjunctions. The `OR`
           * operator takes precedence over `AND` so the use of parenthesis is not necessary when
           * building CNF. The `OR` operator is only supported to build disjunctions that apply to
           * the same field, e.g., `versionCode = 123 OR errorIssueType = ANR` is not a valid
           * filter. ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND
           * errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType =
           * CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** A selection predicate to retrieve only a subset of the issues. Counts in the returned error issues
         will only reflect occurrences that matched the filter. For filtering basics, please check
         [AIP-160](https://google.aip.dev/160). ** Supported field names:** * `apiLevel`: Matches error
         issues that occurred in the requested Android versions (specified as the numeric API level) only.
         Example: `apiLevel = 28 OR apiLevel = 29`. * `versionCode`: Matches error issues that occurred in
         the requested app version codes only. Example: `versionCode = 123 OR versionCode = 456`. *
         `deviceModel`: Matches error issues that occurred in the requested devices. Example: `deviceModel =
         "google/walleye" OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that
         occurred in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`: Matches
         error issues that occurred in the requested device types. Example: `deviceType = "PHONE"`. *
         `errorIssueType`: Matches error issues of the requested types only. Valid candidates: `CRASH`,
         `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR errorIssueType = ANR`. * `appProcessState`:
         Matches error issues on the process state of an app, indicating whether an app runs in the
         foreground (user-visible) or background. Valid candidates: `FOREGROUND`, `BACKGROUND`. Example:
         `appProcessState = FOREGROUND`. * `isUserPerceived`: Matches error issues that are user-perceived.
         It is not accompanied by any operators. Example: `isUserPerceived`. ** Supported operators:** *
         Comparison operators: The only supported comparison operator is equality. The filtered field must
         appear on the left hand side of the comparison. * Logical Operators: Logical operators `AND` and
         `OR` can be used to build complex filters following a conjunctive normal form (CNF), i.e.,
         conjunctions of disjunctions. The `OR` operator takes precedence over `AND` so the use of
         parenthesis is not necessary when building CNF. The `OR` operator is only supported to build
         disjunctions that apply to the same field, e.g., `versionCode = 123 OR errorIssueType = ANR` is not
         a valid filter. ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND
         errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType = CRASH` *
         `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * A selection predicate to retrieve only a subset of the issues. Counts in the returned
           * error issues will only reflect occurrences that matched the filter. For filtering
           * basics, please check [AIP-160](https://google.aip.dev/160). ** Supported field names:**
           * * `apiLevel`: Matches error issues that occurred in the requested Android versions
           * (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. *
           * `versionCode`: Matches error issues that occurred in the requested app version codes
           * only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error
           * issues that occurred in the requested devices. Example: `deviceModel = "google/walleye"
           * OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that occurred
           * in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`:
           * Matches error issues that occurred in the requested device types. Example: `deviceType
           * = "PHONE"`. * `errorIssueType`: Matches error issues of the requested types only. Valid
           * candidates: `CRASH`, `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR
           * errorIssueType = ANR`. * `appProcessState`: Matches error issues on the process state
           * of an app, indicating whether an app runs in the foreground (user-visible) or
           * background. Valid candidates: `FOREGROUND`, `BACKGROUND`. Example: `appProcessState =
           * FOREGROUND`. * `isUserPerceived`: Matches error issues that are user-perceived. It is
           * not accompanied by any operators. Example: `isUserPerceived`. ** Supported operators:**
           * * Comparison operators: The only supported comparison operator is equality. The
           * filtered field must appear on the left hand side of the comparison. * Logical
           * Operators: Logical operators `AND` and `OR` can be used to build complex filters
           * following a conjunctive normal form (CNF), i.e., conjunctions of disjunctions. The `OR`
           * operator takes precedence over `AND` so the use of parenthesis is not necessary when
           * building CNF. The `OR` operator is only supported to build disjunctions that apply to
           * the same field, e.g., `versionCode = 123 OR errorIssueType = ANR` is not a valid
           * filter. ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND
           * errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType =
           * CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`
           */
          public Search setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          @com.google.api.client.util.Key("interval.endTime.day")
          private java.lang.Integer intervalEndTimeDay;

          /** Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a
         datetime without a day.
           */
          public java.lang.Integer getIntervalEndTimeDay() {
            return intervalEndTimeDay;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          public Search setIntervalEndTimeDay(java.lang.Integer intervalEndTimeDay) {
            this.intervalEndTimeDay = intervalEndTimeDay;
            return this;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          @com.google.api.client.util.Key("interval.endTime.hours")
          private java.lang.Integer intervalEndTimeHours;

          /** Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API
         may choose to allow the value "24:00:00" for scenarios like business closing time.
           */
          public java.lang.Integer getIntervalEndTimeHours() {
            return intervalEndTimeHours;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          public Search setIntervalEndTimeHours(java.lang.Integer intervalEndTimeHours) {
            this.intervalEndTimeHours = intervalEndTimeHours;
            return this;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          @com.google.api.client.util.Key("interval.endTime.minutes")
          private java.lang.Integer intervalEndTimeMinutes;

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
           */
          public java.lang.Integer getIntervalEndTimeMinutes() {
            return intervalEndTimeMinutes;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          public Search setIntervalEndTimeMinutes(java.lang.Integer intervalEndTimeMinutes) {
            this.intervalEndTimeMinutes = intervalEndTimeMinutes;
            return this;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          @com.google.api.client.util.Key("interval.endTime.month")
          private java.lang.Integer intervalEndTimeMonth;

          /** Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
           */
          public java.lang.Integer getIntervalEndTimeMonth() {
            return intervalEndTimeMonth;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          public Search setIntervalEndTimeMonth(java.lang.Integer intervalEndTimeMonth) {
            this.intervalEndTimeMonth = intervalEndTimeMonth;
            return this;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          @com.google.api.client.util.Key("interval.endTime.nanos")
          private java.lang.Integer intervalEndTimeNanos;

          /** Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
           */
          public java.lang.Integer getIntervalEndTimeNanos() {
            return intervalEndTimeNanos;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          public Search setIntervalEndTimeNanos(java.lang.Integer intervalEndTimeNanos) {
            this.intervalEndTimeNanos = intervalEndTimeNanos;
            return this;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          @com.google.api.client.util.Key("interval.endTime.seconds")
          private java.lang.Integer intervalEndTimeSeconds;

          /** Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may
         allow the value 60 if it allows leap-seconds.
           */
          public java.lang.Integer getIntervalEndTimeSeconds() {
            return intervalEndTimeSeconds;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          public Search setIntervalEndTimeSeconds(java.lang.Integer intervalEndTimeSeconds) {
            this.intervalEndTimeSeconds = intervalEndTimeSeconds;
            return this;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          @com.google.api.client.util.Key("interval.endTime.timeZone.id")
          private java.lang.String intervalEndTimeTimeZoneId;

          /** IANA Time Zone Database time zone. For example "America/New_York".
           */
          public java.lang.String getIntervalEndTimeTimeZoneId() {
            return intervalEndTimeTimeZoneId;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          public Search setIntervalEndTimeTimeZoneId(java.lang.String intervalEndTimeTimeZoneId) {
            this.intervalEndTimeTimeZoneId = intervalEndTimeTimeZoneId;
            return this;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          @com.google.api.client.util.Key("interval.endTime.timeZone.version")
          private java.lang.String intervalEndTimeTimeZoneVersion;

          /** Optional. IANA Time Zone Database version number. For example "2019a".
           */
          public java.lang.String getIntervalEndTimeTimeZoneVersion() {
            return intervalEndTimeTimeZoneVersion;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          public Search setIntervalEndTimeTimeZoneVersion(java.lang.String intervalEndTimeTimeZoneVersion) {
            this.intervalEndTimeTimeZoneVersion = intervalEndTimeTimeZoneVersion;
            return this;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          @com.google.api.client.util.Key("interval.endTime.utcOffset")
          private String intervalEndTimeUtcOffset;

          /** UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of
         -4:00 would be represented as { seconds: -14400 }.
           */
          public String getIntervalEndTimeUtcOffset() {
            return intervalEndTimeUtcOffset;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          public Search setIntervalEndTimeUtcOffset(String intervalEndTimeUtcOffset) {
            this.intervalEndTimeUtcOffset = intervalEndTimeUtcOffset;
            return this;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          @com.google.api.client.util.Key("interval.endTime.year")
          private java.lang.Integer intervalEndTimeYear;

          /** Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
           */
          public java.lang.Integer getIntervalEndTimeYear() {
            return intervalEndTimeYear;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          public Search setIntervalEndTimeYear(java.lang.Integer intervalEndTimeYear) {
            this.intervalEndTimeYear = intervalEndTimeYear;
            return this;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          @com.google.api.client.util.Key("interval.startTime.day")
          private java.lang.Integer intervalStartTimeDay;

          /** Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a
         datetime without a day.
           */
          public java.lang.Integer getIntervalStartTimeDay() {
            return intervalStartTimeDay;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          public Search setIntervalStartTimeDay(java.lang.Integer intervalStartTimeDay) {
            this.intervalStartTimeDay = intervalStartTimeDay;
            return this;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          @com.google.api.client.util.Key("interval.startTime.hours")
          private java.lang.Integer intervalStartTimeHours;

          /** Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API
         may choose to allow the value "24:00:00" for scenarios like business closing time.
           */
          public java.lang.Integer getIntervalStartTimeHours() {
            return intervalStartTimeHours;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          public Search setIntervalStartTimeHours(java.lang.Integer intervalStartTimeHours) {
            this.intervalStartTimeHours = intervalStartTimeHours;
            return this;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          @com.google.api.client.util.Key("interval.startTime.minutes")
          private java.lang.Integer intervalStartTimeMinutes;

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
           */
          public java.lang.Integer getIntervalStartTimeMinutes() {
            return intervalStartTimeMinutes;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          public Search setIntervalStartTimeMinutes(java.lang.Integer intervalStartTimeMinutes) {
            this.intervalStartTimeMinutes = intervalStartTimeMinutes;
            return this;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          @com.google.api.client.util.Key("interval.startTime.month")
          private java.lang.Integer intervalStartTimeMonth;

          /** Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
           */
          public java.lang.Integer getIntervalStartTimeMonth() {
            return intervalStartTimeMonth;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          public Search setIntervalStartTimeMonth(java.lang.Integer intervalStartTimeMonth) {
            this.intervalStartTimeMonth = intervalStartTimeMonth;
            return this;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          @com.google.api.client.util.Key("interval.startTime.nanos")
          private java.lang.Integer intervalStartTimeNanos;

          /** Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
           */
          public java.lang.Integer getIntervalStartTimeNanos() {
            return intervalStartTimeNanos;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          public Search setIntervalStartTimeNanos(java.lang.Integer intervalStartTimeNanos) {
            this.intervalStartTimeNanos = intervalStartTimeNanos;
            return this;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          @com.google.api.client.util.Key("interval.startTime.seconds")
          private java.lang.Integer intervalStartTimeSeconds;

          /** Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may
         allow the value 60 if it allows leap-seconds.
           */
          public java.lang.Integer getIntervalStartTimeSeconds() {
            return intervalStartTimeSeconds;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          public Search setIntervalStartTimeSeconds(java.lang.Integer intervalStartTimeSeconds) {
            this.intervalStartTimeSeconds = intervalStartTimeSeconds;
            return this;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          @com.google.api.client.util.Key("interval.startTime.timeZone.id")
          private java.lang.String intervalStartTimeTimeZoneId;

          /** IANA Time Zone Database time zone. For example "America/New_York".
           */
          public java.lang.String getIntervalStartTimeTimeZoneId() {
            return intervalStartTimeTimeZoneId;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          public Search setIntervalStartTimeTimeZoneId(java.lang.String intervalStartTimeTimeZoneId) {
            this.intervalStartTimeTimeZoneId = intervalStartTimeTimeZoneId;
            return this;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          @com.google.api.client.util.Key("interval.startTime.timeZone.version")
          private java.lang.String intervalStartTimeTimeZoneVersion;

          /** Optional. IANA Time Zone Database version number. For example "2019a".
           */
          public java.lang.String getIntervalStartTimeTimeZoneVersion() {
            return intervalStartTimeTimeZoneVersion;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          public Search setIntervalStartTimeTimeZoneVersion(java.lang.String intervalStartTimeTimeZoneVersion) {
            this.intervalStartTimeTimeZoneVersion = intervalStartTimeTimeZoneVersion;
            return this;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          @com.google.api.client.util.Key("interval.startTime.utcOffset")
          private String intervalStartTimeUtcOffset;

          /** UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of
         -4:00 would be represented as { seconds: -14400 }.
           */
          public String getIntervalStartTimeUtcOffset() {
            return intervalStartTimeUtcOffset;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          public Search setIntervalStartTimeUtcOffset(String intervalStartTimeUtcOffset) {
            this.intervalStartTimeUtcOffset = intervalStartTimeUtcOffset;
            return this;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          @com.google.api.client.util.Key("interval.startTime.year")
          private java.lang.Integer intervalStartTimeYear;

          /** Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
           */
          public java.lang.Integer getIntervalStartTimeYear() {
            return intervalStartTimeYear;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          public Search setIntervalStartTimeYear(java.lang.Integer intervalStartTimeYear) {
            this.intervalStartTimeYear = intervalStartTimeYear;
            return this;
          }

          /**
           * Specifies a field that will be used to order the results. ** Supported dimensions:** *
           * `errorReportCount`: Orders issues by number of error reports. * `distinctUsers`: Orders
           * issues by number of unique affected users. ** Supported operations:** * `asc` for
           * ascending order. * `desc` for descending order. Format: A field and an operation, e.g.,
           * `errorReportCount desc` *Note:* currently only one field is supported at a time.
           */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Specifies a field that will be used to order the results. ** Supported dimensions:** *
         `errorReportCount`: Orders issues by number of error reports. * `distinctUsers`: Orders issues by
         number of unique affected users. ** Supported operations:** * `asc` for ascending order. * `desc`
         for descending order. Format: A field and an operation, e.g., `errorReportCount desc` *Note:*
         currently only one field is supported at a time.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /**
           * Specifies a field that will be used to order the results. ** Supported dimensions:** *
           * `errorReportCount`: Orders issues by number of error reports. * `distinctUsers`: Orders
           * issues by number of unique affected users. ** Supported operations:** * `asc` for
           * ascending order. * `desc` for descending order. Format: A field and an operation, e.g.,
           * `errorReportCount desc` *Note:* currently only one field is supported at a time.
           */
          public Search setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /**
           * The maximum number of error issues to return. The service may return fewer than this
           * value. If unspecified, at most 50 error issues will be returned. The maximum value is
           * 1000; values above 1000 will be coerced to 1000.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of error issues to return. The service may return fewer than this value. If
         unspecified, at most 50 error issues will be returned. The maximum value is 1000; values above 1000
         will be coerced to 1000.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of error issues to return. The service may return fewer than this
           * value. If unspecified, at most 50 error issues will be returned. The maximum value is
           * 1000; values above 1000 will be coerced to 1000.
           */
          public Search setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A page token, received from a previous call. Provide this to retrieve the subsequent
           * page. When paginating, all other parameters provided to the request must match the call
           * that provided the page token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A page token, received from a previous call. Provide this to retrieve the subsequent page. When
         paginating, all other parameters provided to the request must match the call that provided the page
         token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A page token, received from a previous call. Provide this to retrieve the subsequent
           * page. When paginating, all other parameters provided to the request must match the call
           * that provided the page token.
           */
          public Search setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * Optional. Number of sample error reports to return per ErrorIssue. If unspecified, 0
           * will be used. *Note:* currently only 0 and 1 are supported.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer sampleErrorReportLimit;

          /** Optional. Number of sample error reports to return per ErrorIssue. If unspecified, 0 will be used.
         *Note:* currently only 0 and 1 are supported.
           */
          public java.lang.Integer getSampleErrorReportLimit() {
            return sampleErrorReportLimit;
          }

          /**
           * Optional. Number of sample error reports to return per ErrorIssue. If unspecified, 0
           * will be used. *Note:* currently only 0 and 1 are supported.
           */
          public Search setSampleErrorReportLimit(java.lang.Integer sampleErrorReportLimit) {
            this.sampleErrorReportLimit = sampleErrorReportLimit;
            return this;
          }

          @Override
          public Search set(String parameterName, Object value) {
            return (Search) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Reports collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
       *   {@code Playdeveloperreporting.Reports.List request = playdeveloperreporting.reports().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Reports reports() {
        return new Reports();
      }

      /**
       * The "reports" collection of methods.
       */
      public class Reports {

        /**
         * Searches all error reports received for an app.
         *
         * Create a request for the method "reports.search".
         *
         * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
         * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Parent resource of the reports, indicating the application for which they were received.
         *        Format: apps/{app}
         * @return the request
         */
        public Search search(java.lang.String parent) throws java.io.IOException {
          Search result = new Search(parent);
          initialize(result);
          return result;
        }

        public class Search extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchErrorReportsResponse> {

          private static final String REST_PATH = "v1beta1/{+parent}/errorReports:search";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^apps/[^/]+$");

          /**
           * Searches all error reports received for an app.
           *
           * Create a request for the method "reports.search".
           *
           * This request holds the parameters needed by the the playdeveloperreporting server.  After
           * setting any optional parameters, call the {@link Search#execute()} method to invoke the remote
           * operation. <p> {@link
           * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Parent resource of the reports, indicating the application for which they were received.
         *        Format: apps/{app}
           * @since 1.13
           */
          protected Search(java.lang.String parent) {
            super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SearchErrorReportsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^apps/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Search set$Xgafv(java.lang.String $Xgafv) {
            return (Search) super.set$Xgafv($Xgafv);
          }

          @Override
          public Search setAccessToken(java.lang.String accessToken) {
            return (Search) super.setAccessToken(accessToken);
          }

          @Override
          public Search setAlt(java.lang.String alt) {
            return (Search) super.setAlt(alt);
          }

          @Override
          public Search setCallback(java.lang.String callback) {
            return (Search) super.setCallback(callback);
          }

          @Override
          public Search setFields(java.lang.String fields) {
            return (Search) super.setFields(fields);
          }

          @Override
          public Search setKey(java.lang.String key) {
            return (Search) super.setKey(key);
          }

          @Override
          public Search setOauthToken(java.lang.String oauthToken) {
            return (Search) super.setOauthToken(oauthToken);
          }

          @Override
          public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Search) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Search setQuotaUser(java.lang.String quotaUser) {
            return (Search) super.setQuotaUser(quotaUser);
          }

          @Override
          public Search setUploadType(java.lang.String uploadType) {
            return (Search) super.setUploadType(uploadType);
          }

          @Override
          public Search setUploadProtocol(java.lang.String uploadProtocol) {
            return (Search) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Parent resource of the reports, indicating the application for which they
           * were received. Format: apps/{app}
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Parent resource of the reports, indicating the application for which they were received.
         Format: apps/{app}
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. Parent resource of the reports, indicating the application for which they
           * were received. Format: apps/{app}
           */
          public Search setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^apps/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A selection predicate to retrieve only a subset of the reports. For filtering basics,
           * please check [AIP-160](https://google.aip.dev/160). ** Supported field names:** *
           * `apiLevel`: Matches error reports that occurred in the requested Android versions
           * (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. *
           * `versionCode`: Matches error reports that occurred in the requested app version codes
           * only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error
           * issues that occurred in the requested devices. Example: `deviceModel = "google/walleye"
           * OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that occurred
           * in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`:
           * Matches error reports that occurred in the requested device types. Example: `deviceType
           * = "PHONE"`. * `errorIssueType`: Matches error reports of the requested types only.
           * Valid candidates: `CRASH`, `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR
           * errorIssueType = ANR`. * `errorIssueId`: Matches error reports belonging to the
           * requested error issue ids only. Example: `errorIssueId = 1234 OR errorIssueId = 4567`.
           * * `errorReportId`: Matches error reports with the requested error report id. Example:
           * `errorReportId = 1234 OR errorReportId = 4567`. * `appProcessState`: Matches error
           * reports on the process state of an app, indicating whether an app runs in the
           * foreground (user-visible) or background. Valid candidates: `FOREGROUND`, `BACKGROUND`.
           * Example: `appProcessState = FOREGROUND`. * `isUserPerceived`: Matches error reports
           * that are user-perceived. It is not accompanied by any operators. Example:
           * `isUserPerceived`. ** Supported operators:** * Comparison operators: The only supported
           * comparison operator is equality. The filtered field must appear on the left hand side
           * of the comparison. * Logical Operators: Logical operators `AND` and `OR` can be used to
           * build complex filters following a conjunctive normal form (CNF), i.e., conjunctions of
           * disjunctions. The `OR` operator takes precedence over `AND` so the use of parenthesis
           * is not necessary when building CNF. The `OR` operator is only supported to build
           * disjunctions that apply to the same field, e.g., `versionCode = 123 OR versionCode =
           * ANR`. The filter expression `versionCode = 123 OR errorIssueType = ANR` is not valid.
           * ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND
           * errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType =
           * CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** A selection predicate to retrieve only a subset of the reports. For filtering basics, please check
         [AIP-160](https://google.aip.dev/160). ** Supported field names:** * `apiLevel`: Matches error
         reports that occurred in the requested Android versions (specified as the numeric API level) only.
         Example: `apiLevel = 28 OR apiLevel = 29`. * `versionCode`: Matches error reports that occurred in
         the requested app version codes only. Example: `versionCode = 123 OR versionCode = 456`. *
         `deviceModel`: Matches error issues that occurred in the requested devices. Example: `deviceModel =
         "google/walleye" OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that
         occurred in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`: Matches
         error reports that occurred in the requested device types. Example: `deviceType = "PHONE"`. *
         `errorIssueType`: Matches error reports of the requested types only. Valid candidates: `CRASH`,
         `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR errorIssueType = ANR`. * `errorIssueId`:
         Matches error reports belonging to the requested error issue ids only. Example: `errorIssueId =
         1234 OR errorIssueId = 4567`. * `errorReportId`: Matches error reports with the requested error
         report id. Example: `errorReportId = 1234 OR errorReportId = 4567`. * `appProcessState`: Matches
         error reports on the process state of an app, indicating whether an app runs in the foreground
         (user-visible) or background. Valid candidates: `FOREGROUND`, `BACKGROUND`. Example:
         `appProcessState = FOREGROUND`. * `isUserPerceived`: Matches error reports that are user-perceived.
         It is not accompanied by any operators. Example: `isUserPerceived`. ** Supported operators:** *
         Comparison operators: The only supported comparison operator is equality. The filtered field must
         appear on the left hand side of the comparison. * Logical Operators: Logical operators `AND` and
         `OR` can be used to build complex filters following a conjunctive normal form (CNF), i.e.,
         conjunctions of disjunctions. The `OR` operator takes precedence over `AND` so the use of
         parenthesis is not necessary when building CNF. The `OR` operator is only supported to build
         disjunctions that apply to the same field, e.g., `versionCode = 123 OR versionCode = ANR`. The
         filter expression `versionCode = 123 OR errorIssueType = ANR` is not valid. ** Examples ** Some
         valid filtering expressions: * `versionCode = 123 AND errorIssueType = ANR` * `versionCode = 123
         AND errorIssueType = OR errorIssueType = CRASH` * `versionCode = 123 AND (errorIssueType = OR
         errorIssueType = CRASH)`
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * A selection predicate to retrieve only a subset of the reports. For filtering basics,
           * please check [AIP-160](https://google.aip.dev/160). ** Supported field names:** *
           * `apiLevel`: Matches error reports that occurred in the requested Android versions
           * (specified as the numeric API level) only. Example: `apiLevel = 28 OR apiLevel = 29`. *
           * `versionCode`: Matches error reports that occurred in the requested app version codes
           * only. Example: `versionCode = 123 OR versionCode = 456`. * `deviceModel`: Matches error
           * issues that occurred in the requested devices. Example: `deviceModel = "google/walleye"
           * OR deviceModel = "google/marlin"`. * `deviceBrand`: Matches error issues that occurred
           * in the requested device brands. Example: `deviceBrand = "Google". * `deviceType`:
           * Matches error reports that occurred in the requested device types. Example: `deviceType
           * = "PHONE"`. * `errorIssueType`: Matches error reports of the requested types only.
           * Valid candidates: `CRASH`, `ANR`, `NON_FATAL`. Example: `errorIssueType = CRASH OR
           * errorIssueType = ANR`. * `errorIssueId`: Matches error reports belonging to the
           * requested error issue ids only. Example: `errorIssueId = 1234 OR errorIssueId = 4567`.
           * * `errorReportId`: Matches error reports with the requested error report id. Example:
           * `errorReportId = 1234 OR errorReportId = 4567`. * `appProcessState`: Matches error
           * reports on the process state of an app, indicating whether an app runs in the
           * foreground (user-visible) or background. Valid candidates: `FOREGROUND`, `BACKGROUND`.
           * Example: `appProcessState = FOREGROUND`. * `isUserPerceived`: Matches error reports
           * that are user-perceived. It is not accompanied by any operators. Example:
           * `isUserPerceived`. ** Supported operators:** * Comparison operators: The only supported
           * comparison operator is equality. The filtered field must appear on the left hand side
           * of the comparison. * Logical Operators: Logical operators `AND` and `OR` can be used to
           * build complex filters following a conjunctive normal form (CNF), i.e., conjunctions of
           * disjunctions. The `OR` operator takes precedence over `AND` so the use of parenthesis
           * is not necessary when building CNF. The `OR` operator is only supported to build
           * disjunctions that apply to the same field, e.g., `versionCode = 123 OR versionCode =
           * ANR`. The filter expression `versionCode = 123 OR errorIssueType = ANR` is not valid.
           * ** Examples ** Some valid filtering expressions: * `versionCode = 123 AND
           * errorIssueType = ANR` * `versionCode = 123 AND errorIssueType = OR errorIssueType =
           * CRASH` * `versionCode = 123 AND (errorIssueType = OR errorIssueType = CRASH)`
           */
          public Search setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          @com.google.api.client.util.Key("interval.endTime.day")
          private java.lang.Integer intervalEndTimeDay;

          /** Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a
         datetime without a day.
           */
          public java.lang.Integer getIntervalEndTimeDay() {
            return intervalEndTimeDay;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          public Search setIntervalEndTimeDay(java.lang.Integer intervalEndTimeDay) {
            this.intervalEndTimeDay = intervalEndTimeDay;
            return this;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          @com.google.api.client.util.Key("interval.endTime.hours")
          private java.lang.Integer intervalEndTimeHours;

          /** Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API
         may choose to allow the value "24:00:00" for scenarios like business closing time.
           */
          public java.lang.Integer getIntervalEndTimeHours() {
            return intervalEndTimeHours;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          public Search setIntervalEndTimeHours(java.lang.Integer intervalEndTimeHours) {
            this.intervalEndTimeHours = intervalEndTimeHours;
            return this;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          @com.google.api.client.util.Key("interval.endTime.minutes")
          private java.lang.Integer intervalEndTimeMinutes;

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
           */
          public java.lang.Integer getIntervalEndTimeMinutes() {
            return intervalEndTimeMinutes;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          public Search setIntervalEndTimeMinutes(java.lang.Integer intervalEndTimeMinutes) {
            this.intervalEndTimeMinutes = intervalEndTimeMinutes;
            return this;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          @com.google.api.client.util.Key("interval.endTime.month")
          private java.lang.Integer intervalEndTimeMonth;

          /** Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
           */
          public java.lang.Integer getIntervalEndTimeMonth() {
            return intervalEndTimeMonth;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          public Search setIntervalEndTimeMonth(java.lang.Integer intervalEndTimeMonth) {
            this.intervalEndTimeMonth = intervalEndTimeMonth;
            return this;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          @com.google.api.client.util.Key("interval.endTime.nanos")
          private java.lang.Integer intervalEndTimeNanos;

          /** Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
           */
          public java.lang.Integer getIntervalEndTimeNanos() {
            return intervalEndTimeNanos;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          public Search setIntervalEndTimeNanos(java.lang.Integer intervalEndTimeNanos) {
            this.intervalEndTimeNanos = intervalEndTimeNanos;
            return this;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          @com.google.api.client.util.Key("interval.endTime.seconds")
          private java.lang.Integer intervalEndTimeSeconds;

          /** Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may
         allow the value 60 if it allows leap-seconds.
           */
          public java.lang.Integer getIntervalEndTimeSeconds() {
            return intervalEndTimeSeconds;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          public Search setIntervalEndTimeSeconds(java.lang.Integer intervalEndTimeSeconds) {
            this.intervalEndTimeSeconds = intervalEndTimeSeconds;
            return this;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          @com.google.api.client.util.Key("interval.endTime.timeZone.id")
          private java.lang.String intervalEndTimeTimeZoneId;

          /** IANA Time Zone Database time zone. For example "America/New_York".
           */
          public java.lang.String getIntervalEndTimeTimeZoneId() {
            return intervalEndTimeTimeZoneId;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          public Search setIntervalEndTimeTimeZoneId(java.lang.String intervalEndTimeTimeZoneId) {
            this.intervalEndTimeTimeZoneId = intervalEndTimeTimeZoneId;
            return this;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          @com.google.api.client.util.Key("interval.endTime.timeZone.version")
          private java.lang.String intervalEndTimeTimeZoneVersion;

          /** Optional. IANA Time Zone Database version number. For example "2019a".
           */
          public java.lang.String getIntervalEndTimeTimeZoneVersion() {
            return intervalEndTimeTimeZoneVersion;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          public Search setIntervalEndTimeTimeZoneVersion(java.lang.String intervalEndTimeTimeZoneVersion) {
            this.intervalEndTimeTimeZoneVersion = intervalEndTimeTimeZoneVersion;
            return this;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          @com.google.api.client.util.Key("interval.endTime.utcOffset")
          private String intervalEndTimeUtcOffset;

          /** UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of
         -4:00 would be represented as { seconds: -14400 }.
           */
          public String getIntervalEndTimeUtcOffset() {
            return intervalEndTimeUtcOffset;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          public Search setIntervalEndTimeUtcOffset(String intervalEndTimeUtcOffset) {
            this.intervalEndTimeUtcOffset = intervalEndTimeUtcOffset;
            return this;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          @com.google.api.client.util.Key("interval.endTime.year")
          private java.lang.Integer intervalEndTimeYear;

          /** Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
           */
          public java.lang.Integer getIntervalEndTimeYear() {
            return intervalEndTimeYear;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          public Search setIntervalEndTimeYear(java.lang.Integer intervalEndTimeYear) {
            this.intervalEndTimeYear = intervalEndTimeYear;
            return this;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          @com.google.api.client.util.Key("interval.startTime.day")
          private java.lang.Integer intervalStartTimeDay;

          /** Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a
         datetime without a day.
           */
          public java.lang.Integer getIntervalStartTimeDay() {
            return intervalStartTimeDay;
          }

          /**
           * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if
           * specifying a datetime without a day.
           */
          public Search setIntervalStartTimeDay(java.lang.Integer intervalStartTimeDay) {
            this.intervalStartTimeDay = intervalStartTimeDay;
            return this;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          @com.google.api.client.util.Key("interval.startTime.hours")
          private java.lang.Integer intervalStartTimeHours;

          /** Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API
         may choose to allow the value "24:00:00" for scenarios like business closing time.
           */
          public java.lang.Integer getIntervalStartTimeHours() {
            return intervalStartTimeHours;
          }

          /**
           * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0
           * (midnight). An API may choose to allow the value "24:00:00" for scenarios like business
           * closing time.
           */
          public Search setIntervalStartTimeHours(java.lang.Integer intervalStartTimeHours) {
            this.intervalStartTimeHours = intervalStartTimeHours;
            return this;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          @com.google.api.client.util.Key("interval.startTime.minutes")
          private java.lang.Integer intervalStartTimeMinutes;

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
           */
          public java.lang.Integer getIntervalStartTimeMinutes() {
            return intervalStartTimeMinutes;
          }

          /** Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0. */
          public Search setIntervalStartTimeMinutes(java.lang.Integer intervalStartTimeMinutes) {
            this.intervalStartTimeMinutes = intervalStartTimeMinutes;
            return this;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          @com.google.api.client.util.Key("interval.startTime.month")
          private java.lang.Integer intervalStartTimeMonth;

          /** Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
           */
          public java.lang.Integer getIntervalStartTimeMonth() {
            return intervalStartTimeMonth;
          }

          /**
           * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a
           * month.
           */
          public Search setIntervalStartTimeMonth(java.lang.Integer intervalStartTimeMonth) {
            this.intervalStartTimeMonth = intervalStartTimeMonth;
            return this;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          @com.google.api.client.util.Key("interval.startTime.nanos")
          private java.lang.Integer intervalStartTimeNanos;

          /** Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
           */
          public java.lang.Integer getIntervalStartTimeNanos() {
            return intervalStartTimeNanos;
          }

          /**
           * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults
           * to 0.
           */
          public Search setIntervalStartTimeNanos(java.lang.Integer intervalStartTimeNanos) {
            this.intervalStartTimeNanos = intervalStartTimeNanos;
            return this;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          @com.google.api.client.util.Key("interval.startTime.seconds")
          private java.lang.Integer intervalStartTimeSeconds;

          /** Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may
         allow the value 60 if it allows leap-seconds.
           */
          public java.lang.Integer getIntervalStartTimeSeconds() {
            return intervalStartTimeSeconds;
          }

          /**
           * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0.
           * An API may allow the value 60 if it allows leap-seconds.
           */
          public Search setIntervalStartTimeSeconds(java.lang.Integer intervalStartTimeSeconds) {
            this.intervalStartTimeSeconds = intervalStartTimeSeconds;
            return this;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          @com.google.api.client.util.Key("interval.startTime.timeZone.id")
          private java.lang.String intervalStartTimeTimeZoneId;

          /** IANA Time Zone Database time zone. For example "America/New_York".
           */
          public java.lang.String getIntervalStartTimeTimeZoneId() {
            return intervalStartTimeTimeZoneId;
          }

          /** IANA Time Zone Database time zone. For example "America/New_York". */
          public Search setIntervalStartTimeTimeZoneId(java.lang.String intervalStartTimeTimeZoneId) {
            this.intervalStartTimeTimeZoneId = intervalStartTimeTimeZoneId;
            return this;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          @com.google.api.client.util.Key("interval.startTime.timeZone.version")
          private java.lang.String intervalStartTimeTimeZoneVersion;

          /** Optional. IANA Time Zone Database version number. For example "2019a".
           */
          public java.lang.String getIntervalStartTimeTimeZoneVersion() {
            return intervalStartTimeTimeZoneVersion;
          }

          /** Optional. IANA Time Zone Database version number. For example "2019a". */
          public Search setIntervalStartTimeTimeZoneVersion(java.lang.String intervalStartTimeTimeZoneVersion) {
            this.intervalStartTimeTimeZoneVersion = intervalStartTimeTimeZoneVersion;
            return this;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          @com.google.api.client.util.Key("interval.startTime.utcOffset")
          private String intervalStartTimeUtcOffset;

          /** UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of
         -4:00 would be represented as { seconds: -14400 }.
           */
          public String getIntervalStartTimeUtcOffset() {
            return intervalStartTimeUtcOffset;
          }

          /**
           * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC
           * offset of -4:00 would be represented as { seconds: -14400 }.
           */
          public Search setIntervalStartTimeUtcOffset(String intervalStartTimeUtcOffset) {
            this.intervalStartTimeUtcOffset = intervalStartTimeUtcOffset;
            return this;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          @com.google.api.client.util.Key("interval.startTime.year")
          private java.lang.Integer intervalStartTimeYear;

          /** Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
           */
          public java.lang.Integer getIntervalStartTimeYear() {
            return intervalStartTimeYear;
          }

          /**
           * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a
           * year.
           */
          public Search setIntervalStartTimeYear(java.lang.Integer intervalStartTimeYear) {
            this.intervalStartTimeYear = intervalStartTimeYear;
            return this;
          }

          /**
           * The maximum number of reports to return. The service may return fewer than this value.
           * If unspecified, at most 50 reports will be returned. The maximum value is 100; values
           * above 100 will be coerced to 100.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of reports to return. The service may return fewer than this value. If
         unspecified, at most 50 reports will be returned. The maximum value is 100; values above 100 will
         be coerced to 100.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of reports to return. The service may return fewer than this value.
           * If unspecified, at most 50 reports will be returned. The maximum value is 100; values
           * above 100 will be coerced to 100.
           */
          public Search setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A page token, received from a previous `SearchErrorReports` call. Provide this to
           * retrieve the subsequent page. When paginating, all other parameters provided to
           * `SearchErrorReports` must match the call that provided the page token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A page token, received from a previous `SearchErrorReports` call. Provide this to retrieve the
         subsequent page. When paginating, all other parameters provided to `SearchErrorReports` must match
         the call that provided the page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A page token, received from a previous `SearchErrorReports` call. Provide this to
           * retrieve the subsequent page. When paginating, all other parameters provided to
           * `SearchErrorReports` must match the call that provided the page token.
           */
          public Search setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public Search set(String parameterName, Object value) {
            return (Search) super.set(parameterName, value);
          }
        }

      }
    }
    /**
     * An accessor for creating requests from the Excessivewakeuprate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Excessivewakeuprate.List request = playdeveloperreporting.excessivewakeuprate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Excessivewakeuprate excessivewakeuprate() {
      return new Excessivewakeuprate();
    }

    /**
     * The "excessivewakeuprate" collection of methods.
     */
    public class Excessivewakeuprate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "excessivewakeuprate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/excessiveWakeupRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "excessivewakeuprate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/excessiveWakeupRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/excessiveWakeupRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "excessivewakeuprate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/excessiveWakeupRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "excessivewakeuprate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/excessiveWakeupRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/excessiveWakeupRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Slowrenderingrate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Slowrenderingrate.List request = playdeveloperreporting.slowrenderingrate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Slowrenderingrate slowrenderingrate() {
      return new Slowrenderingrate();
    }

    /**
     * The "slowrenderingrate" collection of methods.
     */
    public class Slowrenderingrate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "slowrenderingrate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SlowRenderingRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/slowRenderingRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "slowrenderingrate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SlowRenderingRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowRenderingRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowRenderingRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "slowrenderingrate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/slowRenderingRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "slowrenderingrate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowRenderingRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowRenderingRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/slowRenderingRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowRenderingRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Slowstartrate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Slowstartrate.List request = playdeveloperreporting.slowstartrate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Slowstartrate slowstartrate() {
      return new Slowstartrate();
    }

    /**
     * The "slowstartrate" collection of methods.
     */
    public class Slowstartrate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "slowstartrate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SlowStartRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/slowStartRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "slowstartrate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1SlowStartRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowStartRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowStartRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "slowstartrate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/slowStartRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "slowstartrate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QuerySlowStartRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowStartRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/slowStartRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/slowStartRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Stuckbackgroundwakelockrate collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Playdeveloperreporting playdeveloperreporting = new Playdeveloperreporting(...);}
     *   {@code Playdeveloperreporting.Stuckbackgroundwakelockrate.List request = playdeveloperreporting.stuckbackgroundwakelockrate().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Stuckbackgroundwakelockrate stuckbackgroundwakelockrate() {
      return new Stuckbackgroundwakelockrate();
    }

    /**
     * The "stuckbackgroundwakelockrate" collection of methods.
     */
    public class Stuckbackgroundwakelockrate {

      /**
       * Describes the properties of the metric set.
       *
       * Create a request for the method "stuckbackgroundwakelockrate.get".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet> {

        private static final String REST_PATH = "v1beta1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");

        /**
         * Describes the properties of the metric set.
         *
         * Create a request for the method "stuckbackgroundwakelockrate.get".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(Playdeveloperreporting.this, "GET", REST_PATH, null, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1StuckBackgroundWakelockRateMetricSet.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Queries the metrics in the metric set.
       *
       * Create a request for the method "stuckbackgroundwakelockrate.query".
       *
       * This request holds the parameters needed by the playdeveloperreporting server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       *
       * @param name Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
       * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest}
       * @return the request
       */
      public Query query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest content) throws java.io.IOException {
        Query result = new Query(name, content);
        initialize(result);
        return result;
      }

      public class Query extends PlaydeveloperreportingRequest<com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse> {

        private static final String REST_PATH = "v1beta1/{+name}:query";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");

        /**
         * Queries the metrics in the metric set.
         *
         * Create a request for the method "stuckbackgroundwakelockrate.query".
         *
         * This request holds the parameters needed by the the playdeveloperreporting server.  After
         * setting any optional parameters, call the {@link Query#execute()} method to invoke the remote
         * operation. <p> {@link
         * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
         * @param content the {@link com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest}
         * @since 1.13
         */
        protected Query(java.lang.String name, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetRequest content) {
          super(Playdeveloperreporting.this, "POST", REST_PATH, content, com.google.api.services.playdeveloperreporting.v1beta1.model.GooglePlayDeveloperReportingV1beta1QueryStuckBackgroundWakelockRateMetricSetResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");
          }
        }

        @Override
        public Query set$Xgafv(java.lang.String $Xgafv) {
          return (Query) super.set$Xgafv($Xgafv);
        }

        @Override
        public Query setAccessToken(java.lang.String accessToken) {
          return (Query) super.setAccessToken(accessToken);
        }

        @Override
        public Query setAlt(java.lang.String alt) {
          return (Query) super.setAlt(alt);
        }

        @Override
        public Query setCallback(java.lang.String callback) {
          return (Query) super.setCallback(callback);
        }

        @Override
        public Query setFields(java.lang.String fields) {
          return (Query) super.setFields(fields);
        }

        @Override
        public Query setKey(java.lang.String key) {
          return (Query) super.setKey(key);
        }

        @Override
        public Query setOauthToken(java.lang.String oauthToken) {
          return (Query) super.setOauthToken(oauthToken);
        }

        @Override
        public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Query) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Query setQuotaUser(java.lang.String quotaUser) {
          return (Query) super.setQuotaUser(quotaUser);
        }

        @Override
        public Query setUploadType(java.lang.String uploadType) {
          return (Query) super.setUploadType(uploadType);
        }

        @Override
        public Query setUploadProtocol(java.lang.String uploadProtocol) {
          return (Query) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name. Format: apps/{app}/stuckBackgroundWakelockRateMetricSet */
        public Query setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^apps/[^/]+/stuckBackgroundWakelockRateMetricSet$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Query set(String parameterName, Object value) {
          return (Query) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Playdeveloperreporting}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Playdeveloperreporting}. */
    @Override
    public Playdeveloperreporting build() {
      return new Playdeveloperreporting(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PlaydeveloperreportingRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPlaydeveloperreportingRequestInitializer(
        PlaydeveloperreportingRequestInitializer playdeveloperreportingRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(playdeveloperreportingRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }

    @Override
    public Builder setUniverseDomain(String universeDomain) {
      return (Builder) super.setUniverseDomain(universeDomain);
    }
  }
}
