/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents an anomaly detected in a dataset. Our anomaly detection systems flag datapoints in a
 * time series that fall outside of and expected range derived from historical data. Although those
 * expected ranges have an upper and a lower bound, we only flag anomalies when the data has become
 * unexpectedly _worse_, which usually corresponds to the case where the metric crosses the upper
 * bound. Multiple contiguous datapoints in a timeline outside of the expected range will be grouped
 * into a single anomaly. Therefore, an anomaly represents effectively a segment of a metric's
 * timeline. The information stored in the `timeline_spec`, `dimensions` and `metric` can be used to
 * fetch a full timeline with extended ragne for context. **Required permissions**: to access this
 * resource, the calling user needs the _View app information (read-only)_ permission for the app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1Anomaly extends com.google.api.client.json.GenericJson {

  /**
   * Combination of dimensions in which the anomaly was detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> dimensions;

  /**
   * Metric where the anomaly was detected, together with the anomalous value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1MetricValue metric;

  /**
   * Metric set resource where the anomaly was detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metricSet;

  /**
   * Identifier. Name of the anomaly. Format: apps/{app}/anomalies/{anomaly}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Timeline specification that covers the anomaly period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1TimelineSpec timelineSpec;

  /**
   * Combination of dimensions in which the anomaly was detected.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> getDimensions() {
    return dimensions;
  }

  /**
   * Combination of dimensions in which the anomaly was detected.
   * @param dimensions dimensions or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Anomaly setDimensions(java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Metric where the anomaly was detected, together with the anomalous value.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricValue getMetric() {
    return metric;
  }

  /**
   * Metric where the anomaly was detected, together with the anomalous value.
   * @param metric metric or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Anomaly setMetric(GooglePlayDeveloperReportingV1beta1MetricValue metric) {
    this.metric = metric;
    return this;
  }

  /**
   * Metric set resource where the anomaly was detected.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetricSet() {
    return metricSet;
  }

  /**
   * Metric set resource where the anomaly was detected.
   * @param metricSet metricSet or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Anomaly setMetricSet(java.lang.String metricSet) {
    this.metricSet = metricSet;
    return this;
  }

  /**
   * Identifier. Name of the anomaly. Format: apps/{app}/anomalies/{anomaly}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. Name of the anomaly. Format: apps/{app}/anomalies/{anomaly}
   * @param name name or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Anomaly setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Timeline specification that covers the anomaly period.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1TimelineSpec getTimelineSpec() {
    return timelineSpec;
  }

  /**
   * Timeline specification that covers the anomaly period.
   * @param timelineSpec timelineSpec or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Anomaly setTimelineSpec(GooglePlayDeveloperReportingV1beta1TimelineSpec timelineSpec) {
    this.timelineSpec = timelineSpec;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1Anomaly set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1Anomaly) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1Anomaly clone() {
    return (GooglePlayDeveloperReportingV1beta1Anomaly) super.clone();
  }

}
