/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * A representation of an app in the Play Store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1App extends com.google.api.client.json.GenericJson {

  /**
   * Title of the app. This is the latest title as set in the Play Console and may not yet have been
   * reviewed, so might not match the Play Store. Example: `Google Maps`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Identifier. The resource name. Format: apps/{app}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Package name of the app. Example: `com.example.app123`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Title of the app. This is the latest title as set in the Play Console and may not yet have been
   * reviewed, so might not match the Play Store. Example: `Google Maps`.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Title of the app. This is the latest title as set in the Play Console and may not yet have been
   * reviewed, so might not match the Play Store. Example: `Google Maps`.
   * @param displayName displayName or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1App setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Identifier. The resource name. Format: apps/{app}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. The resource name. Format: apps/{app}
   * @param name name or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1App setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Package name of the app. Example: `com.example.app123`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Package name of the app. Example: `com.example.app123`.
   * @param packageName packageName or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1App setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1App set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1App) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1App clone() {
    return (GooglePlayDeveloperReportingV1beta1App) super.clone();
  }

}
