/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents the confidence interval of a metric.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval extends com.google.api.client.json.GenericJson {

  /**
   * The confidence interval's lower bound.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDecimal lowerBound;

  /**
   * The confidence interval's upper bound.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDecimal upperBound;

  /**
   * The confidence interval's lower bound.
   * @return value or {@code null} for none
   */
  public GoogleTypeDecimal getLowerBound() {
    return lowerBound;
  }

  /**
   * The confidence interval's lower bound.
   * @param lowerBound lowerBound or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval setLowerBound(GoogleTypeDecimal lowerBound) {
    this.lowerBound = lowerBound;
    return this;
  }

  /**
   * The confidence interval's upper bound.
   * @return value or {@code null} for none
   */
  public GoogleTypeDecimal getUpperBound() {
    return upperBound;
  }

  /**
   * The confidence interval's upper bound.
   * @param upperBound upperBound or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval setUpperBound(GoogleTypeDecimal upperBound) {
    this.upperBound = upperBound;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval clone() {
    return (GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval) super.clone();
  }

}
