/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Summary of a device
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1DeviceModelSummary extends com.google.api.client.json.GenericJson {

  /**
   * Identifier of the device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1DeviceId deviceId;

  /**
   * Link to the device in Play Device Catalog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceUri;

  /**
   * Display name of the device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String marketingName;

  /**
   * Identifier of the device.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DeviceId getDeviceId() {
    return deviceId;
  }

  /**
   * Identifier of the device.
   * @param deviceId deviceId or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary setDeviceId(GooglePlayDeveloperReportingV1beta1DeviceId deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  /**
   * Link to the device in Play Device Catalog.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceUri() {
    return deviceUri;
  }

  /**
   * Link to the device in Play Device Catalog.
   * @param deviceUri deviceUri or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary setDeviceUri(java.lang.String deviceUri) {
    this.deviceUri = deviceUri;
    return this;
  }

  /**
   * Display name of the device.
   * @return value or {@code null} for none
   */
  public java.lang.String getMarketingName() {
    return marketingName;
  }

  /**
   * Display name of the device.
   * @param marketingName marketingName or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary setMarketingName(java.lang.String marketingName) {
    this.marketingName = marketingName;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1DeviceModelSummary) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary clone() {
    return (GooglePlayDeveloperReportingV1beta1DeviceModelSummary) super.clone();
  }

}
