/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents the value of a single dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1DimensionValue extends com.google.api.client.json.GenericJson {

  /**
   * Name of the dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimension;

  /**
   * Actual value, represented as an int64.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long int64Value;

  /**
   * Actual value, represented as a string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stringValue;

  /**
   * Optional. Human-friendly label for the value, always in English. For example, 'Spain' for the
   * 'ES' country code. Whereas the dimension value is stable, this value label is subject to
   * change. Do not assume that the (value, value_label) relationship is stable. For example, the
   * ISO country code 'MK' changed its name recently to 'North Macedonia'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valueLabel;

  /**
   * Name of the dimension.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimension() {
    return dimension;
  }

  /**
   * Name of the dimension.
   * @param dimension dimension or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DimensionValue setDimension(java.lang.String dimension) {
    this.dimension = dimension;
    return this;
  }

  /**
   * Actual value, represented as an int64.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInt64Value() {
    return int64Value;
  }

  /**
   * Actual value, represented as an int64.
   * @param int64Value int64Value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DimensionValue setInt64Value(java.lang.Long int64Value) {
    this.int64Value = int64Value;
    return this;
  }

  /**
   * Actual value, represented as a string.
   * @return value or {@code null} for none
   */
  public java.lang.String getStringValue() {
    return stringValue;
  }

  /**
   * Actual value, represented as a string.
   * @param stringValue stringValue or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DimensionValue setStringValue(java.lang.String stringValue) {
    this.stringValue = stringValue;
    return this;
  }

  /**
   * Optional. Human-friendly label for the value, always in English. For example, 'Spain' for the
   * 'ES' country code. Whereas the dimension value is stable, this value label is subject to
   * change. Do not assume that the (value, value_label) relationship is stable. For example, the
   * ISO country code 'MK' changed its name recently to 'North Macedonia'.
   * @return value or {@code null} for none
   */
  public java.lang.String getValueLabel() {
    return valueLabel;
  }

  /**
   * Optional. Human-friendly label for the value, always in English. For example, 'Spain' for the
   * 'ES' country code. Whereas the dimension value is stable, this value label is subject to
   * change. Do not assume that the (value, value_label) relationship is stable. For example, the
   * ISO country code 'MK' changed its name recently to 'North Macedonia'.
   * @param valueLabel valueLabel or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DimensionValue setValueLabel(java.lang.String valueLabel) {
    this.valueLabel = valueLabel;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DimensionValue set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1DimensionValue) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1DimensionValue clone() {
    return (GooglePlayDeveloperReportingV1beta1DimensionValue) super.clone();
  }

}
