/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * A group of related ErrorReports received for an app. Similar error reports are grouped together
 * into issues with a likely identical root cause. **Please note:** this resource is currently in
 * Alpha. There could be changes to the issue grouping that would result in similar but more recent
 * error reports being assigned to different issues. This could also cause some issues disappearing
 * entirely and being replaced by new ones. **Required permissions**: to access this resource, the
 * calling user needs the _View app information (read-only)_ permission for the app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1ErrorIssue extends com.google.api.client.json.GenericJson {

  /**
   * List of annotations for an issue. Annotations provide additional information that may help in
   * diagnosing and fixing the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1IssueAnnotation> annotations;

  /**
   * Cause of the issue. Depending on the type this can be either: * APPLICATION_NOT_RESPONDING: the
   * type of ANR that occurred, e.g., 'Input dispatching timed out'. * CRASH: for Java unhandled
   * exception errors, the type of the innermost exception that was thrown, e.g.,
   * IllegalArgumentException. For signals in native code, the signal that was raised, e.g. SIGSEGV.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cause;

  /**
   * An estimate of the number of unique users who have experienced this issue (only considering
   * occurrences matching the filters and within the requested time period).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long distinctUsers;

  /**
   * An estimated percentage of users affected by any issue that are affected by this issue (only
   * considering occurrences matching the filters and within the requested time period).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDecimal distinctUsersPercent;

  /**
   * The total number of error reports in this issue (only considering occurrences matching the
   * filters and within the requested time period).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long errorReportCount;

  /**
   * The earliest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1AppVersion firstAppVersion;

  /**
   * The smallest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1OsVersion firstOsVersion;

  /**
   * Link to the issue in Android vitals in the Play Console.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issueUri;

  /**
   * The latest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1AppVersion lastAppVersion;

  /**
   * Start of the hour during which the last error report in this issue occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastErrorReportTime;

  /**
   * The latest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1OsVersion lastOsVersion;

  /**
   * Location where the issue happened. Depending on the type this can be either: *
   * APPLICATION_NOT_RESPONDING: the name of the activity or service that stopped responding. *
   * CRASH: the likely method name that caused the error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Identifier. The resource name of the issue. Format: apps/{app}/{issue}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Sample error reports which belong to this ErrorIssue. *Note:* currently a maximum
   * of 1 per ErrorIssue is supported. Format: "apps/{app}/{report}"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sampleErrorReports;

  /**
   * Type of the errors grouped in this issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * List of annotations for an issue. Annotations provide additional information that may help in
   * diagnosing and fixing the issue.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1IssueAnnotation> getAnnotations() {
    return annotations;
  }

  /**
   * List of annotations for an issue. Annotations provide additional information that may help in
   * diagnosing and fixing the issue.
   * @param annotations annotations or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setAnnotations(java.util.List<GooglePlayDeveloperReportingV1beta1IssueAnnotation> annotations) {
    this.annotations = annotations;
    return this;
  }

  /**
   * Cause of the issue. Depending on the type this can be either: * APPLICATION_NOT_RESPONDING: the
   * type of ANR that occurred, e.g., 'Input dispatching timed out'. * CRASH: for Java unhandled
   * exception errors, the type of the innermost exception that was thrown, e.g.,
   * IllegalArgumentException. For signals in native code, the signal that was raised, e.g. SIGSEGV.
   * @return value or {@code null} for none
   */
  public java.lang.String getCause() {
    return cause;
  }

  /**
   * Cause of the issue. Depending on the type this can be either: * APPLICATION_NOT_RESPONDING: the
   * type of ANR that occurred, e.g., 'Input dispatching timed out'. * CRASH: for Java unhandled
   * exception errors, the type of the innermost exception that was thrown, e.g.,
   * IllegalArgumentException. For signals in native code, the signal that was raised, e.g. SIGSEGV.
   * @param cause cause or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setCause(java.lang.String cause) {
    this.cause = cause;
    return this;
  }

  /**
   * An estimate of the number of unique users who have experienced this issue (only considering
   * occurrences matching the filters and within the requested time period).
   * @return value or {@code null} for none
   */
  public java.lang.Long getDistinctUsers() {
    return distinctUsers;
  }

  /**
   * An estimate of the number of unique users who have experienced this issue (only considering
   * occurrences matching the filters and within the requested time period).
   * @param distinctUsers distinctUsers or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setDistinctUsers(java.lang.Long distinctUsers) {
    this.distinctUsers = distinctUsers;
    return this;
  }

  /**
   * An estimated percentage of users affected by any issue that are affected by this issue (only
   * considering occurrences matching the filters and within the requested time period).
   * @return value or {@code null} for none
   */
  public GoogleTypeDecimal getDistinctUsersPercent() {
    return distinctUsersPercent;
  }

  /**
   * An estimated percentage of users affected by any issue that are affected by this issue (only
   * considering occurrences matching the filters and within the requested time period).
   * @param distinctUsersPercent distinctUsersPercent or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setDistinctUsersPercent(GoogleTypeDecimal distinctUsersPercent) {
    this.distinctUsersPercent = distinctUsersPercent;
    return this;
  }

  /**
   * The total number of error reports in this issue (only considering occurrences matching the
   * filters and within the requested time period).
   * @return value or {@code null} for none
   */
  public java.lang.Long getErrorReportCount() {
    return errorReportCount;
  }

  /**
   * The total number of error reports in this issue (only considering occurrences matching the
   * filters and within the requested time period).
   * @param errorReportCount errorReportCount or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setErrorReportCount(java.lang.Long errorReportCount) {
    this.errorReportCount = errorReportCount;
    return this;
  }

  /**
   * The earliest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1AppVersion getFirstAppVersion() {
    return firstAppVersion;
  }

  /**
   * The earliest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * @param firstAppVersion firstAppVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setFirstAppVersion(GooglePlayDeveloperReportingV1beta1AppVersion firstAppVersion) {
    this.firstAppVersion = firstAppVersion;
    return this;
  }

  /**
   * The smallest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1OsVersion getFirstOsVersion() {
    return firstOsVersion;
  }

  /**
   * The smallest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * @param firstOsVersion firstOsVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setFirstOsVersion(GooglePlayDeveloperReportingV1beta1OsVersion firstOsVersion) {
    this.firstOsVersion = firstOsVersion;
    return this;
  }

  /**
   * Link to the issue in Android vitals in the Play Console.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssueUri() {
    return issueUri;
  }

  /**
   * Link to the issue in Android vitals in the Play Console.
   * @param issueUri issueUri or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setIssueUri(java.lang.String issueUri) {
    this.issueUri = issueUri;
    return this;
  }

  /**
   * The latest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1AppVersion getLastAppVersion() {
    return lastAppVersion;
  }

  /**
   * The latest (inclusive) app version appearing in this ErrorIssue in the requested time period
   * (only considering occurrences matching the filters).
   * @param lastAppVersion lastAppVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setLastAppVersion(GooglePlayDeveloperReportingV1beta1AppVersion lastAppVersion) {
    this.lastAppVersion = lastAppVersion;
    return this;
  }

  /**
   * Start of the hour during which the last error report in this issue occurred.
   * @return value or {@code null} for none
   */
  public String getLastErrorReportTime() {
    return lastErrorReportTime;
  }

  /**
   * Start of the hour during which the last error report in this issue occurred.
   * @param lastErrorReportTime lastErrorReportTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setLastErrorReportTime(String lastErrorReportTime) {
    this.lastErrorReportTime = lastErrorReportTime;
    return this;
  }

  /**
   * The latest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1OsVersion getLastOsVersion() {
    return lastOsVersion;
  }

  /**
   * The latest OS version in which this error cluster has occurred in the requested time period
   * (only considering occurrences matching the filters and within the requested time period).
   * @param lastOsVersion lastOsVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setLastOsVersion(GooglePlayDeveloperReportingV1beta1OsVersion lastOsVersion) {
    this.lastOsVersion = lastOsVersion;
    return this;
  }

  /**
   * Location where the issue happened. Depending on the type this can be either: *
   * APPLICATION_NOT_RESPONDING: the name of the activity or service that stopped responding. *
   * CRASH: the likely method name that caused the error.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Location where the issue happened. Depending on the type this can be either: *
   * APPLICATION_NOT_RESPONDING: the name of the activity or service that stopped responding. *
   * CRASH: the likely method name that caused the error.
   * @param location location or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Identifier. The resource name of the issue. Format: apps/{app}/{issue}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. The resource name of the issue. Format: apps/{app}/{issue}
   * @param name name or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Sample error reports which belong to this ErrorIssue. *Note:* currently a maximum
   * of 1 per ErrorIssue is supported. Format: "apps/{app}/{report}"
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSampleErrorReports() {
    return sampleErrorReports;
  }

  /**
   * Output only. Sample error reports which belong to this ErrorIssue. *Note:* currently a maximum
   * of 1 per ErrorIssue is supported. Format: "apps/{app}/{report}"
   * @param sampleErrorReports sampleErrorReports or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setSampleErrorReports(java.util.List<java.lang.String> sampleErrorReports) {
    this.sampleErrorReports = sampleErrorReports;
    return this;
  }

  /**
   * Type of the errors grouped in this issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the errors grouped in this issue.
   * @param type type or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorIssue setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ErrorIssue set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1ErrorIssue) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ErrorIssue clone() {
    return (GooglePlayDeveloperReportingV1beta1ErrorIssue) super.clone();
  }

}
