/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * An error report received for an app. There reports are produced by the Android platform code when
 * a (potentially fatal) error condition is detected. Identical reports from many users will be
 * deduplicated and coalesced into a single ErrorReport. **Required permissions**: to access this
 * resource, the calling user needs the _View app information (read-only)_ permission for the app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1ErrorReport extends com.google.api.client.json.GenericJson {

  /**
   * The app version on which an event in this error report occurred on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1AppVersion appVersion;

  /**
   * A device model on which an event in this error report occurred on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1DeviceModelSummary deviceModel;

  /**
   * Start of the hour during which the latest event in this error report occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String eventTime;

  /**
   * The issue this report was associated with. **Please note:** this resource is currently in
   * Alpha. There could be changes to the issue grouping that would result in similar but more
   * recent error reports being assigned to a different issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issue;

  /**
   * The resource name of the report. Format: apps/{app}/{report}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The OS version on which an event in this error report occurred on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1OsVersion osVersion;

  /**
   * Textual representation of the error report. These textual reports are produced by the platform.
   * The reports are then sanitized and filtered to remove any potentially sensitive information.
   * Although their format is fairly stable, they are not entirely meant for machine consumption and
   * we cannot guarantee that there won't be subtle changes to the formatting that may break systems
   * trying to parse information out of the reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportText;

  /**
   * Type of the error for which this report was generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Version control system information from BUNDLE-METADATA/version-control-info.textproto or META-
   * INF/version-control-info.textproto of the app bundle or APK, respectively.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vcsInformation;

  /**
   * The app version on which an event in this error report occurred on.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1AppVersion getAppVersion() {
    return appVersion;
  }

  /**
   * The app version on which an event in this error report occurred on.
   * @param appVersion appVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setAppVersion(GooglePlayDeveloperReportingV1beta1AppVersion appVersion) {
    this.appVersion = appVersion;
    return this;
  }

  /**
   * A device model on which an event in this error report occurred on.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DeviceModelSummary getDeviceModel() {
    return deviceModel;
  }

  /**
   * A device model on which an event in this error report occurred on.
   * @param deviceModel deviceModel or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setDeviceModel(GooglePlayDeveloperReportingV1beta1DeviceModelSummary deviceModel) {
    this.deviceModel = deviceModel;
    return this;
  }

  /**
   * Start of the hour during which the latest event in this error report occurred.
   * @return value or {@code null} for none
   */
  public String getEventTime() {
    return eventTime;
  }

  /**
   * Start of the hour during which the latest event in this error report occurred.
   * @param eventTime eventTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setEventTime(String eventTime) {
    this.eventTime = eventTime;
    return this;
  }

  /**
   * The issue this report was associated with. **Please note:** this resource is currently in
   * Alpha. There could be changes to the issue grouping that would result in similar but more
   * recent error reports being assigned to a different issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssue() {
    return issue;
  }

  /**
   * The issue this report was associated with. **Please note:** this resource is currently in
   * Alpha. There could be changes to the issue grouping that would result in similar but more
   * recent error reports being assigned to a different issue.
   * @param issue issue or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setIssue(java.lang.String issue) {
    this.issue = issue;
    return this;
  }

  /**
   * The resource name of the report. Format: apps/{app}/{report}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the report. Format: apps/{app}/{report}
   * @param name name or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The OS version on which an event in this error report occurred on.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1OsVersion getOsVersion() {
    return osVersion;
  }

  /**
   * The OS version on which an event in this error report occurred on.
   * @param osVersion osVersion or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setOsVersion(GooglePlayDeveloperReportingV1beta1OsVersion osVersion) {
    this.osVersion = osVersion;
    return this;
  }

  /**
   * Textual representation of the error report. These textual reports are produced by the platform.
   * The reports are then sanitized and filtered to remove any potentially sensitive information.
   * Although their format is fairly stable, they are not entirely meant for machine consumption and
   * we cannot guarantee that there won't be subtle changes to the formatting that may break systems
   * trying to parse information out of the reports.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportText() {
    return reportText;
  }

  /**
   * Textual representation of the error report. These textual reports are produced by the platform.
   * The reports are then sanitized and filtered to remove any potentially sensitive information.
   * Although their format is fairly stable, they are not entirely meant for machine consumption and
   * we cannot guarantee that there won't be subtle changes to the formatting that may break systems
   * trying to parse information out of the reports.
   * @param reportText reportText or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setReportText(java.lang.String reportText) {
    this.reportText = reportText;
    return this;
  }

  /**
   * Type of the error for which this report was generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the error for which this report was generated.
   * @param type type or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Version control system information from BUNDLE-METADATA/version-control-info.textproto or META-
   * INF/version-control-info.textproto of the app bundle or APK, respectively.
   * @return value or {@code null} for none
   */
  public java.lang.String getVcsInformation() {
    return vcsInformation;
  }

  /**
   * Version control system information from BUNDLE-METADATA/version-control-info.textproto or META-
   * INF/version-control-info.textproto of the app bundle or APK, respectively.
   * @param vcsInformation vcsInformation or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ErrorReport setVcsInformation(java.lang.String vcsInformation) {
    this.vcsInformation = vcsInformation;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ErrorReport set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1ErrorReport) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ErrorReport clone() {
    return (GooglePlayDeveloperReportingV1beta1ErrorReport) super.clone();
  }

}
