/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Singleton resource representing the set of Excessive Weakeups metrics. This metric set contains
 * AlarmManager wakeup counts data combined with process state data to produce a normalized metric
 * independent of user counts. **Supported aggregation periods:** * DAILY: metrics are aggregated in
 * calendar date intervals. Due to historical constraints, the only supported timezone is
 * `America/Los_Angeles`. **Supported metrics:** * `excessiveWakeupRate` (`google.type.Decimal`):
 * Percentage of distinct users in the aggregation period that had more than 10 wakeups per hour. *
 * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling average value of
 * `excessiveWakeupRate` in the last 7 days. The daily values are weighted by the count of distinct
 * users for the day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`): Rolling
 * average value of `excessiveWakeupRate` in the last 28 days. The daily values are weighted by the
 * count of distinct users for the day. * `distinctUsers` (`google.type.Decimal`): Count of distinct
 * users in the aggregation period that were used as normalization value for the
 * `excessiveWakeupRate` metric. A user is counted in this metric if they app was doing any work on
 * the device, i.e., not just active foreground usage but also background work. Care must be taken
 * not to aggregate this count further, as it may result in users being counted multiple times. The
 * value is rounded to the nearest multiple of 10, 100, 1,000 or 1,000,000, depending on the
 * magnitude of the value. **Supported dimensions:** * `apiLevel` (string): the API level of Android
 * that was running on the user's device, e.g., 26. * `versionCode` (int64): version of the app that
 * was running on the user's device. * `deviceModel` (string): unique identifier of the user's
 * device model. The form of the identifier is 'deviceBrand/device', where deviceBrand corresponds
 * to Build.BRAND and device corresponds to Build.DEVICE, e.g., google/coral. * `deviceBrand`
 * (string): unique identifier of the user's device brand, e.g., google. * `deviceType` (string):
 * the type (also known as form factor) of the user's device, e.g., PHONE. * `countryCode` (string):
 * the country or region of the user's device based on their IP address, represented as a 2-letter
 * ISO-3166 code (e.g. US for the United States). * `deviceRamBucket` (int64): RAM of the device, in
 * MB, in buckets (3GB, 4GB, etc.). * `deviceSocMake` (string): Make of the device's primary system-
 * on-chip, e.g., Samsung.
 * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER) *
 * `deviceSocModel` (string): Model of the device's primary system-on-chip, e.g., "Exynos 2100".
 * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MODEL) * `deviceCpuMake`
 * (string): Make of the device's CPU, e.g., Qualcomm. * `deviceCpuModel` (string): Model of the
 * device's CPU, e.g., "Kryo 240". * `deviceGpuMake` (string): Make of the device's GPU, e.g., ARM.
 * * `deviceGpuModel` (string): Model of the device's GPU, e.g., Mali. * `deviceGpuVersion`
 * (string): Version of the device's GPU, e.g., T750. * `deviceVulkanVersion` (string): Vulkan
 * version of the device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL ES version of the
 * device, e.g., "196610". * `deviceScreenSize` (string): Screen size of the device, e.g., NORMAL,
 * LARGE. * `deviceScreenDpi` (string): Screen density of the device, e.g., mdpi, hdpi. **Required
 * permissions**: to access this resource, the calling user needs the _View app information (read-
 * only)_ permission for the app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet extends com.google.api.client.json.GenericJson {

  /**
   * Summary about data freshness in this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1FreshnessInfo freshnessInfo;

  /**
   * Identifier. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Summary about data freshness in this resource.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1FreshnessInfo getFreshnessInfo() {
    return freshnessInfo;
  }

  /**
   * Summary about data freshness in this resource.
   * @param freshnessInfo freshnessInfo or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet setFreshnessInfo(GooglePlayDeveloperReportingV1beta1FreshnessInfo freshnessInfo) {
    this.freshnessInfo = freshnessInfo;
    return this;
  }

  /**
   * Identifier. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. The resource name. Format: apps/{app}/excessiveWakeupRateMetricSet
   * @param name name or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet clone() {
    return (GooglePlayDeveloperReportingV1beta1ExcessiveWakeupRateMetricSet) super.clone();
  }

}
