/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents the latest available time that can be requested in a TimelineSpec. Different
 * aggregation periods have different freshness. For example, `DAILY` aggregation may lag behind
 * `HOURLY` in cases where such aggregation is computed only once at the end of the day.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1FreshnessInfo extends com.google.api.client.json.GenericJson {

  /**
   * Information about data freshness for every supported aggregation period. This field has set
   * semantics, keyed by the `aggregation_period` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness> freshnesses;

  /**
   * Information about data freshness for every supported aggregation period. This field has set
   * semantics, keyed by the `aggregation_period` field.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness> getFreshnesses() {
    return freshnesses;
  }

  /**
   * Information about data freshness for every supported aggregation period. This field has set
   * semantics, keyed by the `aggregation_period` field.
   * @param freshnesses freshnesses or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1FreshnessInfo setFreshnesses(java.util.List<GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness> freshnesses) {
    this.freshnesses = freshnesses;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1FreshnessInfo set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1FreshnessInfo) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1FreshnessInfo clone() {
    return (GooglePlayDeveloperReportingV1beta1FreshnessInfo) super.clone();
  }

}
