/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Information about data freshness for a single aggregation period.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness extends com.google.api.client.json.GenericJson {

  /**
   * Aggregation period for which data is available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregationPeriod;

  /**
   * Latest end time for which data is available, for the aggregation period. The time is specified
   * in the metric set's default timezone. *Note:* time ranges in TimelineSpec are represented as
   * `start_time, end_time)`. For example, if the latest available timeline data point for a `DAILY`
   * aggregation period is `2021-06-23 00:00:00 America/Los_Angeles`, the value of this field would
   * be `2021-06-24 00:00:00 America/Los_Angeles` so it can be easily reused in
   * [TimelineSpec.end_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDateTime latestEndTime;

  /**
   * Aggregation period for which data is available.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregationPeriod() {
    return aggregationPeriod;
  }

  /**
   * Aggregation period for which data is available.
   * @param aggregationPeriod aggregationPeriod or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness setAggregationPeriod(java.lang.String aggregationPeriod) {
    this.aggregationPeriod = aggregationPeriod;
    return this;
  }

  /**
   * Latest end time for which data is available, for the aggregation period. The time is specified
   * in the metric set's default timezone. *Note:* time ranges in TimelineSpec are represented as
   * `start_time, end_time)`. For example, if the latest available timeline data point for a `DAILY`
   * aggregation period is `2021-06-23 00:00:00 America/Los_Angeles`, the value of this field would
   * be `2021-06-24 00:00:00 America/Los_Angeles` so it can be easily reused in
   * [TimelineSpec.end_time.
   * @return value or {@code null} for none
   */
  public GoogleTypeDateTime getLatestEndTime() {
    return latestEndTime;
  }

  /**
   * Latest end time for which data is available, for the aggregation period. The time is specified
   * in the metric set's default timezone. *Note:* time ranges in TimelineSpec are represented as
   * `start_time, end_time)`. For example, if the latest available timeline data point for a `DAILY`
   * aggregation period is `2021-06-23 00:00:00 America/Los_Angeles`, the value of this field would
   * be `2021-06-24 00:00:00 America/Los_Angeles` so it can be easily reused in
   * [TimelineSpec.end_time.
   * @param latestEndTime latestEndTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness setLatestEndTime(GoogleTypeDateTime latestEndTime) {
    this.latestEndTime = latestEndTime;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness clone() {
    return (GooglePlayDeveloperReportingV1beta1FreshnessInfoFreshness) super.clone();
  }

}
