/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Representation of an annotation message for an issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1IssueAnnotation extends com.google.api.client.json.GenericJson {

  /**
   * Contains the contents of the annotation message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String body;

  /**
   * Category that the annotation belongs to. An annotation will belong to a single category.
   * Example categories: "Potential fix", "Insight".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String category;

  /**
   * Title for the annotation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Contains the contents of the annotation message.
   * @return value or {@code null} for none
   */
  public java.lang.String getBody() {
    return body;
  }

  /**
   * Contains the contents of the annotation message.
   * @param body body or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1IssueAnnotation setBody(java.lang.String body) {
    this.body = body;
    return this;
  }

  /**
   * Category that the annotation belongs to. An annotation will belong to a single category.
   * Example categories: "Potential fix", "Insight".
   * @return value or {@code null} for none
   */
  public java.lang.String getCategory() {
    return category;
  }

  /**
   * Category that the annotation belongs to. An annotation will belong to a single category.
   * Example categories: "Potential fix", "Insight".
   * @param category category or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1IssueAnnotation setCategory(java.lang.String category) {
    this.category = category;
    return this;
  }

  /**
   * Title for the annotation.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title for the annotation.
   * @param title title or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1IssueAnnotation setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1IssueAnnotation set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1IssueAnnotation) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1IssueAnnotation clone() {
    return (GooglePlayDeveloperReportingV1beta1IssueAnnotation) super.clone();
  }

}
