/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents the value of a metric.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1MetricValue extends com.google.api.client.json.GenericJson {

  /**
   * Actual value, represented as a decimal number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDecimal decimalValue;

  /**
   * Confidence interval of a value that is of type `type.Decimal`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval decimalValueConfidenceInterval;

  /**
   * Name of the metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * Actual value, represented as a decimal number.
   * @return value or {@code null} for none
   */
  public GoogleTypeDecimal getDecimalValue() {
    return decimalValue;
  }

  /**
   * Actual value, represented as a decimal number.
   * @param decimalValue decimalValue or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricValue setDecimalValue(GoogleTypeDecimal decimalValue) {
    this.decimalValue = decimalValue;
    return this;
  }

  /**
   * Confidence interval of a value that is of type `type.Decimal`.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval getDecimalValueConfidenceInterval() {
    return decimalValueConfidenceInterval;
  }

  /**
   * Confidence interval of a value that is of type `type.Decimal`.
   * @param decimalValueConfidenceInterval decimalValueConfidenceInterval or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricValue setDecimalValueConfidenceInterval(GooglePlayDeveloperReportingV1beta1DecimalConfidenceInterval decimalValueConfidenceInterval) {
    this.decimalValueConfidenceInterval = decimalValueConfidenceInterval;
    return this;
  }

  /**
   * Name of the metric.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * Name of the metric.
   * @param metric metric or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricValue setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1MetricValue set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1MetricValue) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1MetricValue clone() {
    return (GooglePlayDeveloperReportingV1beta1MetricValue) super.clone();
  }

}
