/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Represents a row of dimensions and metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1MetricsRow extends com.google.api.client.json.GenericJson {

  /**
   * Granularity of the aggregation period of the row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregationPeriod;

  /**
   * Dimension columns in the row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> dimensions;

  static {
    // hack to force ProGuard to consider GooglePlayDeveloperReportingV1beta1DimensionValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GooglePlayDeveloperReportingV1beta1DimensionValue.class);
  }

  /**
   * Metric columns in the row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1MetricValue> metrics;

  static {
    // hack to force ProGuard to consider GooglePlayDeveloperReportingV1beta1MetricValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GooglePlayDeveloperReportingV1beta1MetricValue.class);
  }

  /**
   * Starting date (and time for hourly aggregation) of the period covered by this row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDateTime startTime;

  /**
   * Granularity of the aggregation period of the row.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregationPeriod() {
    return aggregationPeriod;
  }

  /**
   * Granularity of the aggregation period of the row.
   * @param aggregationPeriod aggregationPeriod or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricsRow setAggregationPeriod(java.lang.String aggregationPeriod) {
    this.aggregationPeriod = aggregationPeriod;
    return this;
  }

  /**
   * Dimension columns in the row.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> getDimensions() {
    return dimensions;
  }

  /**
   * Dimension columns in the row.
   * @param dimensions dimensions or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricsRow setDimensions(java.util.List<GooglePlayDeveloperReportingV1beta1DimensionValue> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Metric columns in the row.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1MetricValue> getMetrics() {
    return metrics;
  }

  /**
   * Metric columns in the row.
   * @param metrics metrics or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricsRow setMetrics(java.util.List<GooglePlayDeveloperReportingV1beta1MetricValue> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Starting date (and time for hourly aggregation) of the period covered by this row.
   * @return value or {@code null} for none
   */
  public GoogleTypeDateTime getStartTime() {
    return startTime;
  }

  /**
   * Starting date (and time for hourly aggregation) of the period covered by this row.
   * @param startTime startTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1MetricsRow setStartTime(GoogleTypeDateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1MetricsRow set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1MetricsRow) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1MetricsRow clone() {
    return (GooglePlayDeveloperReportingV1beta1MetricsRow) super.clone();
  }

}
