/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Request message for QueryExcessiveWakeupRateMetricSet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest extends com.google.api.client.json.GenericJson {

  /**
   * Dimensions to slice the data by. **Supported dimensions:** * `apiLevel` (string): the API level
   * of Android that was running on the user's device, e.g., 26. * `versionCode` (int64): version of
   * the app that was running on the user's device. * `deviceModel` (string): unique identifier of
   * the user's device model. The form of the identifier is 'deviceBrand/device', where deviceBrand
   * corresponds to Build.BRAND and device corresponds to Build.DEVICE, e.g., google/coral. *
   * `deviceBrand` (string): unique identifier of the user's device brand, e.g., google. *
   * `deviceType` (string): the type (also known as form factor) of the user's device, e.g., PHONE.
   * * `countryCode` (string): the country or region of the user's device based on their IP address,
   * represented as a 2-letter ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
   * (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). * `deviceSocMake` (string):
   * Make of the device's primary system-on-chip, e.g., Samsung.
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER) *
   * `deviceSocModel` (string): Model of the device's primary system-on-chip, e.g., "Exynos 2100".
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MODEL) *
   * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm. * `deviceCpuModel`
   * (string): Model of the device's CPU, e.g., "Kryo 240". * `deviceGpuMake` (string): Make of the
   * device's GPU, e.g., ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g., Mali. *
   * `deviceGpuVersion` (string): Version of the device's GPU, e.g., T750. * `deviceVulkanVersion`
   * (string): Vulkan version of the device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL
   * ES version of the device, e.g., "196610". * `deviceScreenSize` (string): Screen size of the
   * device, e.g., NORMAL, LARGE. * `deviceScreenDpi` (string): Screen density of the device, e.g.,
   * mdpi, hdpi.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dimensions;

  /**
   * Filters to apply to data. The filtering expression follows
   * [AIP-160](https://google.aip.dev/160) standard and supports filtering by equality of all
   * breakdown dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * Metrics to aggregate. **Supported metrics:** * `excessiveWakeupRate` (`google.type.Decimal`):
   * Percentage of distinct users in the aggregation period that had more than 10 wakeups per hour.
   * * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling average value of
   * `excessiveWakeupRate` in the last 7 days. The daily values are weighted by the count of
   * distinct users for the day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`):
   * Rolling average value of `excessiveWakeupRate` in the last 28 days. The daily values are
   * weighted by the count of distinct users for the day. * `distinctUsers` (`google.type.Decimal`):
   * Count of distinct users in the aggregation period that were used as normalization value for the
   * `excessiveWakeupRate` metric. A user is counted in this metric if they app was doing any work
   * on the device, i.e., not just active foreground usage but also background work. Care must be
   * taken not to aggregate this count further, as it may result in users being counted multiple
   * times. The value is rounded to the nearest multiple of 10, 100, 1,000 or 1,000,000, depending
   * on the magnitude of the value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> metrics;

  /**
   * Maximum size of the returned data. If unspecified, at most 1000 rows will be returned. The
   * maximum value is 100000; values above 100000 will be coerced to 100000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pageSize;

  /**
   * A page token, received from a previous call. Provide this to retrieve the subsequent page. When
   * paginating, all other parameters provided to the request must match the call that provided the
   * page token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageToken;

  /**
   * Specification of the timeline aggregation parameters. **Supported aggregation periods:** *
   * DAILY: metrics are aggregated in calendar date intervals. Due to historical constraints, the
   * only supported timezone is `America/Los_Angeles`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GooglePlayDeveloperReportingV1beta1TimelineSpec timelineSpec;

  /**
   * User view to select. The output data will correspond to the selected view. **Supported
   * values:** * `OS_PUBLIC` To select data from all publicly released Android versions. This is the
   * default. Supports all the above dimensions. * `APP_TESTERS` To select data from users who have
   * opted in to be testers. Supports all the above dimensions. * `OS_BETA` To select data from beta
   * android versions only, excluding data from released android versions. Only the following
   * dimensions are supported: * `versionCode` (int64): version of the app that was running on the
   * user's device. * `osBuild` (string): OS build of the user's device, e.g., "T1B2.220916.004".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userCohort;

  /**
   * Dimensions to slice the data by. **Supported dimensions:** * `apiLevel` (string): the API level
   * of Android that was running on the user's device, e.g., 26. * `versionCode` (int64): version of
   * the app that was running on the user's device. * `deviceModel` (string): unique identifier of
   * the user's device model. The form of the identifier is 'deviceBrand/device', where deviceBrand
   * corresponds to Build.BRAND and device corresponds to Build.DEVICE, e.g., google/coral. *
   * `deviceBrand` (string): unique identifier of the user's device brand, e.g., google. *
   * `deviceType` (string): the type (also known as form factor) of the user's device, e.g., PHONE.
   * * `countryCode` (string): the country or region of the user's device based on their IP address,
   * represented as a 2-letter ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
   * (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). * `deviceSocMake` (string):
   * Make of the device's primary system-on-chip, e.g., Samsung.
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER) *
   * `deviceSocModel` (string): Model of the device's primary system-on-chip, e.g., "Exynos 2100".
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MODEL) *
   * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm. * `deviceCpuModel`
   * (string): Model of the device's CPU, e.g., "Kryo 240". * `deviceGpuMake` (string): Make of the
   * device's GPU, e.g., ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g., Mali. *
   * `deviceGpuVersion` (string): Version of the device's GPU, e.g., T750. * `deviceVulkanVersion`
   * (string): Vulkan version of the device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL
   * ES version of the device, e.g., "196610". * `deviceScreenSize` (string): Screen size of the
   * device, e.g., NORMAL, LARGE. * `deviceScreenDpi` (string): Screen density of the device, e.g.,
   * mdpi, hdpi.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDimensions() {
    return dimensions;
  }

  /**
   * Dimensions to slice the data by. **Supported dimensions:** * `apiLevel` (string): the API level
   * of Android that was running on the user's device, e.g., 26. * `versionCode` (int64): version of
   * the app that was running on the user's device. * `deviceModel` (string): unique identifier of
   * the user's device model. The form of the identifier is 'deviceBrand/device', where deviceBrand
   * corresponds to Build.BRAND and device corresponds to Build.DEVICE, e.g., google/coral. *
   * `deviceBrand` (string): unique identifier of the user's device brand, e.g., google. *
   * `deviceType` (string): the type (also known as form factor) of the user's device, e.g., PHONE.
   * * `countryCode` (string): the country or region of the user's device based on their IP address,
   * represented as a 2-letter ISO-3166 code (e.g. US for the United States). * `deviceRamBucket`
   * (int64): RAM of the device, in MB, in buckets (3GB, 4GB, etc.). * `deviceSocMake` (string):
   * Make of the device's primary system-on-chip, e.g., Samsung.
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MANUFACTURER) *
   * `deviceSocModel` (string): Model of the device's primary system-on-chip, e.g., "Exynos 2100".
   * [Reference](https://developer.android.com/reference/android/os/Build#SOC_MODEL) *
   * `deviceCpuMake` (string): Make of the device's CPU, e.g., Qualcomm. * `deviceCpuModel`
   * (string): Model of the device's CPU, e.g., "Kryo 240". * `deviceGpuMake` (string): Make of the
   * device's GPU, e.g., ARM. * `deviceGpuModel` (string): Model of the device's GPU, e.g., Mali. *
   * `deviceGpuVersion` (string): Version of the device's GPU, e.g., T750. * `deviceVulkanVersion`
   * (string): Vulkan version of the device, e.g., "4198400". * `deviceGlEsVersion` (string): OpenGL
   * ES version of the device, e.g., "196610". * `deviceScreenSize` (string): Screen size of the
   * device, e.g., NORMAL, LARGE. * `deviceScreenDpi` (string): Screen density of the device, e.g.,
   * mdpi, hdpi.
   * @param dimensions dimensions or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setDimensions(java.util.List<java.lang.String> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Filters to apply to data. The filtering expression follows
   * [AIP-160](https://google.aip.dev/160) standard and supports filtering by equality of all
   * breakdown dimensions.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * Filters to apply to data. The filtering expression follows
   * [AIP-160](https://google.aip.dev/160) standard and supports filtering by equality of all
   * breakdown dimensions.
   * @param filter filter or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Metrics to aggregate. **Supported metrics:** * `excessiveWakeupRate` (`google.type.Decimal`):
   * Percentage of distinct users in the aggregation period that had more than 10 wakeups per hour.
   * * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling average value of
   * `excessiveWakeupRate` in the last 7 days. The daily values are weighted by the count of
   * distinct users for the day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`):
   * Rolling average value of `excessiveWakeupRate` in the last 28 days. The daily values are
   * weighted by the count of distinct users for the day. * `distinctUsers` (`google.type.Decimal`):
   * Count of distinct users in the aggregation period that were used as normalization value for the
   * `excessiveWakeupRate` metric. A user is counted in this metric if they app was doing any work
   * on the device, i.e., not just active foreground usage but also background work. Care must be
   * taken not to aggregate this count further, as it may result in users being counted multiple
   * times. The value is rounded to the nearest multiple of 10, 100, 1,000 or 1,000,000, depending
   * on the magnitude of the value.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMetrics() {
    return metrics;
  }

  /**
   * Metrics to aggregate. **Supported metrics:** * `excessiveWakeupRate` (`google.type.Decimal`):
   * Percentage of distinct users in the aggregation period that had more than 10 wakeups per hour.
   * * `excessiveWakeupRate7dUserWeighted` (`google.type.Decimal`): Rolling average value of
   * `excessiveWakeupRate` in the last 7 days. The daily values are weighted by the count of
   * distinct users for the day. * `excessiveWakeupRate28dUserWeighted` (`google.type.Decimal`):
   * Rolling average value of `excessiveWakeupRate` in the last 28 days. The daily values are
   * weighted by the count of distinct users for the day. * `distinctUsers` (`google.type.Decimal`):
   * Count of distinct users in the aggregation period that were used as normalization value for the
   * `excessiveWakeupRate` metric. A user is counted in this metric if they app was doing any work
   * on the device, i.e., not just active foreground usage but also background work. Care must be
   * taken not to aggregate this count further, as it may result in users being counted multiple
   * times. The value is rounded to the nearest multiple of 10, 100, 1,000 or 1,000,000, depending
   * on the magnitude of the value.
   * @param metrics metrics or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setMetrics(java.util.List<java.lang.String> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Maximum size of the returned data. If unspecified, at most 1000 rows will be returned. The
   * maximum value is 100000; values above 100000 will be coerced to 100000.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPageSize() {
    return pageSize;
  }

  /**
   * Maximum size of the returned data. If unspecified, at most 1000 rows will be returned. The
   * maximum value is 100000; values above 100000 will be coerced to 100000.
   * @param pageSize pageSize or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setPageSize(java.lang.Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * A page token, received from a previous call. Provide this to retrieve the subsequent page. When
   * paginating, all other parameters provided to the request must match the call that provided the
   * page token.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageToken() {
    return pageToken;
  }

  /**
   * A page token, received from a previous call. Provide this to retrieve the subsequent page. When
   * paginating, all other parameters provided to the request must match the call that provided the
   * page token.
   * @param pageToken pageToken or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setPageToken(java.lang.String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Specification of the timeline aggregation parameters. **Supported aggregation periods:** *
   * DAILY: metrics are aggregated in calendar date intervals. Due to historical constraints, the
   * only supported timezone is `America/Los_Angeles`.
   * @return value or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1TimelineSpec getTimelineSpec() {
    return timelineSpec;
  }

  /**
   * Specification of the timeline aggregation parameters. **Supported aggregation periods:** *
   * DAILY: metrics are aggregated in calendar date intervals. Due to historical constraints, the
   * only supported timezone is `America/Los_Angeles`.
   * @param timelineSpec timelineSpec or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setTimelineSpec(GooglePlayDeveloperReportingV1beta1TimelineSpec timelineSpec) {
    this.timelineSpec = timelineSpec;
    return this;
  }

  /**
   * User view to select. The output data will correspond to the selected view. **Supported
   * values:** * `OS_PUBLIC` To select data from all publicly released Android versions. This is the
   * default. Supports all the above dimensions. * `APP_TESTERS` To select data from users who have
   * opted in to be testers. Supports all the above dimensions. * `OS_BETA` To select data from beta
   * android versions only, excluding data from released android versions. Only the following
   * dimensions are supported: * `versionCode` (int64): version of the app that was running on the
   * user's device. * `osBuild` (string): OS build of the user's device, e.g., "T1B2.220916.004".
   * @return value or {@code null} for none
   */
  public java.lang.String getUserCohort() {
    return userCohort;
  }

  /**
   * User view to select. The output data will correspond to the selected view. **Supported
   * values:** * `OS_PUBLIC` To select data from all publicly released Android versions. This is the
   * default. Supports all the above dimensions. * `APP_TESTERS` To select data from users who have
   * opted in to be testers. Supports all the above dimensions. * `OS_BETA` To select data from beta
   * android versions only, excluding data from released android versions. Only the following
   * dimensions are supported: * `versionCode` (int64): version of the app that was running on the
   * user's device. * `osBuild` (string): OS build of the user's device, e.g., "T1B2.220916.004".
   * @param userCohort userCohort or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest setUserCohort(java.lang.String userCohort) {
    this.userCohort = userCohort;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest clone() {
    return (GooglePlayDeveloperReportingV1beta1QueryExcessiveWakeupRateMetricSetRequest) super.clone();
  }

}
