/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * A set of filtering options for releases and version codes specific to an app.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions extends com.google.api.client.json.GenericJson {

  /**
   * List of tracks to filter releases over. Provides the grouping of version codes under releases
   * and tracks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1Track> tracks;

  /**
   * List of tracks to filter releases over. Provides the grouping of version codes under releases
   * and tracks.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1Track> getTracks() {
    return tracks;
  }

  /**
   * List of tracks to filter releases over. Provides the grouping of version codes under releases
   * and tracks.
   * @param tracks tracks or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions setTracks(java.util.List<GooglePlayDeveloperReportingV1beta1Track> tracks) {
    this.tracks = tracks;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions clone() {
    return (GooglePlayDeveloperReportingV1beta1ReleaseFilterOptions) super.clone();
  }

}
