/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * Specification of the time-related aggregation parameters of a timeline. Timelines have an
 * aggregation period (`DAILY`, `HOURLY`, etc) which defines how events are aggregated in metrics.
 * The points in a timeline are defined by the starting DateTime of the aggregation period. The
 * duration is implicit in the AggregationPeriod. Hourly aggregation periods, when supported by a
 * metric set, are always specified in UTC to avoid ambiguities around daylight saving time
 * transitions, where an hour is skipped when adopting DST, and repeated when abandoning DST. For
 * example, the timestamp '2021-11-07 01:00:00 America/Los_Angeles' is ambiguous since it can
 * correspond to '2021-11-07 08:00:00 UTC' or '2021-11-07 09:00:00 UTC'. Daily aggregation periods
 * require specifying a timezone which will determine the precise instants of the start and the end
 * of the day. Not all metric sets support all timezones, so make sure to check which timezones are
 * supported by the metric set you want to query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1TimelineSpec extends com.google.api.client.json.GenericJson {

  /**
   * Type of the aggregation period of the datapoints in the timeline. Intervals are identified by
   * the date and time at the start of the interval.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String aggregationPeriod;

  /**
   * Ending datapoint of the timeline (exclusive). See start_time for restrictions. The timezone of
   * the end point must match the timezone of the start point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDateTime endTime;

  /**
   * Starting datapoint of the timeline (inclusive). Must be aligned to the aggregation period as
   * follows: * HOURLY: the 'minutes', 'seconds' and 'nanos' fields must be unset. The time_zone can
   * be left unset (defaults to UTC) or set explicitly to "UTC". Setting any other utc_offset or
   * timezone id will result in a validation error. * DAILY: the 'hours', 'minutes', 'seconds' and
   * 'nanos' fields must be unset. Different metric sets support different timezones. It can be left
   * unset to use the default timezone specified by the metric set. The timezone of the end point
   * must match the timezone of the start point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleTypeDateTime startTime;

  /**
   * Type of the aggregation period of the datapoints in the timeline. Intervals are identified by
   * the date and time at the start of the interval.
   * @return value or {@code null} for none
   */
  public java.lang.String getAggregationPeriod() {
    return aggregationPeriod;
  }

  /**
   * Type of the aggregation period of the datapoints in the timeline. Intervals are identified by
   * the date and time at the start of the interval.
   * @param aggregationPeriod aggregationPeriod or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1TimelineSpec setAggregationPeriod(java.lang.String aggregationPeriod) {
    this.aggregationPeriod = aggregationPeriod;
    return this;
  }

  /**
   * Ending datapoint of the timeline (exclusive). See start_time for restrictions. The timezone of
   * the end point must match the timezone of the start point.
   * @return value or {@code null} for none
   */
  public GoogleTypeDateTime getEndTime() {
    return endTime;
  }

  /**
   * Ending datapoint of the timeline (exclusive). See start_time for restrictions. The timezone of
   * the end point must match the timezone of the start point.
   * @param endTime endTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1TimelineSpec setEndTime(GoogleTypeDateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Starting datapoint of the timeline (inclusive). Must be aligned to the aggregation period as
   * follows: * HOURLY: the 'minutes', 'seconds' and 'nanos' fields must be unset. The time_zone can
   * be left unset (defaults to UTC) or set explicitly to "UTC". Setting any other utc_offset or
   * timezone id will result in a validation error. * DAILY: the 'hours', 'minutes', 'seconds' and
   * 'nanos' fields must be unset. Different metric sets support different timezones. It can be left
   * unset to use the default timezone specified by the metric set. The timezone of the end point
   * must match the timezone of the start point.
   * @return value or {@code null} for none
   */
  public GoogleTypeDateTime getStartTime() {
    return startTime;
  }

  /**
   * Starting datapoint of the timeline (inclusive). Must be aligned to the aggregation period as
   * follows: * HOURLY: the 'minutes', 'seconds' and 'nanos' fields must be unset. The time_zone can
   * be left unset (defaults to UTC) or set explicitly to "UTC". Setting any other utc_offset or
   * timezone id will result in a validation error. * DAILY: the 'hours', 'minutes', 'seconds' and
   * 'nanos' fields must be unset. Different metric sets support different timezones. It can be left
   * unset to use the default timezone specified by the metric set. The timezone of the end point
   * must match the timezone of the start point.
   * @param startTime startTime or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1TimelineSpec setStartTime(GoogleTypeDateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1TimelineSpec set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1TimelineSpec) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1TimelineSpec clone() {
    return (GooglePlayDeveloperReportingV1beta1TimelineSpec) super.clone();
  }

}
