/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playdeveloperreporting.v1beta1.model;

/**
 * A representation of a Play release track.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Developer Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GooglePlayDeveloperReportingV1beta1Track extends com.google.api.client.json.GenericJson {

  /**
   * Readable identifier of the track.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Represents all active releases in the track.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GooglePlayDeveloperReportingV1beta1Release> servingReleases;

  static {
    // hack to force ProGuard to consider GooglePlayDeveloperReportingV1beta1Release used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GooglePlayDeveloperReportingV1beta1Release.class);
  }

  /**
   * The type of the track.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Readable identifier of the track.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Readable identifier of the track.
   * @param displayName displayName or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Track setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Represents all active releases in the track.
   * @return value or {@code null} for none
   */
  public java.util.List<GooglePlayDeveloperReportingV1beta1Release> getServingReleases() {
    return servingReleases;
  }

  /**
   * Represents all active releases in the track.
   * @param servingReleases servingReleases or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Track setServingReleases(java.util.List<GooglePlayDeveloperReportingV1beta1Release> servingReleases) {
    this.servingReleases = servingReleases;
    return this;
  }

  /**
   * The type of the track.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the track.
   * @param type type or {@code null} for none
   */
  public GooglePlayDeveloperReportingV1beta1Track setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1Track set(String fieldName, Object value) {
    return (GooglePlayDeveloperReportingV1beta1Track) super.set(fieldName, value);
  }

  @Override
  public GooglePlayDeveloperReportingV1beta1Track clone() {
    return (GooglePlayDeveloperReportingV1beta1Track) super.clone();
  }

}
