/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1;

/**
 * Service definition for PlayIntegrity (v1).
 *
 * <p>
 * The Play Integrity API helps you check that you're interacting with your genuine app on a genuine Android device powered by Google Play services. The Play Integrity API has replaced SafetyNet Attestation and Android Device Verification.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developer.android.com/google/play/integrity" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PlayIntegrityRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class PlayIntegrity extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Google Play Integrity API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://playintegrity.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://playintegrity.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public PlayIntegrity(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  PlayIntegrity(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the V1 collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code PlayIntegrity playintegrity = new PlayIntegrity(...);}
   *   {@code PlayIntegrity.V1.List request = playintegrity.v1().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public V1 v1() {
    return new V1();
  }

  /**
   * The "v1" collection of methods.
   */
  public class V1 {

    /**
     * Decodes the integrity token and returns the token payload.
     *
     * Create a request for the method "v1.decodeIntegrityToken".
     *
     * This request holds the parameters needed by the playintegrity server.  After setting any optional
     * parameters, call the {@link DecodeIntegrityToken#execute()} method to invoke the remote
     * operation.
     *
     * @param packageName  Package name of the app the attached integrity token belongs to.
     * @param content the {@link com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenRequest}
     * @return the request
     */
    public DecodeIntegrityToken decodeIntegrityToken(java.lang.String packageName, com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenRequest content) throws java.io.IOException {
      DecodeIntegrityToken result = new DecodeIntegrityToken(packageName, content);
      initialize(result);
      return result;
    }

    public class DecodeIntegrityToken extends PlayIntegrityRequest<com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenResponse> {

      private static final String REST_PATH = "v1/{+packageName}:decodeIntegrityToken";

      private final java.util.regex.Pattern PACKAGE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Decodes the integrity token and returns the token payload.
       *
       * Create a request for the method "v1.decodeIntegrityToken".
       *
       * This request holds the parameters needed by the the playintegrity server.  After setting any
       * optional parameters, call the {@link DecodeIntegrityToken#execute()} method to invoke the
       * remote operation. <p> {@link DecodeIntegrityToken#initialize(com.google.api.client.googleapis.s
       * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param packageName  Package name of the app the attached integrity token belongs to.
       * @param content the {@link com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenRequest}
       * @since 1.13
       */
      protected DecodeIntegrityToken(java.lang.String packageName, com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenRequest content) {
        super(PlayIntegrity.this, "POST", REST_PATH, content, com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenResponse.class);
        this.packageName = com.google.api.client.util.Preconditions.checkNotNull(packageName, "Required parameter packageName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PACKAGE_NAME_PATTERN.matcher(packageName).matches(),
              "Parameter packageName must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public DecodeIntegrityToken set$Xgafv(java.lang.String $Xgafv) {
        return (DecodeIntegrityToken) super.set$Xgafv($Xgafv);
      }

      @Override
      public DecodeIntegrityToken setAccessToken(java.lang.String accessToken) {
        return (DecodeIntegrityToken) super.setAccessToken(accessToken);
      }

      @Override
      public DecodeIntegrityToken setAlt(java.lang.String alt) {
        return (DecodeIntegrityToken) super.setAlt(alt);
      }

      @Override
      public DecodeIntegrityToken setCallback(java.lang.String callback) {
        return (DecodeIntegrityToken) super.setCallback(callback);
      }

      @Override
      public DecodeIntegrityToken setFields(java.lang.String fields) {
        return (DecodeIntegrityToken) super.setFields(fields);
      }

      @Override
      public DecodeIntegrityToken setKey(java.lang.String key) {
        return (DecodeIntegrityToken) super.setKey(key);
      }

      @Override
      public DecodeIntegrityToken setOauthToken(java.lang.String oauthToken) {
        return (DecodeIntegrityToken) super.setOauthToken(oauthToken);
      }

      @Override
      public DecodeIntegrityToken setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DecodeIntegrityToken) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DecodeIntegrityToken setQuotaUser(java.lang.String quotaUser) {
        return (DecodeIntegrityToken) super.setQuotaUser(quotaUser);
      }

      @Override
      public DecodeIntegrityToken setUploadType(java.lang.String uploadType) {
        return (DecodeIntegrityToken) super.setUploadType(uploadType);
      }

      @Override
      public DecodeIntegrityToken setUploadProtocol(java.lang.String uploadProtocol) {
        return (DecodeIntegrityToken) super.setUploadProtocol(uploadProtocol);
      }

      /**  Package name of the app the attached integrity token belongs to. */
      @com.google.api.client.util.Key
      private java.lang.String packageName;

      /**  Package name of the app the attached integrity token belongs to.
       */
      public java.lang.String getPackageName() {
        return packageName;
      }

      /**  Package name of the app the attached integrity token belongs to. */
      public DecodeIntegrityToken setPackageName(java.lang.String packageName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PACKAGE_NAME_PATTERN.matcher(packageName).matches(),
              "Parameter packageName must conform to the pattern " +
              "^[^/]+$");
        }
        this.packageName = packageName;
        return this;
      }

      @Override
      public DecodeIntegrityToken set(String parameterName, Object value) {
        return (DecodeIntegrityToken) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link PlayIntegrity}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link PlayIntegrity}. */
    @Override
    public PlayIntegrity build() {
      return new PlayIntegrity(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PlayIntegrityRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPlayIntegrityRequestInitializer(
        PlayIntegrityRequestInitializer playintegrityRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(playintegrityRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
