/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains the account information such as the licensing status for the user in the scope.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountDetails extends com.google.api.client.json.GenericJson {

  /**
   * Details about the account activity for the user in the scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountActivity accountActivity;

  /**
   * Required. Details about the licensing status of the user for the app in the scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appLicensingVerdict;

  /**
   * Details about the account activity for the user in the scope.
   * @return value or {@code null} for none
   */
  public AccountActivity getAccountActivity() {
    return accountActivity;
  }

  /**
   * Details about the account activity for the user in the scope.
   * @param accountActivity accountActivity or {@code null} for none
   */
  public AccountDetails setAccountActivity(AccountActivity accountActivity) {
    this.accountActivity = accountActivity;
    return this;
  }

  /**
   * Required. Details about the licensing status of the user for the app in the scope.
   * @return value or {@code null} for none
   */
  public java.lang.String getAppLicensingVerdict() {
    return appLicensingVerdict;
  }

  /**
   * Required. Details about the licensing status of the user for the app in the scope.
   * @param appLicensingVerdict appLicensingVerdict or {@code null} for none
   */
  public AccountDetails setAppLicensingVerdict(java.lang.String appLicensingVerdict) {
    this.appLicensingVerdict = appLicensingVerdict;
    return this;
  }

  @Override
  public AccountDetails set(String fieldName, Object value) {
    return (AccountDetails) super.set(fieldName, value);
  }

  @Override
  public AccountDetails clone() {
    return (AccountDetails) super.clone();
  }

}
