/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains information about account risk that indicates if the current user session seems low
 * risk, unknown, or risky before you allow important actions to proceed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountRiskVerdict extends com.google.api.client.json.GenericJson {

  /**
   * Required. Indicates the account risk level of the current user session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String risk;

  /**
   * Required. Indicates the account risk level of the current user session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String riskLevel;

  /**
   * Required. Indicates the account risk level of the current user session.
   * @return value or {@code null} for none
   */
  public java.lang.String getRisk() {
    return risk;
  }

  /**
   * Required. Indicates the account risk level of the current user session.
   * @param risk risk or {@code null} for none
   */
  public AccountRiskVerdict setRisk(java.lang.String risk) {
    this.risk = risk;
    return this;
  }

  /**
   * Required. Indicates the account risk level of the current user session.
   * @return value or {@code null} for none
   */
  public java.lang.String getRiskLevel() {
    return riskLevel;
  }

  /**
   * Required. Indicates the account risk level of the current user session.
   * @param riskLevel riskLevel or {@code null} for none
   */
  public AccountRiskVerdict setRiskLevel(java.lang.String riskLevel) {
    this.riskLevel = riskLevel;
    return this;
  }

  @Override
  public AccountRiskVerdict set(String fieldName, Object value) {
    return (AccountRiskVerdict) super.set(fieldName, value);
  }

  @Override
  public AccountRiskVerdict clone() {
    return (AccountRiskVerdict) super.clone();
  }

}
