/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * (Restricted Access) Contains a signal helping apps differentiating between likely genuine and
 * likely non-genuine user traffic.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountActivity extends com.google.api.client.json.GenericJson {

  /**
   * Required. Indicates the activity level of the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activityLevel;

  /**
   * Required. Indicates the activity level of the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getActivityLevel() {
    return activityLevel;
  }

  /**
   * Required. Indicates the activity level of the account.
   * @param activityLevel activityLevel or {@code null} for none
   */
  public AccountActivity setActivityLevel(java.lang.String activityLevel) {
    this.activityLevel = activityLevel;
    return this;
  }

  @Override
  public AccountActivity set(String fieldName, Object value) {
    return (AccountActivity) super.set(fieldName, value);
  }

  @Override
  public AccountActivity clone() {
    return (AccountActivity) super.clone();
  }

}
