/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains the application integrity information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppIntegrity extends com.google.api.client.json.GenericJson {

  /**
   * Required. Details about the app recognition verdict
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String appRecognitionVerdict;

  /**
   * The SHA256 hash of the requesting app's signing certificates (base64 web-safe encoded). Set iff
   * app_recognition_verdict != UNEVALUATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> certificateSha256Digest;

  /**
   * Package name of the application under attestation. Set iff app_recognition_verdict !=
   * UNEVALUATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String packageName;

  /**
   * Version code of the application. Set iff app_recognition_verdict != UNEVALUATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long versionCode;

  /**
   * Required. Details about the app recognition verdict
   * @return value or {@code null} for none
   */
  public java.lang.String getAppRecognitionVerdict() {
    return appRecognitionVerdict;
  }

  /**
   * Required. Details about the app recognition verdict
   * @param appRecognitionVerdict appRecognitionVerdict or {@code null} for none
   */
  public AppIntegrity setAppRecognitionVerdict(java.lang.String appRecognitionVerdict) {
    this.appRecognitionVerdict = appRecognitionVerdict;
    return this;
  }

  /**
   * The SHA256 hash of the requesting app's signing certificates (base64 web-safe encoded). Set iff
   * app_recognition_verdict != UNEVALUATED.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCertificateSha256Digest() {
    return certificateSha256Digest;
  }

  /**
   * The SHA256 hash of the requesting app's signing certificates (base64 web-safe encoded). Set iff
   * app_recognition_verdict != UNEVALUATED.
   * @param certificateSha256Digest certificateSha256Digest or {@code null} for none
   */
  public AppIntegrity setCertificateSha256Digest(java.util.List<java.lang.String> certificateSha256Digest) {
    this.certificateSha256Digest = certificateSha256Digest;
    return this;
  }

  /**
   * Package name of the application under attestation. Set iff app_recognition_verdict !=
   * UNEVALUATED.
   * @return value or {@code null} for none
   */
  public java.lang.String getPackageName() {
    return packageName;
  }

  /**
   * Package name of the application under attestation. Set iff app_recognition_verdict !=
   * UNEVALUATED.
   * @param packageName packageName or {@code null} for none
   */
  public AppIntegrity setPackageName(java.lang.String packageName) {
    this.packageName = packageName;
    return this;
  }

  /**
   * Version code of the application. Set iff app_recognition_verdict != UNEVALUATED.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersionCode() {
    return versionCode;
  }

  /**
   * Version code of the application. Set iff app_recognition_verdict != UNEVALUATED.
   * @param versionCode versionCode or {@code null} for none
   */
  public AppIntegrity setVersionCode(java.lang.Long versionCode) {
    this.versionCode = versionCode;
    return this;
  }

  @Override
  public AppIntegrity set(String fieldName, Object value) {
    return (AppIntegrity) super.set(fieldName, value);
  }

  @Override
  public AppIntegrity clone() {
    return (AppIntegrity) super.clone();
  }

}
