/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains information about the environment Play Integrity API runs in, e.g. Play Protect verdict.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EnvironmentDetails extends com.google.api.client.json.GenericJson {

  /**
   * The evaluation of the App Access Risk verdicts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppAccessRiskVerdict appAccessRiskVerdict;

  /**
   * The evaluation of Play Protect verdict.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playProtectVerdict;

  /**
   * The evaluation of the App Access Risk verdicts.
   * @return value or {@code null} for none
   */
  public AppAccessRiskVerdict getAppAccessRiskVerdict() {
    return appAccessRiskVerdict;
  }

  /**
   * The evaluation of the App Access Risk verdicts.
   * @param appAccessRiskVerdict appAccessRiskVerdict or {@code null} for none
   */
  public EnvironmentDetails setAppAccessRiskVerdict(AppAccessRiskVerdict appAccessRiskVerdict) {
    this.appAccessRiskVerdict = appAccessRiskVerdict;
    return this;
  }

  /**
   * The evaluation of Play Protect verdict.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlayProtectVerdict() {
    return playProtectVerdict;
  }

  /**
   * The evaluation of Play Protect verdict.
   * @param playProtectVerdict playProtectVerdict or {@code null} for none
   */
  public EnvironmentDetails setPlayProtectVerdict(java.lang.String playProtectVerdict) {
    this.playProtectVerdict = playProtectVerdict;
    return this;
  }

  @Override
  public EnvironmentDetails set(String fieldName, Object value) {
    return (EnvironmentDetails) super.set(fieldName, value);
  }

  @Override
  public EnvironmentDetails clone() {
    return (EnvironmentDetails) super.clone();
  }

}
