/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains the integrity request information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RequestDetails extends com.google.api.client.json.GenericJson {

  /**
   * Nonce that was provided in the request (which is base64 web-safe no-wrap).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nonce;

  /**
   * Request hash that was provided in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestHash;

  /**
   * Required. Application package name this attestation was requested for. Note: This field makes
   * no guarantees or promises on the caller integrity. For details on application integrity, check
   * application_integrity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestPackageName;

  /**
   * Required. Timestamp, in milliseconds, of the integrity application request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long timestampMillis;

  /**
   * Nonce that was provided in the request (which is base64 web-safe no-wrap).
   * @return value or {@code null} for none
   */
  public java.lang.String getNonce() {
    return nonce;
  }

  /**
   * Nonce that was provided in the request (which is base64 web-safe no-wrap).
   * @param nonce nonce or {@code null} for none
   */
  public RequestDetails setNonce(java.lang.String nonce) {
    this.nonce = nonce;
    return this;
  }

  /**
   * Request hash that was provided in the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestHash() {
    return requestHash;
  }

  /**
   * Request hash that was provided in the request.
   * @param requestHash requestHash or {@code null} for none
   */
  public RequestDetails setRequestHash(java.lang.String requestHash) {
    this.requestHash = requestHash;
    return this;
  }

  /**
   * Required. Application package name this attestation was requested for. Note: This field makes
   * no guarantees or promises on the caller integrity. For details on application integrity, check
   * application_integrity.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestPackageName() {
    return requestPackageName;
  }

  /**
   * Required. Application package name this attestation was requested for. Note: This field makes
   * no guarantees or promises on the caller integrity. For details on application integrity, check
   * application_integrity.
   * @param requestPackageName requestPackageName or {@code null} for none
   */
  public RequestDetails setRequestPackageName(java.lang.String requestPackageName) {
    this.requestPackageName = requestPackageName;
    return this;
  }

  /**
   * Required. Timestamp, in milliseconds, of the integrity application request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimestampMillis() {
    return timestampMillis;
  }

  /**
   * Required. Timestamp, in milliseconds, of the integrity application request.
   * @param timestampMillis timestampMillis or {@code null} for none
   */
  public RequestDetails setTimestampMillis(java.lang.Long timestampMillis) {
    this.timestampMillis = timestampMillis;
    return this;
  }

  @Override
  public RequestDetails set(String fieldName, Object value) {
    return (RequestDetails) super.set(fieldName, value);
  }

  @Override
  public RequestDetails clone() {
    return (RequestDetails) super.clone();
  }

}
