/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.playintegrity.v1.model;

/**
 * Contains basic app information and integrity signals like device attestation and licensing
 * details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Play Integrity API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TokenPayloadExternal extends com.google.api.client.json.GenericJson {

  /**
   * Required. Details about the Play Store account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountDetails accountDetails;

  /**
   * Required. Details about the application integrity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppIntegrity appIntegrity;

  /**
   * Required. Details about the device integrity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeviceIntegrity deviceIntegrity;

  /**
   * Details of the environment Play Integrity API runs in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EnvironmentDetails environmentDetails;

  /**
   * Required. Details about the integrity request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RequestDetails requestDetails;

  /**
   * Indicates that this payload is generated for testing purposes and contains any additional data
   * that is linked with testing status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TestingDetails testingDetails;

  /**
   * Required. Details about the Play Store account.
   * @return value or {@code null} for none
   */
  public AccountDetails getAccountDetails() {
    return accountDetails;
  }

  /**
   * Required. Details about the Play Store account.
   * @param accountDetails accountDetails or {@code null} for none
   */
  public TokenPayloadExternal setAccountDetails(AccountDetails accountDetails) {
    this.accountDetails = accountDetails;
    return this;
  }

  /**
   * Required. Details about the application integrity.
   * @return value or {@code null} for none
   */
  public AppIntegrity getAppIntegrity() {
    return appIntegrity;
  }

  /**
   * Required. Details about the application integrity.
   * @param appIntegrity appIntegrity or {@code null} for none
   */
  public TokenPayloadExternal setAppIntegrity(AppIntegrity appIntegrity) {
    this.appIntegrity = appIntegrity;
    return this;
  }

  /**
   * Required. Details about the device integrity.
   * @return value or {@code null} for none
   */
  public DeviceIntegrity getDeviceIntegrity() {
    return deviceIntegrity;
  }

  /**
   * Required. Details about the device integrity.
   * @param deviceIntegrity deviceIntegrity or {@code null} for none
   */
  public TokenPayloadExternal setDeviceIntegrity(DeviceIntegrity deviceIntegrity) {
    this.deviceIntegrity = deviceIntegrity;
    return this;
  }

  /**
   * Details of the environment Play Integrity API runs in.
   * @return value or {@code null} for none
   */
  public EnvironmentDetails getEnvironmentDetails() {
    return environmentDetails;
  }

  /**
   * Details of the environment Play Integrity API runs in.
   * @param environmentDetails environmentDetails or {@code null} for none
   */
  public TokenPayloadExternal setEnvironmentDetails(EnvironmentDetails environmentDetails) {
    this.environmentDetails = environmentDetails;
    return this;
  }

  /**
   * Required. Details about the integrity request.
   * @return value or {@code null} for none
   */
  public RequestDetails getRequestDetails() {
    return requestDetails;
  }

  /**
   * Required. Details about the integrity request.
   * @param requestDetails requestDetails or {@code null} for none
   */
  public TokenPayloadExternal setRequestDetails(RequestDetails requestDetails) {
    this.requestDetails = requestDetails;
    return this;
  }

  /**
   * Indicates that this payload is generated for testing purposes and contains any additional data
   * that is linked with testing status.
   * @return value or {@code null} for none
   */
  public TestingDetails getTestingDetails() {
    return testingDetails;
  }

  /**
   * Indicates that this payload is generated for testing purposes and contains any additional data
   * that is linked with testing status.
   * @param testingDetails testingDetails or {@code null} for none
   */
  public TokenPayloadExternal setTestingDetails(TestingDetails testingDetails) {
    this.testingDetails = testingDetails;
    return this;
  }

  @Override
  public TokenPayloadExternal set(String fieldName, Object value) {
    return (TokenPayloadExternal) super.set(fieldName, value);
  }

  @Override
  public TokenPayloadExternal clone() {
    return (TokenPayloadExternal) super.clone();
  }

}
