/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.playintegrity.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.playintegrity.v1.PlayIntegrityRequest;
import com.google.api.services.playintegrity.v1.PlayIntegrityRequestInitializer;
import com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenRequest;
import com.google.api.services.playintegrity.v1.model.DecodeIntegrityTokenResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class PlayIntegrity
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://playintegrity.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://playintegrity.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://playintegrity.googleapis.com/";

    public PlayIntegrity(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    PlayIntegrity(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public V1 v1() {
        return new V1();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Play Integrity API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return PlayIntegrity.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://playintegrity.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), PlayIntegrity.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(PlayIntegrity.DEFAULT_BATCH_PATH);
        }

        public PlayIntegrity build() {
            return new PlayIntegrity(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPlayIntegrityRequestInitializer(PlayIntegrityRequestInitializer playintegrityRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)playintegrityRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class V1 {
        public DecodeIntegrityToken decodeIntegrityToken(String packageName, DecodeIntegrityTokenRequest content) throws IOException {
            DecodeIntegrityToken result = new DecodeIntegrityToken(packageName, content);
            PlayIntegrity.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class DecodeIntegrityToken
        extends PlayIntegrityRequest<DecodeIntegrityTokenResponse> {
            private static final String REST_PATH = "v1/{+packageName}:decodeIntegrityToken";
            private final Pattern PACKAGE_NAME_PATTERN;
            @Key
            private String packageName;

            protected DecodeIntegrityToken(String packageName, DecodeIntegrityTokenRequest content) {
                super(PlayIntegrity.this, "POST", REST_PATH, (Object)content, DecodeIntegrityTokenResponse.class);
                this.PACKAGE_NAME_PATTERN = Pattern.compile("^[^/]+$");
                this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Required parameter packageName must be specified.");
                if (!PlayIntegrity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PACKAGE_NAME_PATTERN.matcher(packageName).matches(), (Object)"Parameter packageName must conform to the pattern ^[^/]+$");
                }
            }

            public DecodeIntegrityToken set$Xgafv(String $Xgafv) {
                return (DecodeIntegrityToken)super.set$Xgafv($Xgafv);
            }

            public DecodeIntegrityToken setAccessToken(String accessToken) {
                return (DecodeIntegrityToken)super.setAccessToken(accessToken);
            }

            public DecodeIntegrityToken setAlt(String alt) {
                return (DecodeIntegrityToken)super.setAlt(alt);
            }

            public DecodeIntegrityToken setCallback(String callback) {
                return (DecodeIntegrityToken)super.setCallback(callback);
            }

            public DecodeIntegrityToken setFields(String fields) {
                return (DecodeIntegrityToken)super.setFields(fields);
            }

            public DecodeIntegrityToken setKey(String key) {
                return (DecodeIntegrityToken)super.setKey(key);
            }

            public DecodeIntegrityToken setOauthToken(String oauthToken) {
                return (DecodeIntegrityToken)super.setOauthToken(oauthToken);
            }

            public DecodeIntegrityToken setPrettyPrint(Boolean prettyPrint) {
                return (DecodeIntegrityToken)super.setPrettyPrint(prettyPrint);
            }

            public DecodeIntegrityToken setQuotaUser(String quotaUser) {
                return (DecodeIntegrityToken)super.setQuotaUser(quotaUser);
            }

            public DecodeIntegrityToken setUploadType(String uploadType) {
                return (DecodeIntegrityToken)super.setUploadType(uploadType);
            }

            public DecodeIntegrityToken setUploadProtocol(String uploadProtocol) {
                return (DecodeIntegrityToken)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public DecodeIntegrityToken setPackageName(String packageName) {
                if (!PlayIntegrity.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PACKAGE_NAME_PATTERN.matcher(packageName).matches(), (Object)"Parameter packageName must conform to the pattern ^[^/]+$");
                }
                this.packageName = packageName;
                return this;
            }

            @Override
            public DecodeIntegrityToken set(String parameterName, Object value) {
                return (DecodeIntegrityToken)super.set(parameterName, value);
            }
        }
    }
}

