/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.policytroubleshooter.v1.model;

/**
 * Response for TroubleshootIamPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Policy Troubleshooter API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether the principal has the specified permission for the specified resource, based
   * on evaluating all of the applicable IAM policies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String access;

  /**
   * List of IAM policies that were evaluated to check the principal's permissions, with annotations
   * to indicate how each policy contributed to the final result. The list of policies can include
   * the policy for the resource itself. It can also include policies that are inherited from higher
   * levels of the resource hierarchy, including the organization, the folder, and the project. To
   * learn more about the resource hierarchy, see https://cloud.google.com/iam/help/resource-
   * hierarchy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleCloudPolicytroubleshooterV1ExplainedPolicy> explainedPolicies;

  static {
    // hack to force ProGuard to consider GoogleCloudPolicytroubleshooterV1ExplainedPolicy used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleCloudPolicytroubleshooterV1ExplainedPolicy.class);
  }

  /**
   * Indicates whether the principal has the specified permission for the specified resource, based
   * on evaluating all of the applicable IAM policies.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccess() {
    return access;
  }

  /**
   * Indicates whether the principal has the specified permission for the specified resource, based
   * on evaluating all of the applicable IAM policies.
   * @param access access or {@code null} for none
   */
  public GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse setAccess(java.lang.String access) {
    this.access = access;
    return this;
  }

  /**
   * List of IAM policies that were evaluated to check the principal's permissions, with annotations
   * to indicate how each policy contributed to the final result. The list of policies can include
   * the policy for the resource itself. It can also include policies that are inherited from higher
   * levels of the resource hierarchy, including the organization, the folder, and the project. To
   * learn more about the resource hierarchy, see https://cloud.google.com/iam/help/resource-
   * hierarchy.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleCloudPolicytroubleshooterV1ExplainedPolicy> getExplainedPolicies() {
    return explainedPolicies;
  }

  /**
   * List of IAM policies that were evaluated to check the principal's permissions, with annotations
   * to indicate how each policy contributed to the final result. The list of policies can include
   * the policy for the resource itself. It can also include policies that are inherited from higher
   * levels of the resource hierarchy, including the organization, the folder, and the project. To
   * learn more about the resource hierarchy, see https://cloud.google.com/iam/help/resource-
   * hierarchy.
   * @param explainedPolicies explainedPolicies or {@code null} for none
   */
  public GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse setExplainedPolicies(java.util.List<GoogleCloudPolicytroubleshooterV1ExplainedPolicy> explainedPolicies) {
    this.explainedPolicies = explainedPolicies;
    return this;
  }

  @Override
  public GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse set(String fieldName, Object value) {
    return (GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse clone() {
    return (GoogleCloudPolicytroubleshooterV1TroubleshootIamPolicyResponse) super.clone();
  }

}
