/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.policytroubleshooter.v1.model;

/**
 * Information about the principal, resource, and permission to check.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Policy Troubleshooter API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudPolicytroubleshooterV1AccessTuple extends com.google.api.client.json.GenericJson {

  /**
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`. For
   * examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullResourceName;

  /**
   * Required. The IAM permission to check for the specified principal and resource. For a complete
   * list of IAM permissions, see https://cloud.google.com/iam/help/permissions/reference. For a
   * complete list of predefined IAM roles and the permissions in each role, see
   * https://cloud.google.com/iam/help/roles/reference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permission;

  /**
   * Required. The principal whose access you want to check, in the form of the email address that
   * represents that principal. For example, `alice@example.com` or `my-service-account@my-
   * project.iam.gserviceaccount.com`. The principal must be a Google Account or a service account.
   * Other types of principals are not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String principal;

  /**
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`. For
   * examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullResourceName() {
    return fullResourceName;
  }

  /**
   * Required. The full resource name that identifies the resource. For example,
   * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`. For
   * examples of full resource names for Google Cloud services, see
   * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
   * @param fullResourceName fullResourceName or {@code null} for none
   */
  public GoogleCloudPolicytroubleshooterV1AccessTuple setFullResourceName(java.lang.String fullResourceName) {
    this.fullResourceName = fullResourceName;
    return this;
  }

  /**
   * Required. The IAM permission to check for the specified principal and resource. For a complete
   * list of IAM permissions, see https://cloud.google.com/iam/help/permissions/reference. For a
   * complete list of predefined IAM roles and the permissions in each role, see
   * https://cloud.google.com/iam/help/roles/reference.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermission() {
    return permission;
  }

  /**
   * Required. The IAM permission to check for the specified principal and resource. For a complete
   * list of IAM permissions, see https://cloud.google.com/iam/help/permissions/reference. For a
   * complete list of predefined IAM roles and the permissions in each role, see
   * https://cloud.google.com/iam/help/roles/reference.
   * @param permission permission or {@code null} for none
   */
  public GoogleCloudPolicytroubleshooterV1AccessTuple setPermission(java.lang.String permission) {
    this.permission = permission;
    return this;
  }

  /**
   * Required. The principal whose access you want to check, in the form of the email address that
   * represents that principal. For example, `alice@example.com` or `my-service-account@my-
   * project.iam.gserviceaccount.com`. The principal must be a Google Account or a service account.
   * Other types of principals are not supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrincipal() {
    return principal;
  }

  /**
   * Required. The principal whose access you want to check, in the form of the email address that
   * represents that principal. For example, `alice@example.com` or `my-service-account@my-
   * project.iam.gserviceaccount.com`. The principal must be a Google Account or a service account.
   * Other types of principals are not supported.
   * @param principal principal or {@code null} for none
   */
  public GoogleCloudPolicytroubleshooterV1AccessTuple setPrincipal(java.lang.String principal) {
    this.principal = principal;
    return this;
  }

  @Override
  public GoogleCloudPolicytroubleshooterV1AccessTuple set(String fieldName, Object value) {
    return (GoogleCloudPolicytroubleshooterV1AccessTuple) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudPolicytroubleshooterV1AccessTuple clone() {
    return (GoogleCloudPolicytroubleshooterV1AccessTuple) super.clone();
  }

}
