/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.pubsub;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.pubsub.PubsubRequest;
import com.google.api.services.pubsub.PubsubRequestInitializer;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.CreateSnapshotRequest;
import com.google.api.services.pubsub.model.DetachSubscriptionResponse;
import com.google.api.services.pubsub.model.Empty;
import com.google.api.services.pubsub.model.ListSchemasResponse;
import com.google.api.services.pubsub.model.ListSnapshotsResponse;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicSnapshotsResponse;
import com.google.api.services.pubsub.model.ListTopicSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.ModifyPushConfigRequest;
import com.google.api.services.pubsub.model.Policy;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.Schema;
import com.google.api.services.pubsub.model.SeekRequest;
import com.google.api.services.pubsub.model.SeekResponse;
import com.google.api.services.pubsub.model.SetIamPolicyRequest;
import com.google.api.services.pubsub.model.Snapshot;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.TestIamPermissionsRequest;
import com.google.api.services.pubsub.model.TestIamPermissionsResponse;
import com.google.api.services.pubsub.model.Topic;
import com.google.api.services.pubsub.model.UpdateSnapshotRequest;
import com.google.api.services.pubsub.model.UpdateSubscriptionRequest;
import com.google.api.services.pubsub.model.UpdateTopicRequest;
import com.google.api.services.pubsub.model.ValidateMessageRequest;
import com.google.api.services.pubsub.model.ValidateMessageResponse;
import com.google.api.services.pubsub.model.ValidateSchemaRequest;
import com.google.api.services.pubsub.model.ValidateSchemaResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class Pubsub
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://pubsub.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://pubsub.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://pubsub.googleapis.com/";

    public Pubsub(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Pubsub(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Cloud Pub/Sub API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Pubsub.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://pubsub.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Pubsub.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Pubsub.DEFAULT_BATCH_PATH);
        }

        public Pubsub build() {
            return new Pubsub(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPubsubRequestInitializer(PubsubRequestInitializer pubsubRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)pubsubRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Schemas schemas() {
            return new Schemas();
        }

        public Snapshots snapshots() {
            return new Snapshots();
        }

        public Subscriptions subscriptions() {
            return new Subscriptions();
        }

        public Topics topics() {
            return new Topics();
        }

        public class Topics {
            public Create create(String name, Topic content) throws IOException {
                Create result = new Create(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String topic) throws IOException {
                Delete result = new Delete(topic);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String topic) throws IOException {
                Get result = new Get(topic);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String project) throws IOException {
                List result = new List(project);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UpdateTopicRequest content) throws IOException {
                Patch result = new Patch(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Publish publish(String topic, PublishRequest content) throws IOException {
                Publish result = new Publish(topic, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Snapshots snapshots() {
                return new Snapshots();
            }

            public Subscriptions subscriptions() {
                return new Subscriptions();
            }

            public class Subscriptions {
                public List list(String topic) throws IOException {
                    List result = new List(topic);
                    Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends PubsubRequest<ListTopicSubscriptionsResponse> {
                    private static final String REST_PATH = "v1/{+topic}/subscriptions";
                    private final Pattern TOPIC_PATTERN;
                    @Key
                    private String topic;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String topic) {
                        super(Pubsub.this, "GET", REST_PATH, null, ListTopicSubscriptionsResponse.class);
                        this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getTopic() {
                        return this.topic;
                    }

                    public List setTopic(String topic) {
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                        this.topic = topic;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Snapshots {
                public List list(String topic) throws IOException {
                    List result = new List(topic);
                    Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends PubsubRequest<ListTopicSnapshotsResponse> {
                    private static final String REST_PATH = "v1/{+topic}/snapshots";
                    private final Pattern TOPIC_PATTERN;
                    @Key
                    private String topic;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String topic) {
                        super(Pubsub.this, "GET", REST_PATH, null, ListTopicSnapshotsResponse.class);
                        this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getTopic() {
                        return this.topic;
                    }

                    public List setTopic(String topic) {
                        if (!Pubsub.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                        }
                        this.topic = topic;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Publish
            extends PubsubRequest<PublishResponse> {
                private static final String REST_PATH = "v1/{+topic}:publish";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Publish(String topic, PublishRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, PublishResponse.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Publish set$Xgafv(String $Xgafv) {
                    return (Publish)super.set$Xgafv($Xgafv);
                }

                public Publish setAccessToken(String accessToken) {
                    return (Publish)super.setAccessToken(accessToken);
                }

                public Publish setAlt(String alt) {
                    return (Publish)super.setAlt(alt);
                }

                public Publish setCallback(String callback) {
                    return (Publish)super.setCallback(callback);
                }

                public Publish setFields(String fields) {
                    return (Publish)super.setFields(fields);
                }

                public Publish setKey(String key) {
                    return (Publish)super.setKey(key);
                }

                public Publish setOauthToken(String oauthToken) {
                    return (Publish)super.setOauthToken(oauthToken);
                }

                public Publish setPrettyPrint(Boolean prettyPrint) {
                    return (Publish)super.setPrettyPrint(prettyPrint);
                }

                public Publish setQuotaUser(String quotaUser) {
                    return (Publish)super.setQuotaUser(quotaUser);
                }

                public Publish setUploadType(String uploadType) {
                    return (Publish)super.setUploadType(uploadType);
                }

                public Publish setUploadProtocol(String uploadProtocol) {
                    return (Publish)super.setUploadProtocol(uploadProtocol);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Publish setTopic(String topic) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = topic;
                    return this;
                }

                @Override
                public Publish set(String parameterName, Object value) {
                    return (Publish)super.set(parameterName, value);
                }
            }

            public class Patch
            extends PubsubRequest<Topic> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, UpdateTopicRequest content) {
                    super(Pubsub.this, "PATCH", REST_PATH, (Object)content, Topic.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends PubsubRequest<ListTopicsResponse> {
                private static final String REST_PATH = "v1/{+project}/topics";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String project) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListTopicsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String project) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = project;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends PubsubRequest<Topic> {
                private static final String REST_PATH = "v1/{+topic}";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Get(String topic) {
                    super(Pubsub.this, "GET", REST_PATH, null, Topic.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Get setTopic(String topic) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = topic;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+topic}";
                private final Pattern TOPIC_PATTERN;
                @Key
                private String topic;

                protected Delete(String topic) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.TOPIC_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getTopic() {
                    return this.topic;
                }

                public Delete setTopic(String topic) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.topic = topic;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends PubsubRequest<Topic> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, Topic content) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)content, Topic.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/topics/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/topics/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Subscriptions {
            public Acknowledge acknowledge(String subscription, AcknowledgeRequest content) throws IOException {
                Acknowledge result = new Acknowledge(subscription, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String name, Subscription content) throws IOException {
                Create result = new Create(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String subscription) throws IOException {
                Delete result = new Delete(subscription);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Detach detach(String subscription) throws IOException {
                Detach result = new Detach(subscription);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String subscription) throws IOException {
                Get result = new Get(subscription);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String project) throws IOException {
                List result = new List(project);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ModifyAckDeadline modifyAckDeadline(String subscription, ModifyAckDeadlineRequest content) throws IOException {
                ModifyAckDeadline result = new ModifyAckDeadline(subscription, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ModifyPushConfig modifyPushConfig(String subscription, ModifyPushConfigRequest content) throws IOException {
                ModifyPushConfig result = new ModifyPushConfig(subscription, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UpdateSubscriptionRequest content) throws IOException {
                Patch result = new Patch(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Pull pull(String subscription, PullRequest content) throws IOException {
                Pull result = new Pull(subscription, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Seek seek(String subscription, SeekRequest content) throws IOException {
                Seek result = new Seek(subscription, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Seek
            extends PubsubRequest<SeekResponse> {
                private static final String REST_PATH = "v1/{+subscription}:seek";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Seek(String subscription, SeekRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, SeekResponse.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Seek set$Xgafv(String $Xgafv) {
                    return (Seek)super.set$Xgafv($Xgafv);
                }

                public Seek setAccessToken(String accessToken) {
                    return (Seek)super.setAccessToken(accessToken);
                }

                public Seek setAlt(String alt) {
                    return (Seek)super.setAlt(alt);
                }

                public Seek setCallback(String callback) {
                    return (Seek)super.setCallback(callback);
                }

                public Seek setFields(String fields) {
                    return (Seek)super.setFields(fields);
                }

                public Seek setKey(String key) {
                    return (Seek)super.setKey(key);
                }

                public Seek setOauthToken(String oauthToken) {
                    return (Seek)super.setOauthToken(oauthToken);
                }

                public Seek setPrettyPrint(Boolean prettyPrint) {
                    return (Seek)super.setPrettyPrint(prettyPrint);
                }

                public Seek setQuotaUser(String quotaUser) {
                    return (Seek)super.setQuotaUser(quotaUser);
                }

                public Seek setUploadType(String uploadType) {
                    return (Seek)super.setUploadType(uploadType);
                }

                public Seek setUploadProtocol(String uploadProtocol) {
                    return (Seek)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Seek setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Seek set(String parameterName, Object value) {
                    return (Seek)super.set(parameterName, value);
                }
            }

            public class Pull
            extends PubsubRequest<PullResponse> {
                private static final String REST_PATH = "v1/{+subscription}:pull";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Pull(String subscription, PullRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, PullResponse.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Pull set$Xgafv(String $Xgafv) {
                    return (Pull)super.set$Xgafv($Xgafv);
                }

                public Pull setAccessToken(String accessToken) {
                    return (Pull)super.setAccessToken(accessToken);
                }

                public Pull setAlt(String alt) {
                    return (Pull)super.setAlt(alt);
                }

                public Pull setCallback(String callback) {
                    return (Pull)super.setCallback(callback);
                }

                public Pull setFields(String fields) {
                    return (Pull)super.setFields(fields);
                }

                public Pull setKey(String key) {
                    return (Pull)super.setKey(key);
                }

                public Pull setOauthToken(String oauthToken) {
                    return (Pull)super.setOauthToken(oauthToken);
                }

                public Pull setPrettyPrint(Boolean prettyPrint) {
                    return (Pull)super.setPrettyPrint(prettyPrint);
                }

                public Pull setQuotaUser(String quotaUser) {
                    return (Pull)super.setQuotaUser(quotaUser);
                }

                public Pull setUploadType(String uploadType) {
                    return (Pull)super.setUploadType(uploadType);
                }

                public Pull setUploadProtocol(String uploadProtocol) {
                    return (Pull)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Pull setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Pull set(String parameterName, Object value) {
                    return (Pull)super.set(parameterName, value);
                }
            }

            public class Patch
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, UpdateSubscriptionRequest content) {
                    super(Pubsub.this, "PATCH", REST_PATH, (Object)content, Subscription.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class ModifyPushConfig
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:modifyPushConfig";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected ModifyPushConfig(String subscription, ModifyPushConfigRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public ModifyPushConfig set$Xgafv(String $Xgafv) {
                    return (ModifyPushConfig)super.set$Xgafv($Xgafv);
                }

                public ModifyPushConfig setAccessToken(String accessToken) {
                    return (ModifyPushConfig)super.setAccessToken(accessToken);
                }

                public ModifyPushConfig setAlt(String alt) {
                    return (ModifyPushConfig)super.setAlt(alt);
                }

                public ModifyPushConfig setCallback(String callback) {
                    return (ModifyPushConfig)super.setCallback(callback);
                }

                public ModifyPushConfig setFields(String fields) {
                    return (ModifyPushConfig)super.setFields(fields);
                }

                public ModifyPushConfig setKey(String key) {
                    return (ModifyPushConfig)super.setKey(key);
                }

                public ModifyPushConfig setOauthToken(String oauthToken) {
                    return (ModifyPushConfig)super.setOauthToken(oauthToken);
                }

                public ModifyPushConfig setPrettyPrint(Boolean prettyPrint) {
                    return (ModifyPushConfig)super.setPrettyPrint(prettyPrint);
                }

                public ModifyPushConfig setQuotaUser(String quotaUser) {
                    return (ModifyPushConfig)super.setQuotaUser(quotaUser);
                }

                public ModifyPushConfig setUploadType(String uploadType) {
                    return (ModifyPushConfig)super.setUploadType(uploadType);
                }

                public ModifyPushConfig setUploadProtocol(String uploadProtocol) {
                    return (ModifyPushConfig)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public ModifyPushConfig setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public ModifyPushConfig set(String parameterName, Object value) {
                    return (ModifyPushConfig)super.set(parameterName, value);
                }
            }

            public class ModifyAckDeadline
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:modifyAckDeadline";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected ModifyAckDeadline(String subscription, ModifyAckDeadlineRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public ModifyAckDeadline set$Xgafv(String $Xgafv) {
                    return (ModifyAckDeadline)super.set$Xgafv($Xgafv);
                }

                public ModifyAckDeadline setAccessToken(String accessToken) {
                    return (ModifyAckDeadline)super.setAccessToken(accessToken);
                }

                public ModifyAckDeadline setAlt(String alt) {
                    return (ModifyAckDeadline)super.setAlt(alt);
                }

                public ModifyAckDeadline setCallback(String callback) {
                    return (ModifyAckDeadline)super.setCallback(callback);
                }

                public ModifyAckDeadline setFields(String fields) {
                    return (ModifyAckDeadline)super.setFields(fields);
                }

                public ModifyAckDeadline setKey(String key) {
                    return (ModifyAckDeadline)super.setKey(key);
                }

                public ModifyAckDeadline setOauthToken(String oauthToken) {
                    return (ModifyAckDeadline)super.setOauthToken(oauthToken);
                }

                public ModifyAckDeadline setPrettyPrint(Boolean prettyPrint) {
                    return (ModifyAckDeadline)super.setPrettyPrint(prettyPrint);
                }

                public ModifyAckDeadline setQuotaUser(String quotaUser) {
                    return (ModifyAckDeadline)super.setQuotaUser(quotaUser);
                }

                public ModifyAckDeadline setUploadType(String uploadType) {
                    return (ModifyAckDeadline)super.setUploadType(uploadType);
                }

                public ModifyAckDeadline setUploadProtocol(String uploadProtocol) {
                    return (ModifyAckDeadline)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public ModifyAckDeadline setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public ModifyAckDeadline set(String parameterName, Object value) {
                    return (ModifyAckDeadline)super.set(parameterName, value);
                }
            }

            public class List
            extends PubsubRequest<ListSubscriptionsResponse> {
                private static final String REST_PATH = "v1/{+project}/subscriptions";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String project) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListSubscriptionsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String project) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = project;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+subscription}";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Get(String subscription) {
                    super(Pubsub.this, "GET", REST_PATH, null, Subscription.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Get setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Detach
            extends PubsubRequest<DetachSubscriptionResponse> {
                private static final String REST_PATH = "v1/{+subscription}:detach";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Detach(String subscription) {
                    super(Pubsub.this, "POST", REST_PATH, null, DetachSubscriptionResponse.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Detach set$Xgafv(String $Xgafv) {
                    return (Detach)super.set$Xgafv($Xgafv);
                }

                public Detach setAccessToken(String accessToken) {
                    return (Detach)super.setAccessToken(accessToken);
                }

                public Detach setAlt(String alt) {
                    return (Detach)super.setAlt(alt);
                }

                public Detach setCallback(String callback) {
                    return (Detach)super.setCallback(callback);
                }

                public Detach setFields(String fields) {
                    return (Detach)super.setFields(fields);
                }

                public Detach setKey(String key) {
                    return (Detach)super.setKey(key);
                }

                public Detach setOauthToken(String oauthToken) {
                    return (Detach)super.setOauthToken(oauthToken);
                }

                public Detach setPrettyPrint(Boolean prettyPrint) {
                    return (Detach)super.setPrettyPrint(prettyPrint);
                }

                public Detach setQuotaUser(String quotaUser) {
                    return (Detach)super.setQuotaUser(quotaUser);
                }

                public Detach setUploadType(String uploadType) {
                    return (Detach)super.setUploadType(uploadType);
                }

                public Detach setUploadProtocol(String uploadProtocol) {
                    return (Detach)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Detach setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Detach set(String parameterName, Object value) {
                    return (Detach)super.set(parameterName, value);
                }
            }

            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Delete(String subscription) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Delete setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends PubsubRequest<Subscription> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, Subscription content) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)content, Subscription.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class Acknowledge
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+subscription}:acknowledge";
                private final Pattern SUBSCRIPTION_PATTERN;
                @Key
                private String subscription;

                protected Acknowledge(String subscription, AcknowledgeRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.SUBSCRIPTION_PATTERN = Pattern.compile("^projects/[^/]+/subscriptions/[^/]+$");
                    this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                }

                public Acknowledge set$Xgafv(String $Xgafv) {
                    return (Acknowledge)super.set$Xgafv($Xgafv);
                }

                public Acknowledge setAccessToken(String accessToken) {
                    return (Acknowledge)super.setAccessToken(accessToken);
                }

                public Acknowledge setAlt(String alt) {
                    return (Acknowledge)super.setAlt(alt);
                }

                public Acknowledge setCallback(String callback) {
                    return (Acknowledge)super.setCallback(callback);
                }

                public Acknowledge setFields(String fields) {
                    return (Acknowledge)super.setFields(fields);
                }

                public Acknowledge setKey(String key) {
                    return (Acknowledge)super.setKey(key);
                }

                public Acknowledge setOauthToken(String oauthToken) {
                    return (Acknowledge)super.setOauthToken(oauthToken);
                }

                public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                    return (Acknowledge)super.setPrettyPrint(prettyPrint);
                }

                public Acknowledge setQuotaUser(String quotaUser) {
                    return (Acknowledge)super.setQuotaUser(quotaUser);
                }

                public Acknowledge setUploadType(String uploadType) {
                    return (Acknowledge)super.setUploadType(uploadType);
                }

                public Acknowledge setUploadProtocol(String uploadProtocol) {
                    return (Acknowledge)super.setUploadProtocol(uploadProtocol);
                }

                public String getSubscription() {
                    return this.subscription;
                }

                public Acknowledge setSubscription(String subscription) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^projects/[^/]+/subscriptions/[^/]+$");
                    }
                    this.subscription = subscription;
                    return this;
                }

                @Override
                public Acknowledge set(String parameterName, Object value) {
                    return (Acknowledge)super.set(parameterName, value);
                }
            }
        }

        public class Snapshots {
            public Create create(String name, CreateSnapshotRequest content) throws IOException {
                Create result = new Create(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String snapshot) throws IOException {
                Delete result = new Delete(snapshot);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String snapshot) throws IOException {
                Get result = new Get(snapshot);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String project) throws IOException {
                List result = new List(project);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UpdateSnapshotRequest content) throws IOException {
                Patch result = new Patch(name, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class TestIamPermissions
            extends PubsubRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Patch
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, UpdateSnapshotRequest content) {
                    super(Pubsub.this, "PATCH", REST_PATH, (Object)content, Snapshot.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends PubsubRequest<ListSnapshotsResponse> {
                private static final String REST_PATH = "v1/{+project}/snapshots";
                private final Pattern PROJECT_PATTERN;
                @Key
                private String project;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String project) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListSnapshotsResponse.class);
                    this.PROJECT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProject() {
                    return this.project;
                }

                public List setProject(String project) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern ^projects/[^/]+$");
                    }
                    this.project = project;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends PubsubRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(Pubsub.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+snapshot}";
                private final Pattern SNAPSHOT_PATTERN;
                @Key
                private String snapshot;

                protected Get(String snapshot) {
                    super(Pubsub.this, "GET", REST_PATH, null, Snapshot.class);
                    this.SNAPSHOT_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.snapshot = (String)Preconditions.checkNotNull((Object)snapshot, (Object)"Required parameter snapshot must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSnapshot() {
                    return this.snapshot;
                }

                public Get setSnapshot(String snapshot) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.snapshot = snapshot;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+snapshot}";
                private final Pattern SNAPSHOT_PATTERN;
                @Key
                private String snapshot;

                protected Delete(String snapshot) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SNAPSHOT_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.snapshot = (String)Preconditions.checkNotNull((Object)snapshot, (Object)"Required parameter snapshot must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getSnapshot() {
                    return this.snapshot;
                }

                public Delete setSnapshot(String snapshot) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.snapshot = snapshot;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends PubsubRequest<Snapshot> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String name, CreateSnapshotRequest content) {
                    super(Pubsub.this, "PUT", REST_PATH, (Object)content, Snapshot.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/snapshots/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/snapshots/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Schemas {
            public Create create(String parent, Schema content) throws IOException {
                Create result = new Create(parent, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Validate validate(String parent, ValidateSchemaRequest content) throws IOException {
                Validate result = new Validate(parent, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ValidateMessage validateMessage(String parent, ValidateMessageRequest content) throws IOException {
                ValidateMessage result = new ValidateMessage(parent, content);
                Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class ValidateMessage
            extends PubsubRequest<ValidateMessageResponse> {
                private static final String REST_PATH = "v1/{+parent}/schemas:validateMessage";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected ValidateMessage(String parent, ValidateMessageRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, ValidateMessageResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public ValidateMessage set$Xgafv(String $Xgafv) {
                    return (ValidateMessage)super.set$Xgafv($Xgafv);
                }

                public ValidateMessage setAccessToken(String accessToken) {
                    return (ValidateMessage)super.setAccessToken(accessToken);
                }

                public ValidateMessage setAlt(String alt) {
                    return (ValidateMessage)super.setAlt(alt);
                }

                public ValidateMessage setCallback(String callback) {
                    return (ValidateMessage)super.setCallback(callback);
                }

                public ValidateMessage setFields(String fields) {
                    return (ValidateMessage)super.setFields(fields);
                }

                public ValidateMessage setKey(String key) {
                    return (ValidateMessage)super.setKey(key);
                }

                public ValidateMessage setOauthToken(String oauthToken) {
                    return (ValidateMessage)super.setOauthToken(oauthToken);
                }

                public ValidateMessage setPrettyPrint(Boolean prettyPrint) {
                    return (ValidateMessage)super.setPrettyPrint(prettyPrint);
                }

                public ValidateMessage setQuotaUser(String quotaUser) {
                    return (ValidateMessage)super.setQuotaUser(quotaUser);
                }

                public ValidateMessage setUploadType(String uploadType) {
                    return (ValidateMessage)super.setUploadType(uploadType);
                }

                public ValidateMessage setUploadProtocol(String uploadProtocol) {
                    return (ValidateMessage)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public ValidateMessage setParent(String parent) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public ValidateMessage set(String parameterName, Object value) {
                    return (ValidateMessage)super.set(parameterName, value);
                }
            }

            public class Validate
            extends PubsubRequest<ValidateSchemaResponse> {
                private static final String REST_PATH = "v1/{+parent}/schemas:validate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Validate(String parent, ValidateSchemaRequest content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, ValidateSchemaResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Validate set$Xgafv(String $Xgafv) {
                    return (Validate)super.set$Xgafv($Xgafv);
                }

                public Validate setAccessToken(String accessToken) {
                    return (Validate)super.setAccessToken(accessToken);
                }

                public Validate setAlt(String alt) {
                    return (Validate)super.setAlt(alt);
                }

                public Validate setCallback(String callback) {
                    return (Validate)super.setCallback(callback);
                }

                public Validate setFields(String fields) {
                    return (Validate)super.setFields(fields);
                }

                public Validate setKey(String key) {
                    return (Validate)super.setKey(key);
                }

                public Validate setOauthToken(String oauthToken) {
                    return (Validate)super.setOauthToken(oauthToken);
                }

                public Validate setPrettyPrint(Boolean prettyPrint) {
                    return (Validate)super.setPrettyPrint(prettyPrint);
                }

                public Validate setQuotaUser(String quotaUser) {
                    return (Validate)super.setQuotaUser(quotaUser);
                }

                public Validate setUploadType(String uploadType) {
                    return (Validate)super.setUploadType(uploadType);
                }

                public Validate setUploadProtocol(String uploadProtocol) {
                    return (Validate)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Validate setParent(String parent) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Validate set(String parameterName, Object value) {
                    return (Validate)super.set(parameterName, value);
                }
            }

            public class List
            extends PubsubRequest<ListSchemasResponse> {
                private static final String REST_PATH = "v1/{+parent}/schemas";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String parent) {
                    super(Pubsub.this, "GET", REST_PATH, null, ListSchemasResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends PubsubRequest<Schema> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String view;

                protected Get(String name) {
                    super(Pubsub.this, "GET", REST_PATH, null, Schema.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/schemas/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/schemas/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/schemas/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends PubsubRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/schemas/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/schemas/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/schemas/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends PubsubRequest<Schema> {
                private static final String REST_PATH = "v1/{+parent}/schemas";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String schemaId;

                protected Create(String parent, Schema content) {
                    super(Pubsub.this, "POST", REST_PATH, (Object)content, Schema.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!Pubsub.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getSchemaId() {
                    return this.schemaId;
                }

                public Create setSchemaId(String schemaId) {
                    this.schemaId = schemaId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }
}

