/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the `Seek` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SeekRequest extends com.google.api.client.json.GenericJson {

  /**
   * The snapshot to seek to. The snapshot's topic must be the same as that of the provided
   * subscription. Format is `projects/{project}/snapshots/{snap}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snapshot;

  /**
   * The time to seek to. Messages retained in the subscription that were published before this time
   * are marked as acknowledged, and messages retained in the subscription that were published after
   * this time are marked as unacknowledged. Note that this operation affects only those messages
   * retained in the subscription (configured by the combination of `message_retention_duration` and
   * `retain_acked_messages`). For example, if `time` corresponds to a point before the message
   * retention window (or to a point before the system's notion of the subscription creation time),
   * only retained messages will be marked as unacknowledged, and already-expunged messages will not
   * be restored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String time;

  /**
   * The snapshot to seek to. The snapshot's topic must be the same as that of the provided
   * subscription. Format is `projects/{project}/snapshots/{snap}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnapshot() {
    return snapshot;
  }

  /**
   * The snapshot to seek to. The snapshot's topic must be the same as that of the provided
   * subscription. Format is `projects/{project}/snapshots/{snap}`.
   * @param snapshot snapshot or {@code null} for none
   */
  public SeekRequest setSnapshot(java.lang.String snapshot) {
    this.snapshot = snapshot;
    return this;
  }

  /**
   * The time to seek to. Messages retained in the subscription that were published before this time
   * are marked as acknowledged, and messages retained in the subscription that were published after
   * this time are marked as unacknowledged. Note that this operation affects only those messages
   * retained in the subscription (configured by the combination of `message_retention_duration` and
   * `retain_acked_messages`). For example, if `time` corresponds to a point before the message
   * retention window (or to a point before the system's notion of the subscription creation time),
   * only retained messages will be marked as unacknowledged, and already-expunged messages will not
   * be restored.
   * @return value or {@code null} for none
   */
  public String getTime() {
    return time;
  }

  /**
   * The time to seek to. Messages retained in the subscription that were published before this time
   * are marked as acknowledged, and messages retained in the subscription that were published after
   * this time are marked as unacknowledged. Note that this operation affects only those messages
   * retained in the subscription (configured by the combination of `message_retention_duration` and
   * `retain_acked_messages`). For example, if `time` corresponds to a point before the message
   * retention window (or to a point before the system's notion of the subscription creation time),
   * only retained messages will be marked as unacknowledged, and already-expunged messages will not
   * be restored.
   * @param time time or {@code null} for none
   */
  public SeekRequest setTime(String time) {
    this.time = time;
    return this;
  }

  @Override
  public SeekRequest set(String fieldName, Object value) {
    return (SeekRequest) super.set(fieldName, value);
  }

  @Override
  public SeekRequest clone() {
    return (SeekRequest) super.clone();
  }

}
