/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the `CreateSnapshot` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateSnapshotRequest extends com.google.api.client.json.GenericJson {

  /**
   * See [Creating and managing labels](https://cloud.google.com/pubsub/docs/labels).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Required. The subscription whose backlog the snapshot retains. Specifically, the created
   * snapshot is guaranteed to retain: (a) The existing backlog on the subscription. More precisely,
   * this is defined as the messages in the subscription's backlog that are unacknowledged upon the
   * successful completion of the `CreateSnapshot` request; as well as: (b) Any messages published
   * to the subscription's topic following the successful completion of the CreateSnapshot request.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subscription;

  /**
   * See [Creating and managing labels](https://cloud.google.com/pubsub/docs/labels).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * See [Creating and managing labels](https://cloud.google.com/pubsub/docs/labels).
   * @param labels labels or {@code null} for none
   */
  public CreateSnapshotRequest setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Required. The subscription whose backlog the snapshot retains. Specifically, the created
   * snapshot is guaranteed to retain: (a) The existing backlog on the subscription. More precisely,
   * this is defined as the messages in the subscription's backlog that are unacknowledged upon the
   * successful completion of the `CreateSnapshot` request; as well as: (b) Any messages published
   * to the subscription's topic following the successful completion of the CreateSnapshot request.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubscription() {
    return subscription;
  }

  /**
   * Required. The subscription whose backlog the snapshot retains. Specifically, the created
   * snapshot is guaranteed to retain: (a) The existing backlog on the subscription. More precisely,
   * this is defined as the messages in the subscription's backlog that are unacknowledged upon the
   * successful completion of the `CreateSnapshot` request; as well as: (b) Any messages published
   * to the subscription's topic following the successful completion of the CreateSnapshot request.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * @param subscription subscription or {@code null} for none
   */
  public CreateSnapshotRequest setSubscription(java.lang.String subscription) {
    this.subscription = subscription;
    return this;
  }

  @Override
  public CreateSnapshotRequest set(String fieldName, Object value) {
    return (CreateSnapshotRequest) super.set(fieldName, value);
  }

  @Override
  public CreateSnapshotRequest clone() {
    return (CreateSnapshotRequest) super.clone();
  }

}
