/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * A policy that specifies how Cloud Pub/Sub retries message delivery. Retry delay will be
 * exponential based on provided minimum and maximum backoffs.
 * https://en.wikipedia.org/wiki/Exponential_backoff. RetryPolicy will be triggered on NACKs or
 * acknowledgement deadline exceeded events for a given message. Retry Policy is implemented on a
 * best effort basis. At times, the delay between consecutive deliveries may not match the
 * configuration. That is, delay can be more or less than configured backoff.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RetryPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The maximum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 600 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String maximumBackoff;

  /**
   * The minimum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 10 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String minimumBackoff;

  /**
   * The maximum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 600 seconds.
   * @return value or {@code null} for none
   */
  public String getMaximumBackoff() {
    return maximumBackoff;
  }

  /**
   * The maximum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 600 seconds.
   * @param maximumBackoff maximumBackoff or {@code null} for none
   */
  public RetryPolicy setMaximumBackoff(String maximumBackoff) {
    this.maximumBackoff = maximumBackoff;
    return this;
  }

  /**
   * The minimum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 10 seconds.
   * @return value or {@code null} for none
   */
  public String getMinimumBackoff() {
    return minimumBackoff;
  }

  /**
   * The minimum delay between consecutive deliveries of a given message. Value should be between 0
   * and 600 seconds. Defaults to 10 seconds.
   * @param minimumBackoff minimumBackoff or {@code null} for none
   */
  public RetryPolicy setMinimumBackoff(String minimumBackoff) {
    this.minimumBackoff = minimumBackoff;
    return this;
  }

  @Override
  public RetryPolicy set(String fieldName, Object value) {
    return (RetryPolicy) super.set(fieldName, value);
  }

  @Override
  public RetryPolicy clone() {
    return (RetryPolicy) super.clone();
  }

}
