/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.rcsbusinessmessaging.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.rcsbusinessmessaging.v1.RCSBusinessMessagingRequest;
import com.google.api.services.rcsbusinessmessaging.v1.RCSBusinessMessagingRequestInitializer;
import com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent;
import com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage;
import com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersResponse;
import com.google.api.services.rcsbusinessmessaging.v1.model.Capabilities;
import com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent;
import com.google.api.services.rcsbusinessmessaging.v1.model.Empty;
import com.google.api.services.rcsbusinessmessaging.v1.model.File;
import com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.Tester;
import java.io.IOException;
import java.util.regex.Pattern;

public class RCSBusinessMessaging
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://rcsbusinessmessaging.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://rcsbusinessmessaging.googleapis.com/";

    public RCSBusinessMessaging(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    RCSBusinessMessaging(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Files files() {
        return new Files();
    }

    public Phones phones() {
        return new Phones();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0-SNAPSHOT of the RCS Business Messaging API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://rcsbusinessmessaging.googleapis.com/", RCSBusinessMessaging.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(RCSBusinessMessaging.DEFAULT_BATCH_PATH);
        }

        public RCSBusinessMessaging build() {
            return new RCSBusinessMessaging(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setRCSBusinessMessagingRequestInitializer(RCSBusinessMessagingRequestInitializer rcsbusinessmessagingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)rcsbusinessmessagingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public BatchGet batchGet(BatchGetUsersRequest content) throws IOException {
            BatchGet result = new BatchGet(this, content);
            RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class BatchGet
        extends RCSBusinessMessagingRequest<BatchGetUsersResponse> {
            private static final String REST_PATH = "v1/users:batchGet";

            protected BatchGet(Users this$1, BatchGetUsersRequest content) {
                super(this$1.RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, BatchGetUsersResponse.class);
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }
    }

    public class Phones {
        public GetCapabilities getCapabilities(String name) throws IOException {
            GetCapabilities result = new GetCapabilities(name);
            RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AgentEvents agentEvents() {
            return new AgentEvents();
        }

        public AgentMessages agentMessages() {
            return new AgentMessages();
        }

        public Capability capability() {
            return new Capability();
        }

        public DialogflowMessages dialogflowMessages() {
            return new DialogflowMessages();
        }

        public Testers testers() {
            return new Testers();
        }

        public class Testers {
            public Create create(String parent, Tester content) throws IOException {
                Create result = new Create(parent, content);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends RCSBusinessMessagingRequest<Tester> {
                private static final String REST_PATH = "v1/{+parent}/testers";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String agentId;

                protected Create(String parent, Tester content) {
                    super(RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, Tester.class);
                    this.PARENT_PATTERN = Pattern.compile("^phones/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getAgentId() {
                    return this.agentId;
                }

                public Create setAgentId(String agentId) {
                    this.agentId = agentId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class DialogflowMessages {
            public Create create(String parent, DialogflowEvent content) throws IOException {
                Create result = new Create(parent, content);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends RCSBusinessMessagingRequest<DialogflowEvent> {
                private static final String REST_PATH = "v1/{+parent}/dialogflowMessages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String messageIdPrefix;
                @Key
                private String agentId;

                protected Create(String parent, DialogflowEvent content) {
                    super(RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, DialogflowEvent.class);
                    this.PARENT_PATTERN = Pattern.compile("^phones/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getMessageIdPrefix() {
                    return this.messageIdPrefix;
                }

                public Create setMessageIdPrefix(String messageIdPrefix) {
                    this.messageIdPrefix = messageIdPrefix;
                    return this;
                }

                public String getAgentId() {
                    return this.agentId;
                }

                public Create setAgentId(String agentId) {
                    this.agentId = agentId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Capability {
            public RequestCapabilityCallback requestCapabilityCallback(String name, RequestCapabilityCallbackRequest content) throws IOException {
                RequestCapabilityCallback result = new RequestCapabilityCallback(name, content);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class RequestCapabilityCallback
            extends RCSBusinessMessagingRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}/capability:requestCapabilityCallback";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected RequestCapabilityCallback(String name, RequestCapabilityCallbackRequest content) {
                    super(RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^phones/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+$");
                    }
                }

                public RequestCapabilityCallback set$Xgafv(String $Xgafv) {
                    return (RequestCapabilityCallback)super.set$Xgafv($Xgafv);
                }

                public RequestCapabilityCallback setAccessToken(String accessToken) {
                    return (RequestCapabilityCallback)super.setAccessToken(accessToken);
                }

                public RequestCapabilityCallback setAlt(String alt) {
                    return (RequestCapabilityCallback)super.setAlt(alt);
                }

                public RequestCapabilityCallback setCallback(String callback) {
                    return (RequestCapabilityCallback)super.setCallback(callback);
                }

                public RequestCapabilityCallback setFields(String fields) {
                    return (RequestCapabilityCallback)super.setFields(fields);
                }

                public RequestCapabilityCallback setKey(String key) {
                    return (RequestCapabilityCallback)super.setKey(key);
                }

                public RequestCapabilityCallback setOauthToken(String oauthToken) {
                    return (RequestCapabilityCallback)super.setOauthToken(oauthToken);
                }

                public RequestCapabilityCallback setPrettyPrint(Boolean prettyPrint) {
                    return (RequestCapabilityCallback)super.setPrettyPrint(prettyPrint);
                }

                public RequestCapabilityCallback setQuotaUser(String quotaUser) {
                    return (RequestCapabilityCallback)super.setQuotaUser(quotaUser);
                }

                public RequestCapabilityCallback setUploadType(String uploadType) {
                    return (RequestCapabilityCallback)super.setUploadType(uploadType);
                }

                public RequestCapabilityCallback setUploadProtocol(String uploadProtocol) {
                    return (RequestCapabilityCallback)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public RequestCapabilityCallback setName(String name) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public RequestCapabilityCallback set(String parameterName, Object value) {
                    return (RequestCapabilityCallback)super.set(parameterName, value);
                }
            }
        }

        public class AgentMessages {
            public Create create(String parent, AgentMessage content) throws IOException {
                Create result = new Create(parent, content);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Delete
            extends RCSBusinessMessagingRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String agentId;

                protected Delete(String name) {
                    super(RCSBusinessMessaging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^phones/[^/]+/agentMessages/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+/agentMessages/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+/agentMessages/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getAgentId() {
                    return this.agentId;
                }

                public Delete setAgentId(String agentId) {
                    this.agentId = agentId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends RCSBusinessMessagingRequest<AgentMessage> {
                private static final String REST_PATH = "v1/{+parent}/agentMessages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String messageId;
                @Key
                private String agentId;

                protected Create(String parent, AgentMessage content) {
                    super(RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, AgentMessage.class);
                    this.PARENT_PATTERN = Pattern.compile("^phones/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getMessageId() {
                    return this.messageId;
                }

                public Create setMessageId(String messageId) {
                    this.messageId = messageId;
                    return this;
                }

                public String getAgentId() {
                    return this.agentId;
                }

                public Create setAgentId(String agentId) {
                    this.agentId = agentId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class AgentEvents {
            public Create create(String parent, AgentEvent content) throws IOException {
                Create result = new Create(parent, content);
                RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends RCSBusinessMessagingRequest<AgentEvent> {
                private static final String REST_PATH = "v1/{+parent}/agentEvents";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String eventId;
                @Key
                private String agentId;

                protected Create(String parent, AgentEvent content) {
                    super(RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, AgentEvent.class);
                    this.PARENT_PATTERN = Pattern.compile("^phones/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^phones/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getEventId() {
                    return this.eventId;
                }

                public Create setEventId(String eventId) {
                    this.eventId = eventId;
                    return this;
                }

                public String getAgentId() {
                    return this.agentId;
                }

                public Create setAgentId(String agentId) {
                    this.agentId = agentId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class GetCapabilities
        extends RCSBusinessMessagingRequest<Capabilities> {
            private static final String REST_PATH = "v1/{+name}/capabilities";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String requestId;
            @Key
            private String agentId;

            protected GetCapabilities(String name) {
                super(RCSBusinessMessaging.this, "GET", REST_PATH, null, Capabilities.class);
                this.NAME_PATTERN = Pattern.compile("^phones/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetCapabilities set$Xgafv(String $Xgafv) {
                return (GetCapabilities)super.set$Xgafv($Xgafv);
            }

            public GetCapabilities setAccessToken(String accessToken) {
                return (GetCapabilities)super.setAccessToken(accessToken);
            }

            public GetCapabilities setAlt(String alt) {
                return (GetCapabilities)super.setAlt(alt);
            }

            public GetCapabilities setCallback(String callback) {
                return (GetCapabilities)super.setCallback(callback);
            }

            public GetCapabilities setFields(String fields) {
                return (GetCapabilities)super.setFields(fields);
            }

            public GetCapabilities setKey(String key) {
                return (GetCapabilities)super.setKey(key);
            }

            public GetCapabilities setOauthToken(String oauthToken) {
                return (GetCapabilities)super.setOauthToken(oauthToken);
            }

            public GetCapabilities setPrettyPrint(Boolean prettyPrint) {
                return (GetCapabilities)super.setPrettyPrint(prettyPrint);
            }

            public GetCapabilities setQuotaUser(String quotaUser) {
                return (GetCapabilities)super.setQuotaUser(quotaUser);
            }

            public GetCapabilities setUploadType(String uploadType) {
                return (GetCapabilities)super.setUploadType(uploadType);
            }

            public GetCapabilities setUploadProtocol(String uploadProtocol) {
                return (GetCapabilities)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetCapabilities setName(String name) {
                if (!RCSBusinessMessaging.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^phones/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public GetCapabilities setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public String getAgentId() {
                return this.agentId;
            }

            public GetCapabilities setAgentId(String agentId) {
                this.agentId = agentId;
                return this;
            }

            @Override
            public GetCapabilities set(String parameterName, Object value) {
                return (GetCapabilities)super.set(parameterName, value);
            }
        }
    }

    public class Files {
        public Create create(CreateFileRequest content) throws IOException {
            Create result = new Create(this, content);
            RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(CreateFileRequest content, AbstractInputStreamContent mediaContent) throws IOException {
            Create result = new Create(this, content, mediaContent);
            RCSBusinessMessaging.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends RCSBusinessMessagingRequest<File> {
            private static final String REST_PATH = "v1/files";

            protected Create(Files this$1, CreateFileRequest content) {
                super(this$1.RCSBusinessMessaging.this, "POST", REST_PATH, (Object)content, File.class);
            }

            protected Create(Files this$1, CreateFileRequest content, AbstractInputStreamContent mediaContent) {
                String string = this$1.RCSBusinessMessaging.this.getServicePath();
                super(this$1.RCSBusinessMessaging.this, "POST", new StringBuilder(16 + String.valueOf(string).length()).append("/upload/").append(string).append(REST_PATH).toString(), (Object)content, File.class);
                this.initializeMediaUpload(mediaContent);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

