/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.rcsbusinessmessaging.v1;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.rcsbusinessmessaging.v1.RCSBusinessMessaging;
import com.google.api.services.rcsbusinessmessaging.v1.model.AgentContentMessage;
import com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent;
import com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage;
import com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersResponse;
import com.google.api.services.rcsbusinessmessaging.v1.model.Capabilities;
import com.google.api.services.rcsbusinessmessaging.v1.model.CardContent;
import com.google.api.services.rcsbusinessmessaging.v1.model.CarouselCard;
import com.google.api.services.rcsbusinessmessaging.v1.model.ContentInfo;
import com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.Empty;
import com.google.api.services.rcsbusinessmessaging.v1.model.EventType;
import com.google.api.services.rcsbusinessmessaging.v1.model.File;
import com.google.api.services.rcsbusinessmessaging.v1.model.Media;
import com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest;
import com.google.api.services.rcsbusinessmessaging.v1.model.RichCard;
import com.google.api.services.rcsbusinessmessaging.v1.model.StandaloneCard;
import com.google.api.services.rcsbusinessmessaging.v1.model.Suggestion;
import com.google.api.services.rcsbusinessmessaging.v1.model.Tester;
import com.google.api.services.rcsbusinessmessaging.v1.model.cards.CardOrientation;
import com.google.api.services.rcsbusinessmessaging.v1.model.cards.CardWidth;
import com.google.api.services.rcsbusinessmessaging.v1.model.cards.MediaHeight;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RbmApiHelper {
    private static final Logger logger = Logger.getLogger(RbmApiHelper.class.getName());
    private static final String EXCEPTION_WAS_THROWN = "an exception was thrown";
    private GoogleCredential credential;
    private RCSBusinessMessaging.Builder builder;

    public RbmApiHelper() {
    }

    public RbmApiHelper(java.io.File serviceAccountKeyFile) {
        this.initCredentials(serviceAccountKeyFile);
        this.initRbmApi();
    }

    private void initCredentials(java.io.File serviceAccountKeyFile) {
        logger.info("Initializing credentials for RBM.");
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.credential = GoogleCredential.fromStream((InputStream)new FileInputStream(serviceAccountKeyFile));
            this.credential = this.credential.createScoped(Arrays.asList("https://www.googleapis.com/auth/rcsbusinessmessaging"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
        }
    }

    private void initRbmApi() {
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
            this.builder = new RCSBusinessMessaging.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, null).setApplicationName(this.credential.getServiceAccountProjectId());
            this.builder.setHttpRequestInitializer((HttpRequestInitializer)this.credential);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
        }
    }

    private String convertToApiFormat(String msisdn) {
        String string = String.valueOf(msisdn);
        return string.length() != 0 ? "phones/".concat(string) : new String("phones/");
    }

    public void registerTester(String msisdn) throws Exception {
        Tester tester = new Tester();
        String clientDevice = this.convertToApiFormat(msisdn);
        RCSBusinessMessaging.Phones.Testers.Create createTester = this.builder.build().phones().testers().create(clientDevice, tester);
        logger.info(((Tester)((Object)createTester.execute())).toString());
    }

    public BatchGetUsersResponse getUsers(List<String> phoneNumbers) throws Exception {
        RCSBusinessMessaging.Users.BatchGet batchGetRequest = this.builder.build().users().batchGet(new BatchGetUsersRequest().setUsers(phoneNumbers));
        HttpRequest request = batchGetRequest.buildHttpRequest();
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
        return (BatchGetUsersResponse)((Object)batchGetRequest.execute());
    }

    public void performCapabilityCheck(String msisdn) throws Exception {
        String parent = this.convertToApiFormat(msisdn);
        String requestId = UUID.randomUUID().toString();
        RequestCapabilityCallbackRequest capabilityCallbackRequest = new RequestCapabilityCallbackRequest();
        capabilityCallbackRequest.setRequestId(requestId);
        RCSBusinessMessaging.Phones.Capability.RequestCapabilityCallback request = this.builder.build().phones().capability().requestCapabilityCallback(parent, capabilityCallbackRequest);
        logger.info(((Empty)((Object)request.execute())).toString());
    }

    public String getCapability(String msisdn) throws Exception {
        String parent = this.convertToApiFormat(msisdn);
        RCSBusinessMessaging.Phones.GetCapabilities capabilityCheck = this.builder.build().phones().getCapabilities(parent);
        capabilityCheck.setRequestId(UUID.randomUUID().toString());
        try {
            return ((Capabilities)((Object)capabilityCheck.execute())).toString();
        }
        catch (GoogleJsonResponseException e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
            return e.getMessage();
        }
    }

    public String uploadFile(String fileUrl) {
        return this.uploadFile(fileUrl, null);
    }

    public String uploadFile(String fileUrl, String thumbnailFileUrl) {
        String resourceId = null;
        CreateFileRequest fileRequest = new CreateFileRequest();
        fileRequest.setFileUrl(fileUrl);
        if (thumbnailFileUrl != null && thumbnailFileUrl.length() > 0) {
            fileRequest.setThumbnailUrl(thumbnailFileUrl);
        }
        try {
            RCSBusinessMessaging.Files.Create file = this.builder.build().files().create(fileRequest);
            String jsonResponse = ((File)((Object)file.execute())).toString();
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(this){}.getType();
            Map jsonMap = (Map)gson.fromJson(jsonResponse, type);
            resourceId = (String)jsonMap.get("name");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
        }
        return resourceId;
    }

    public CardContent createCardContent(String title, String description, String imageUrl, MediaHeight height, List<Suggestion> suggestions) {
        CardContent cardContent = new CardContent();
        if (imageUrl != null) {
            Media media = new Media();
            media.setContentInfo(new ContentInfo().setFileUrl(imageUrl));
            media.setHeight(height.toString());
            cardContent.setMedia(media);
        }
        if (title != null) {
            cardContent.setTitle(title);
        }
        if (description != null) {
            cardContent.setDescription(description);
        }
        if (suggestions != null && suggestions.size() > 0) {
            cardContent.setSuggestions(suggestions);
        }
        return cardContent;
    }

    public StandaloneCard createStandaloneCard(String title, String description, String imageUrl, MediaHeight height, CardOrientation orientation, List<Suggestion> suggestions) {
        CardContent cardContent = this.createCardContent(title, description, imageUrl, height, suggestions);
        StandaloneCard standaloneCard = new StandaloneCard();
        standaloneCard.setCardContent(cardContent);
        standaloneCard.setCardOrientation(orientation.toString());
        return standaloneCard;
    }

    public void sendTextMessage(String messageText, String msisdn) throws IOException {
        this.sendTextMessage(messageText, msisdn, null);
    }

    public void sendTextMessage(String messageText, String msisdn, List<Suggestion> suggestions) throws IOException {
        AgentContentMessage agentContentMessage = new AgentContentMessage();
        agentContentMessage.setText(messageText);
        if (suggestions != null && suggestions.size() > 0) {
            agentContentMessage.setSuggestions(suggestions);
        }
        AgentMessage agentMessage = new AgentMessage();
        agentMessage.setContentMessage(agentContentMessage);
        this.sendAgentMessage(agentMessage, msisdn);
    }

    public void sendStandaloneCard(StandaloneCard standaloneCard, String msisdn) throws IOException {
        RichCard richCard = new RichCard();
        richCard.setStandaloneCard(standaloneCard);
        AgentContentMessage agentContentMessage = new AgentContentMessage();
        agentContentMessage.setRichCard(richCard);
        AgentMessage agentMessage = new AgentMessage();
        agentMessage.setContentMessage(agentContentMessage);
        this.sendAgentMessage(agentMessage, msisdn);
    }

    public void sendCarouselCards(List<CardContent> cardContents, CardWidth cardWidth, String msisdn) throws IOException {
        CarouselCard carouselCard = new CarouselCard();
        carouselCard.setCardContents(cardContents);
        carouselCard.setCardWidth(cardWidth.toString());
        RichCard richCard = new RichCard();
        richCard.setCarouselCard(carouselCard);
        AgentContentMessage agentContentMessage = new AgentContentMessage();
        agentContentMessage.setRichCard(richCard);
        AgentMessage agentMessage = new AgentMessage();
        agentMessage.setContentMessage(agentContentMessage);
        this.sendAgentMessage(agentMessage, msisdn);
    }

    public void sendAgentMessage(AgentMessage agentMessage, String msisdn) throws IOException {
        RCSBusinessMessaging.Phones.AgentMessages.Create message = this.builder.build().phones().agentMessages().create(this.convertToApiFormat(msisdn), agentMessage);
        message.setMessageId(UUID.randomUUID().toString());
        String string = String.valueOf(msisdn);
        logger.info(string.length() != 0 ? "Sending message to client ".concat(string) : new String("Sending message to client "));
        logger.info(((AgentMessage)((Object)message.execute())).toString());
    }

    public void sendReadMessage(String messageId, String msisdn) {
        try {
            String deviceNumber = this.convertToApiFormat(msisdn);
            AgentEvent agentEvent = new AgentEvent();
            agentEvent.setEventType(EventType.READ.toString());
            agentEvent.setMessageId(messageId);
            RCSBusinessMessaging.Phones.AgentEvents.Create agentEventMessage = this.builder.build().phones().agentEvents().create(deviceNumber, agentEvent);
            agentEventMessage.setEventId(UUID.randomUUID().toString());
            agentEventMessage.execute();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
        }
    }

    public void sendIsTypingMessage(String msisdn) {
        try {
            String deviceNumber = this.convertToApiFormat(msisdn);
            AgentEvent agentEvent = new AgentEvent();
            agentEvent.setEventType(EventType.IS_TYPING.toString());
            RCSBusinessMessaging.Phones.AgentEvents.Create agentEventMessage = this.builder.build().phones().agentEvents().create(deviceNumber, agentEvent);
            agentEventMessage.setEventId(UUID.randomUUID().toString());
            agentEventMessage.execute();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, EXCEPTION_WAS_THROWN, e);
        }
    }
}

