/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.rcsbusinessmessaging.v1;

import com.google.api.services.rcsbusinessmessaging.v1.RbmApiHelper;
import com.google.api.services.rcsbusinessmessaging.v1.SuggestionHelper;
import com.google.api.services.rcsbusinessmessaging.v1.model.CardContent;
import com.google.api.services.rcsbusinessmessaging.v1.model.Suggestion;
import com.google.api.services.rcsbusinessmessaging.v1.model.cards.MediaHeight;
import java.util.ArrayList;
import java.util.List;

public class StandaloneCardHelper {
    private String title;
    private String description;
    private String imageFileUrl;
    private List<SuggestionHelper> suggestions;

    public StandaloneCardHelper(String title, String description, String imageFileUrl, List<SuggestionHelper> suggestions) {
        this.title = title;
        this.description = description;
        this.imageFileUrl = imageFileUrl;
        this.suggestions = suggestions;
    }

    public StandaloneCardHelper(String title, String description, String imageFileUrl, SuggestionHelper suggestion) {
        this(title, description, imageFileUrl, new ArrayList<SuggestionHelper>());
        this.suggestions.add(suggestion);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImageFileUrl() {
        return this.imageFileUrl;
    }

    public List<SuggestionHelper> getSuggestions() {
        return this.suggestions;
    }

    public CardContent getCardContent() {
        return this.getCardContent(MediaHeight.MEDIUM);
    }

    public CardContent getCardContent(MediaHeight height) {
        RbmApiHelper rbmApiHelper = new RbmApiHelper();
        ArrayList<Suggestion> suggestedReplies = new ArrayList<Suggestion>();
        for (SuggestionHelper suggestion : this.suggestions) {
            suggestedReplies.add(suggestion.getSuggestedReply());
        }
        CardContent cardContent = rbmApiHelper.createCardContent(this.title, this.description, this.imageFileUrl, height, suggestedReplies);
        return cardContent;
    }
}

