/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.run.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.run.v1.CloudRunRequest;
import com.google.api.services.run.v1.CloudRunRequestInitializer;
import com.google.api.services.run.v1.model.Configuration;
import com.google.api.services.run.v1.model.DomainMapping;
import com.google.api.services.run.v1.model.ListAuthorizedDomainsResponse;
import com.google.api.services.run.v1.model.ListConfigurationsResponse;
import com.google.api.services.run.v1.model.ListDomainMappingsResponse;
import com.google.api.services.run.v1.model.ListLocationsResponse;
import com.google.api.services.run.v1.model.ListRevisionsResponse;
import com.google.api.services.run.v1.model.ListRoutesResponse;
import com.google.api.services.run.v1.model.ListServicesResponse;
import com.google.api.services.run.v1.model.Policy;
import com.google.api.services.run.v1.model.Revision;
import com.google.api.services.run.v1.model.Route;
import com.google.api.services.run.v1.model.Service;
import com.google.api.services.run.v1.model.SetIamPolicyRequest;
import com.google.api.services.run.v1.model.Status;
import com.google.api.services.run.v1.model.TestIamPermissionsRequest;
import com.google.api.services.run.v1.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudRun
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://run.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://run.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://run.googleapis.com/";

    public CloudRun(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudRun(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Namespaces namespaces() {
        return new Namespaces();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Cloud Run Admin API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudRun.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://run.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudRun.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudRun.DEFAULT_BATCH_PATH);
        }

        public CloudRun build() {
            return new CloudRun(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudRunRequestInitializer(CloudRunRequestInitializer cloudrunRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudrunRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Authorizeddomains authorizeddomains() {
            return new Authorizeddomains();
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public List list(String name) throws IOException {
                List result = new List(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Authorizeddomains authorizeddomains() {
                return new Authorizeddomains();
            }

            public Configurations configurations() {
                return new Configurations();
            }

            public Domainmappings domainmappings() {
                return new Domainmappings();
            }

            public Revisions revisions() {
                return new Revisions();
            }

            public Routes routes() {
                return new Routes();
            }

            public Services services() {
                return new Services();
            }

            public class Services {
                public Create create(String parent, Service content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ReplaceService replaceService(String name, Service content) throws IOException {
                    ReplaceService result = new ReplaceService(name, content);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class TestIamPermissions
                extends CloudRunRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(CloudRun.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends CloudRunRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(CloudRun.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class ReplaceService
                extends CloudRunRequest<Service> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected ReplaceService(String name, Service content) {
                        super(CloudRun.this, "PUT", REST_PATH, (Object)content, Service.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public ReplaceService set$Xgafv(String $Xgafv) {
                        return (ReplaceService)super.set$Xgafv($Xgafv);
                    }

                    public ReplaceService setAccessToken(String accessToken) {
                        return (ReplaceService)super.setAccessToken(accessToken);
                    }

                    public ReplaceService setAlt(String alt) {
                        return (ReplaceService)super.setAlt(alt);
                    }

                    public ReplaceService setCallback(String callback) {
                        return (ReplaceService)super.setCallback(callback);
                    }

                    public ReplaceService setFields(String fields) {
                        return (ReplaceService)super.setFields(fields);
                    }

                    public ReplaceService setKey(String key) {
                        return (ReplaceService)super.setKey(key);
                    }

                    public ReplaceService setOauthToken(String oauthToken) {
                        return (ReplaceService)super.setOauthToken(oauthToken);
                    }

                    public ReplaceService setPrettyPrint(Boolean prettyPrint) {
                        return (ReplaceService)super.setPrettyPrint(prettyPrint);
                    }

                    public ReplaceService setQuotaUser(String quotaUser) {
                        return (ReplaceService)super.setQuotaUser(quotaUser);
                    }

                    public ReplaceService setUploadType(String uploadType) {
                        return (ReplaceService)super.setUploadType(uploadType);
                    }

                    public ReplaceService setUploadProtocol(String uploadProtocol) {
                        return (ReplaceService)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public ReplaceService setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public ReplaceService set(String parameterName, Object value) {
                        return (ReplaceService)super.set(parameterName, value);
                    }
                }

                public class List
                extends CloudRunRequest<ListServicesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/services";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key(value="continue")
                    private String continue__;
                    @Key
                    private String fieldSelector;
                    @Key
                    private Boolean includeUninitialized;
                    @Key
                    private String labelSelector;
                    @Key
                    private Integer limit;
                    @Key
                    private String resourceVersion;
                    @Key
                    private Boolean watch;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListServicesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getContinue() {
                        return this.continue__;
                    }

                    public List setContinue(String continue__) {
                        this.continue__ = continue__;
                        return this;
                    }

                    public String getFieldSelector() {
                        return this.fieldSelector;
                    }

                    public List setFieldSelector(String fieldSelector) {
                        this.fieldSelector = fieldSelector;
                        return this;
                    }

                    public Boolean getIncludeUninitialized() {
                        return this.includeUninitialized;
                    }

                    public List setIncludeUninitialized(Boolean includeUninitialized) {
                        this.includeUninitialized = includeUninitialized;
                        return this;
                    }

                    public String getLabelSelector() {
                        return this.labelSelector;
                    }

                    public List setLabelSelector(String labelSelector) {
                        this.labelSelector = labelSelector;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getResourceVersion() {
                        return this.resourceVersion;
                    }

                    public List setResourceVersion(String resourceVersion) {
                        this.resourceVersion = resourceVersion;
                        return this;
                    }

                    public Boolean getWatch() {
                        return this.watch;
                    }

                    public List setWatch(Boolean watch) {
                        this.watch = watch;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends CloudRunRequest<Policy> {
                    private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(CloudRun.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudRunRequest<Service> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudRun.this, "GET", REST_PATH, null, Service.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudRunRequest<Status> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String apiVersion;
                    @Key
                    private String kind;
                    @Key
                    private String propagationPolicy;

                    protected Delete(String name) {
                        super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/services/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getApiVersion() {
                        return this.apiVersion;
                    }

                    public Delete setApiVersion(String apiVersion) {
                        this.apiVersion = apiVersion;
                        return this;
                    }

                    public String getKind() {
                        return this.kind;
                    }

                    public Delete setKind(String kind) {
                        this.kind = kind;
                        return this;
                    }

                    public String getPropagationPolicy() {
                        return this.propagationPolicy;
                    }

                    public Delete setPropagationPolicy(String propagationPolicy) {
                        this.propagationPolicy = propagationPolicy;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudRunRequest<Service> {
                    private static final String REST_PATH = "v1/{+parent}/services";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Service content) {
                        super(CloudRun.this, "POST", REST_PATH, (Object)content, Service.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Routes {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudRunRequest<ListRoutesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/routes";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key(value="continue")
                    private String continue__;
                    @Key
                    private String fieldSelector;
                    @Key
                    private Boolean includeUninitialized;
                    @Key
                    private String labelSelector;
                    @Key
                    private Integer limit;
                    @Key
                    private String resourceVersion;
                    @Key
                    private Boolean watch;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListRoutesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getContinue() {
                        return this.continue__;
                    }

                    public List setContinue(String continue__) {
                        this.continue__ = continue__;
                        return this;
                    }

                    public String getFieldSelector() {
                        return this.fieldSelector;
                    }

                    public List setFieldSelector(String fieldSelector) {
                        this.fieldSelector = fieldSelector;
                        return this;
                    }

                    public Boolean getIncludeUninitialized() {
                        return this.includeUninitialized;
                    }

                    public List setIncludeUninitialized(Boolean includeUninitialized) {
                        this.includeUninitialized = includeUninitialized;
                        return this;
                    }

                    public String getLabelSelector() {
                        return this.labelSelector;
                    }

                    public List setLabelSelector(String labelSelector) {
                        this.labelSelector = labelSelector;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getResourceVersion() {
                        return this.resourceVersion;
                    }

                    public List setResourceVersion(String resourceVersion) {
                        this.resourceVersion = resourceVersion;
                        return this;
                    }

                    public Boolean getWatch() {
                        return this.watch;
                    }

                    public List setWatch(Boolean watch) {
                        this.watch = watch;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudRunRequest<Route> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudRun.this, "GET", REST_PATH, null, Route.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/routes/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/routes/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/routes/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Revisions {
                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudRunRequest<ListRevisionsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/revisions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key(value="continue")
                    private String continue__;
                    @Key
                    private String fieldSelector;
                    @Key
                    private Boolean includeUninitialized;
                    @Key
                    private String labelSelector;
                    @Key
                    private Integer limit;
                    @Key
                    private String resourceVersion;
                    @Key
                    private Boolean watch;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListRevisionsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getContinue() {
                        return this.continue__;
                    }

                    public List setContinue(String continue__) {
                        this.continue__ = continue__;
                        return this;
                    }

                    public String getFieldSelector() {
                        return this.fieldSelector;
                    }

                    public List setFieldSelector(String fieldSelector) {
                        this.fieldSelector = fieldSelector;
                        return this;
                    }

                    public Boolean getIncludeUninitialized() {
                        return this.includeUninitialized;
                    }

                    public List setIncludeUninitialized(Boolean includeUninitialized) {
                        this.includeUninitialized = includeUninitialized;
                        return this;
                    }

                    public String getLabelSelector() {
                        return this.labelSelector;
                    }

                    public List setLabelSelector(String labelSelector) {
                        this.labelSelector = labelSelector;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getResourceVersion() {
                        return this.resourceVersion;
                    }

                    public List setResourceVersion(String resourceVersion) {
                        this.resourceVersion = resourceVersion;
                        return this;
                    }

                    public Boolean getWatch() {
                        return this.watch;
                    }

                    public List setWatch(Boolean watch) {
                        this.watch = watch;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudRunRequest<Revision> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudRun.this, "GET", REST_PATH, null, Revision.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudRunRequest<Status> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String apiVersion;
                    @Key
                    private String kind;
                    @Key
                    private String propagationPolicy;

                    protected Delete(String name) {
                        super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/revisions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getApiVersion() {
                        return this.apiVersion;
                    }

                    public Delete setApiVersion(String apiVersion) {
                        this.apiVersion = apiVersion;
                        return this;
                    }

                    public String getKind() {
                        return this.kind;
                    }

                    public Delete setKind(String kind) {
                        this.kind = kind;
                        return this;
                    }

                    public String getPropagationPolicy() {
                        return this.propagationPolicy;
                    }

                    public Delete setPropagationPolicy(String propagationPolicy) {
                        this.propagationPolicy = propagationPolicy;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }
            }

            public class Domainmappings {
                public Create create(String parent, DomainMapping content) throws IOException {
                    Create result = new Create(parent, content);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudRunRequest<ListDomainMappingsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/domainmappings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key(value="continue")
                    private String continue__;
                    @Key
                    private String fieldSelector;
                    @Key
                    private Boolean includeUninitialized;
                    @Key
                    private String labelSelector;
                    @Key
                    private Integer limit;
                    @Key
                    private String resourceVersion;
                    @Key
                    private Boolean watch;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListDomainMappingsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getContinue() {
                        return this.continue__;
                    }

                    public List setContinue(String continue__) {
                        this.continue__ = continue__;
                        return this;
                    }

                    public String getFieldSelector() {
                        return this.fieldSelector;
                    }

                    public List setFieldSelector(String fieldSelector) {
                        this.fieldSelector = fieldSelector;
                        return this;
                    }

                    public Boolean getIncludeUninitialized() {
                        return this.includeUninitialized;
                    }

                    public List setIncludeUninitialized(Boolean includeUninitialized) {
                        this.includeUninitialized = includeUninitialized;
                        return this;
                    }

                    public String getLabelSelector() {
                        return this.labelSelector;
                    }

                    public List setLabelSelector(String labelSelector) {
                        this.labelSelector = labelSelector;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getResourceVersion() {
                        return this.resourceVersion;
                    }

                    public List setResourceVersion(String resourceVersion) {
                        this.resourceVersion = resourceVersion;
                        return this;
                    }

                    public Boolean getWatch() {
                        return this.watch;
                    }

                    public List setWatch(Boolean watch) {
                        this.watch = watch;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudRunRequest<DomainMapping> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudRun.this, "GET", REST_PATH, null, DomainMapping.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends CloudRunRequest<Status> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String apiVersion;
                    @Key
                    private String kind;
                    @Key
                    private String propagationPolicy;

                    protected Delete(String name) {
                        super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/domainmappings/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getApiVersion() {
                        return this.apiVersion;
                    }

                    public Delete setApiVersion(String apiVersion) {
                        this.apiVersion = apiVersion;
                        return this;
                    }

                    public String getKind() {
                        return this.kind;
                    }

                    public Delete setKind(String kind) {
                        this.kind = kind;
                        return this;
                    }

                    public String getPropagationPolicy() {
                        return this.propagationPolicy;
                    }

                    public Delete setPropagationPolicy(String propagationPolicy) {
                        this.propagationPolicy = propagationPolicy;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends CloudRunRequest<DomainMapping> {
                    private static final String REST_PATH = "v1/{+parent}/domainmappings";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, DomainMapping content) {
                        super(CloudRun.this, "POST", REST_PATH, (Object)content, DomainMapping.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Configurations {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudRunRequest<ListConfigurationsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/configurations";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key(value="continue")
                    private String continue__;
                    @Key
                    private String fieldSelector;
                    @Key
                    private Boolean includeUninitialized;
                    @Key
                    private String labelSelector;
                    @Key
                    private Integer limit;
                    @Key
                    private String resourceVersion;
                    @Key
                    private Boolean watch;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListConfigurationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getContinue() {
                        return this.continue__;
                    }

                    public List setContinue(String continue__) {
                        this.continue__ = continue__;
                        return this;
                    }

                    public String getFieldSelector() {
                        return this.fieldSelector;
                    }

                    public List setFieldSelector(String fieldSelector) {
                        this.fieldSelector = fieldSelector;
                        return this;
                    }

                    public Boolean getIncludeUninitialized() {
                        return this.includeUninitialized;
                    }

                    public List setIncludeUninitialized(Boolean includeUninitialized) {
                        this.includeUninitialized = includeUninitialized;
                        return this;
                    }

                    public String getLabelSelector() {
                        return this.labelSelector;
                    }

                    public List setLabelSelector(String labelSelector) {
                        this.labelSelector = labelSelector;
                        return this;
                    }

                    public Integer getLimit() {
                        return this.limit;
                    }

                    public List setLimit(Integer limit) {
                        this.limit = limit;
                        return this;
                    }

                    public String getResourceVersion() {
                        return this.resourceVersion;
                    }

                    public List setResourceVersion(String resourceVersion) {
                        this.resourceVersion = resourceVersion;
                        return this;
                    }

                    public Boolean getWatch() {
                        return this.watch;
                    }

                    public List setWatch(Boolean watch) {
                        this.watch = watch;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends CloudRunRequest<Configuration> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(CloudRun.this, "GET", REST_PATH, null, Configuration.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/configurations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/configurations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/configurations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class Authorizeddomains {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends CloudRunRequest<ListAuthorizedDomainsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/authorizeddomains";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(CloudRun.this, "GET", REST_PATH, null, ListAuthorizedDomainsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!CloudRun.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends CloudRunRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Authorizeddomains {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListAuthorizedDomainsResponse> {
                private static final String REST_PATH = "v1/{+parent}/authorizeddomains";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListAuthorizedDomainsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }

    public class Namespaces {
        public Authorizeddomains authorizeddomains() {
            return new Authorizeddomains();
        }

        public Configurations configurations() {
            return new Configurations();
        }

        public Domainmappings domainmappings() {
            return new Domainmappings();
        }

        public Revisions revisions() {
            return new Revisions();
        }

        public Routes routes() {
            return new Routes();
        }

        public Services services() {
            return new Services();
        }

        public class Services {
            public Create create(String parent, Service content) throws IOException {
                Create result = new Create(parent, content);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ReplaceService replaceService(String name, Service content) throws IOException {
                ReplaceService result = new ReplaceService(name, content);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class ReplaceService
            extends CloudRunRequest<Service> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected ReplaceService(String name, Service content) {
                    super(CloudRun.this, "PUT", REST_PATH, (Object)content, Service.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/services/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                }

                public ReplaceService set$Xgafv(String $Xgafv) {
                    return (ReplaceService)super.set$Xgafv($Xgafv);
                }

                public ReplaceService setAccessToken(String accessToken) {
                    return (ReplaceService)super.setAccessToken(accessToken);
                }

                public ReplaceService setAlt(String alt) {
                    return (ReplaceService)super.setAlt(alt);
                }

                public ReplaceService setCallback(String callback) {
                    return (ReplaceService)super.setCallback(callback);
                }

                public ReplaceService setFields(String fields) {
                    return (ReplaceService)super.setFields(fields);
                }

                public ReplaceService setKey(String key) {
                    return (ReplaceService)super.setKey(key);
                }

                public ReplaceService setOauthToken(String oauthToken) {
                    return (ReplaceService)super.setOauthToken(oauthToken);
                }

                public ReplaceService setPrettyPrint(Boolean prettyPrint) {
                    return (ReplaceService)super.setPrettyPrint(prettyPrint);
                }

                public ReplaceService setQuotaUser(String quotaUser) {
                    return (ReplaceService)super.setQuotaUser(quotaUser);
                }

                public ReplaceService setUploadType(String uploadType) {
                    return (ReplaceService)super.setUploadType(uploadType);
                }

                public ReplaceService setUploadProtocol(String uploadProtocol) {
                    return (ReplaceService)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public ReplaceService setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public ReplaceService set(String parameterName, Object value) {
                    return (ReplaceService)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudRunRequest<ListServicesResponse> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+parent}/services";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="continue")
                private String continue__;
                @Key
                private String fieldSelector;
                @Key
                private Boolean includeUninitialized;
                @Key
                private String labelSelector;
                @Key
                private Integer limit;
                @Key
                private String resourceVersion;
                @Key
                private Boolean watch;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListServicesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getContinue() {
                    return this.continue__;
                }

                public List setContinue(String continue__) {
                    this.continue__ = continue__;
                    return this;
                }

                public String getFieldSelector() {
                    return this.fieldSelector;
                }

                public List setFieldSelector(String fieldSelector) {
                    this.fieldSelector = fieldSelector;
                    return this;
                }

                public Boolean getIncludeUninitialized() {
                    return this.includeUninitialized;
                }

                public List setIncludeUninitialized(Boolean includeUninitialized) {
                    this.includeUninitialized = includeUninitialized;
                    return this;
                }

                public String getLabelSelector() {
                    return this.labelSelector;
                }

                public List setLabelSelector(String labelSelector) {
                    this.labelSelector = labelSelector;
                    return this;
                }

                public Integer getLimit() {
                    return this.limit;
                }

                public List setLimit(Integer limit) {
                    this.limit = limit;
                    return this;
                }

                public String getResourceVersion() {
                    return this.resourceVersion;
                }

                public List setResourceVersion(String resourceVersion) {
                    this.resourceVersion = resourceVersion;
                    return this;
                }

                public Boolean getWatch() {
                    return this.watch;
                }

                public List setWatch(Boolean watch) {
                    this.watch = watch;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudRunRequest<Service> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, Service.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/services/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudRunRequest<Status> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String apiVersion;
                @Key
                private String kind;
                @Key
                private String propagationPolicy;

                protected Delete(String name) {
                    super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/services/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/services/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getApiVersion() {
                    return this.apiVersion;
                }

                public Delete setApiVersion(String apiVersion) {
                    this.apiVersion = apiVersion;
                    return this;
                }

                public String getKind() {
                    return this.kind;
                }

                public Delete setKind(String kind) {
                    this.kind = kind;
                    return this;
                }

                public String getPropagationPolicy() {
                    return this.propagationPolicy;
                }

                public Delete setPropagationPolicy(String propagationPolicy) {
                    this.propagationPolicy = propagationPolicy;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudRunRequest<Service> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+parent}/services";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, Service content) {
                    super(CloudRun.this, "POST", REST_PATH, (Object)content, Service.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Routes {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListRoutesResponse> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+parent}/routes";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="continue")
                private String continue__;
                @Key
                private String fieldSelector;
                @Key
                private Boolean includeUninitialized;
                @Key
                private String labelSelector;
                @Key
                private Integer limit;
                @Key
                private String resourceVersion;
                @Key
                private Boolean watch;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListRoutesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getContinue() {
                    return this.continue__;
                }

                public List setContinue(String continue__) {
                    this.continue__ = continue__;
                    return this;
                }

                public String getFieldSelector() {
                    return this.fieldSelector;
                }

                public List setFieldSelector(String fieldSelector) {
                    this.fieldSelector = fieldSelector;
                    return this;
                }

                public Boolean getIncludeUninitialized() {
                    return this.includeUninitialized;
                }

                public List setIncludeUninitialized(Boolean includeUninitialized) {
                    this.includeUninitialized = includeUninitialized;
                    return this;
                }

                public String getLabelSelector() {
                    return this.labelSelector;
                }

                public List setLabelSelector(String labelSelector) {
                    this.labelSelector = labelSelector;
                    return this;
                }

                public Integer getLimit() {
                    return this.limit;
                }

                public List setLimit(Integer limit) {
                    this.limit = limit;
                    return this;
                }

                public String getResourceVersion() {
                    return this.resourceVersion;
                }

                public List setResourceVersion(String resourceVersion) {
                    this.resourceVersion = resourceVersion;
                    return this;
                }

                public Boolean getWatch() {
                    return this.watch;
                }

                public List setWatch(Boolean watch) {
                    this.watch = watch;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudRunRequest<Route> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, Route.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/routes/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/routes/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/routes/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Revisions {
            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListRevisionsResponse> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+parent}/revisions";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="continue")
                private String continue__;
                @Key
                private String fieldSelector;
                @Key
                private Boolean includeUninitialized;
                @Key
                private String labelSelector;
                @Key
                private Integer limit;
                @Key
                private String resourceVersion;
                @Key
                private Boolean watch;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListRevisionsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getContinue() {
                    return this.continue__;
                }

                public List setContinue(String continue__) {
                    this.continue__ = continue__;
                    return this;
                }

                public String getFieldSelector() {
                    return this.fieldSelector;
                }

                public List setFieldSelector(String fieldSelector) {
                    this.fieldSelector = fieldSelector;
                    return this;
                }

                public Boolean getIncludeUninitialized() {
                    return this.includeUninitialized;
                }

                public List setIncludeUninitialized(Boolean includeUninitialized) {
                    this.includeUninitialized = includeUninitialized;
                    return this;
                }

                public String getLabelSelector() {
                    return this.labelSelector;
                }

                public List setLabelSelector(String labelSelector) {
                    this.labelSelector = labelSelector;
                    return this;
                }

                public Integer getLimit() {
                    return this.limit;
                }

                public List setLimit(Integer limit) {
                    this.limit = limit;
                    return this;
                }

                public String getResourceVersion() {
                    return this.resourceVersion;
                }

                public List setResourceVersion(String resourceVersion) {
                    this.resourceVersion = resourceVersion;
                    return this;
                }

                public Boolean getWatch() {
                    return this.watch;
                }

                public List setWatch(Boolean watch) {
                    this.watch = watch;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudRunRequest<Revision> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, Revision.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/revisions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/revisions/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/revisions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudRunRequest<Status> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String apiVersion;
                @Key
                private String kind;
                @Key
                private String propagationPolicy;

                protected Delete(String name) {
                    super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/revisions/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/revisions/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/revisions/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getApiVersion() {
                    return this.apiVersion;
                }

                public Delete setApiVersion(String apiVersion) {
                    this.apiVersion = apiVersion;
                    return this;
                }

                public String getKind() {
                    return this.kind;
                }

                public Delete setKind(String kind) {
                    this.kind = kind;
                    return this;
                }

                public String getPropagationPolicy() {
                    return this.propagationPolicy;
                }

                public Delete setPropagationPolicy(String propagationPolicy) {
                    this.propagationPolicy = propagationPolicy;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Domainmappings {
            public Create create(String parent, DomainMapping content) throws IOException {
                Create result = new Create(parent, content);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListDomainMappingsResponse> {
                private static final String REST_PATH = "apis/domains.cloudrun.com/v1/{+parent}/domainmappings";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="continue")
                private String continue__;
                @Key
                private String fieldSelector;
                @Key
                private Boolean includeUninitialized;
                @Key
                private String labelSelector;
                @Key
                private Integer limit;
                @Key
                private String resourceVersion;
                @Key
                private Boolean watch;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListDomainMappingsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getContinue() {
                    return this.continue__;
                }

                public List setContinue(String continue__) {
                    this.continue__ = continue__;
                    return this;
                }

                public String getFieldSelector() {
                    return this.fieldSelector;
                }

                public List setFieldSelector(String fieldSelector) {
                    this.fieldSelector = fieldSelector;
                    return this;
                }

                public Boolean getIncludeUninitialized() {
                    return this.includeUninitialized;
                }

                public List setIncludeUninitialized(Boolean includeUninitialized) {
                    this.includeUninitialized = includeUninitialized;
                    return this;
                }

                public String getLabelSelector() {
                    return this.labelSelector;
                }

                public List setLabelSelector(String labelSelector) {
                    this.labelSelector = labelSelector;
                    return this;
                }

                public Integer getLimit() {
                    return this.limit;
                }

                public List setLimit(Integer limit) {
                    this.limit = limit;
                    return this;
                }

                public String getResourceVersion() {
                    return this.resourceVersion;
                }

                public List setResourceVersion(String resourceVersion) {
                    this.resourceVersion = resourceVersion;
                    return this;
                }

                public Boolean getWatch() {
                    return this.watch;
                }

                public List setWatch(Boolean watch) {
                    this.watch = watch;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudRunRequest<DomainMapping> {
                private static final String REST_PATH = "apis/domains.cloudrun.com/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, DomainMapping.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/domainmappings/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/domainmappings/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/domainmappings/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudRunRequest<Status> {
                private static final String REST_PATH = "apis/domains.cloudrun.com/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String apiVersion;
                @Key
                private String kind;
                @Key
                private String propagationPolicy;

                protected Delete(String name) {
                    super(CloudRun.this, "DELETE", REST_PATH, null, Status.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/domainmappings/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/domainmappings/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/domainmappings/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getApiVersion() {
                    return this.apiVersion;
                }

                public Delete setApiVersion(String apiVersion) {
                    this.apiVersion = apiVersion;
                    return this;
                }

                public String getKind() {
                    return this.kind;
                }

                public Delete setKind(String kind) {
                    this.kind = kind;
                    return this;
                }

                public String getPropagationPolicy() {
                    return this.propagationPolicy;
                }

                public Delete setPropagationPolicy(String propagationPolicy) {
                    this.propagationPolicy = propagationPolicy;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudRunRequest<DomainMapping> {
                private static final String REST_PATH = "apis/domains.cloudrun.com/v1/{+parent}/domainmappings";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, DomainMapping content) {
                    super(CloudRun.this, "POST", REST_PATH, (Object)content, DomainMapping.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Configurations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListConfigurationsResponse> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+parent}/configurations";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key(value="continue")
                private String continue__;
                @Key
                private String fieldSelector;
                @Key
                private Boolean includeUninitialized;
                @Key
                private String labelSelector;
                @Key
                private Integer limit;
                @Key
                private String resourceVersion;
                @Key
                private Boolean watch;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListConfigurationsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getContinue() {
                    return this.continue__;
                }

                public List setContinue(String continue__) {
                    this.continue__ = continue__;
                    return this;
                }

                public String getFieldSelector() {
                    return this.fieldSelector;
                }

                public List setFieldSelector(String fieldSelector) {
                    this.fieldSelector = fieldSelector;
                    return this;
                }

                public Boolean getIncludeUninitialized() {
                    return this.includeUninitialized;
                }

                public List setIncludeUninitialized(Boolean includeUninitialized) {
                    this.includeUninitialized = includeUninitialized;
                    return this;
                }

                public String getLabelSelector() {
                    return this.labelSelector;
                }

                public List setLabelSelector(String labelSelector) {
                    this.labelSelector = labelSelector;
                    return this;
                }

                public Integer getLimit() {
                    return this.limit;
                }

                public List setLimit(Integer limit) {
                    this.limit = limit;
                    return this;
                }

                public String getResourceVersion() {
                    return this.resourceVersion;
                }

                public List setResourceVersion(String resourceVersion) {
                    this.resourceVersion = resourceVersion;
                    return this;
                }

                public Boolean getWatch() {
                    return this.watch;
                }

                public List setWatch(Boolean watch) {
                    this.watch = watch;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudRunRequest<Configuration> {
                private static final String REST_PATH = "apis/serving.knative.dev/v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudRun.this, "GET", REST_PATH, null, Configuration.class);
                    this.NAME_PATTERN = Pattern.compile("^namespaces/[^/]+/configurations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/configurations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^namespaces/[^/]+/configurations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Authorizeddomains {
            public List list(String parent) throws IOException {
                List result = new List(parent);
                CloudRun.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends CloudRunRequest<ListAuthorizedDomainsResponse> {
                private static final String REST_PATH = "apis/domains.cloudrun.com/v1/{+parent}/authorizeddomains";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(CloudRun.this, "GET", REST_PATH, null, ListAuthorizedDomainsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^namespaces/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!CloudRun.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^namespaces/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }
}

