/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-29 at 20:45:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script;

/**
 * Available OAuth 2.0 scopes for use with the Google Apps Script API.
 *
 * @since 1.4
 */
public class ScriptScopes {

  /** Read, send, delete, and manage your email. */
  public static final String MAIL_GOOGLE_COM = "https://mail.google.com/";

  /** Manage your calendars. */
  public static final String WWW_GOOGLE_COM_CALENDAR_FEEDS = "https://www.google.com/calendar/feeds";

  /** Manage your contacts. */
  public static final String WWW_GOOGLE_COM_M8_FEEDS = "https://www.google.com/m8/feeds";

  /** View and manage the provisioning of groups on your domain. */
  public static final String ADMIN_DIRECTORY_GROUP = "https://www.googleapis.com/auth/admin.directory.group";

  /** View and manage the provisioning of users on your domain. */
  public static final String ADMIN_DIRECTORY_USER = "https://www.googleapis.com/auth/admin.directory.user";

  /** View and manage the files in your Google Drive. */
  public static final String DRIVE = "https://www.googleapis.com/auth/drive";

  /** View and manage your forms in Google Drive. */
  public static final String FORMS = "https://www.googleapis.com/auth/forms";

  /** View and manage forms that this application has been installed in. */
  public static final String FORMS_CURRENTONLY = "https://www.googleapis.com/auth/forms.currentonly";

  /** View and manage your Google Groups. */
  public static final String GROUPS = "https://www.googleapis.com/auth/groups";

  /** View and manage your spreadsheets in Google Drive. */
  public static final String SPREADSHEETS = "https://www.googleapis.com/auth/spreadsheets";

  /** View your email address. */
  public static final String USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(MAIL_GOOGLE_COM);
    set.add(WWW_GOOGLE_COM_CALENDAR_FEEDS);
    set.add(WWW_GOOGLE_COM_M8_FEEDS);
    set.add(ADMIN_DIRECTORY_GROUP);
    set.add(ADMIN_DIRECTORY_USER);
    set.add(DRIVE);
    set.add(FORMS);
    set.add(FORMS_CURRENTONLY);
    set.add(GROUPS);
    set.add(SPREADSHEETS);
    set.add(USERINFO_EMAIL);
    return java.util.Collections.unmodifiableSet(set);
  }

  private ScriptScopes() {
  }
}
