/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.script;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.script.ScriptRequest;
import com.google.api.services.script.ScriptRequestInitializer;
import com.google.api.services.script.model.ExecutionRequest;
import com.google.api.services.script.model.Operation;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://script.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://script.googleapis.com/";

    public Script(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Script(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Scripts scripts() {
        return new Scripts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.18.0-rc of the Google Apps Script API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://script.googleapis.com/", Script.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Script build() {
            return new Script(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setScriptRequestInitializer(ScriptRequestInitializer scriptRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)scriptRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Scripts {
        public Run run(String string, ExecutionRequest executionRequest) throws IOException {
            Run run = new Run(string, executionRequest);
            Script.this.initialize((AbstractGoogleClientRequest<?>)run);
            return run;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Run
        extends ScriptRequest<Operation> {
            private static final String REST_PATH = "v1/scripts/{scriptId}:run";
            @Key
            private String scriptId;

            protected Run(String string, ExecutionRequest executionRequest) {
                super(Script.this, "POST", REST_PATH, (Object)executionRequest, Operation.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public Run set$Xgafv(String string) {
                return (Run)super.set$Xgafv(string);
            }

            public Run setAccessToken(String string) {
                return (Run)super.setAccessToken(string);
            }

            public Run setAlt(String string) {
                return (Run)super.setAlt(string);
            }

            public Run setBearerToken(String string) {
                return (Run)super.setBearerToken(string);
            }

            public Run setCallback(String string) {
                return (Run)super.setCallback(string);
            }

            public Run setFields(String string) {
                return (Run)super.setFields(string);
            }

            public Run setKey(String string) {
                return (Run)super.setKey(string);
            }

            public Run setOauthToken(String string) {
                return (Run)super.setOauthToken(string);
            }

            public Run setPp(Boolean bl) {
                return (Run)super.setPp(bl);
            }

            public Run setPrettyPrint(Boolean bl) {
                return (Run)super.setPrettyPrint(bl);
            }

            public Run setQuotaUser(String string) {
                return (Run)super.setQuotaUser(string);
            }

            public Run setUploadType(String string) {
                return (Run)super.setUploadType(string);
            }

            public Run setUploadProtocol(String string) {
                return (Run)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public Run setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            @Override
            public Run set(String string, Object object) {
                return (Run)super.set(string, object);
            }
        }
    }
}

